/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet;

import common.utils.GenUtils;
import common.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.MoneroRpcError;
import monero.common.SslOptions;
import monero.common.TaskLooper;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroBlockHeader;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroTx;
import monero.daemon.model.MoneroVersion;
import monero.wallet.MoneroWalletDefault;
import monero.wallet.model.MoneroAccount;
import monero.wallet.model.MoneroAccountTag;
import monero.wallet.model.MoneroAddressBookEntry;
import monero.wallet.model.MoneroCheckReserve;
import monero.wallet.model.MoneroCheckTx;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroIntegratedAddress;
import monero.wallet.model.MoneroKeyImageImportResult;
import monero.wallet.model.MoneroMessageSignatureResult;
import monero.wallet.model.MoneroMessageSignatureType;
import monero.wallet.model.MoneroMultisigInfo;
import monero.wallet.model.MoneroMultisigInitResult;
import monero.wallet.model.MoneroMultisigSignResult;
import monero.wallet.model.MoneroOutgoingTransfer;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroSubaddress;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTransferQuery;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxPriority;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletConfig;
import monero.wallet.model.MoneroWalletListenerI;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class MoneroWalletRpc
extends MoneroWalletDefault {
    private static final Logger LOGGER = Logger.getLogger(MoneroWalletRpc.class.getName());
    private static final TxHeightComparator TX_HEIGHT_COMPARATOR = new TxHeightComparator();
    private static final int ERROR_CODE_INVALID_PAYMENT_ID = -5;
    private static final long DEFAULT_SYNC_PERIOD_IN_MS = 20000L;
    private String path;
    private MoneroRpcConnection rpc;
    private MoneroRpcConnection daemonConnection;
    private WalletPoller walletPoller;
    private WalletRpcZmqListener zmqListener;
    private Map<Integer, Map<Integer, String>> addressCache;
    private Process process;
    private long syncPeriodInMs = 20000L;
    private Object SYNC_LOCK = new Object();

    public MoneroWalletRpc(String uri) {
        this(new MoneroRpcConnection(uri));
    }

    public MoneroWalletRpc(String uri, String username, String password) {
        this(new MoneroRpcConnection(uri, username, password));
    }

    public MoneroWalletRpc(String uri, String username, String password, String zmqUri) {
        this(new MoneroRpcConnection(uri, username, password, zmqUri));
    }

    public MoneroWalletRpc(MoneroRpcConnection rpc) {
        this.rpc = rpc;
        this.addressCache = new HashMap<Integer, Map<Integer, String>>();
    }

    public MoneroWalletRpc(List<String> cmd) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.environment().put("LANG", "en_US.UTF-8");
        pb.redirectErrorStream(true);
        this.process = pb.start();
        boolean printOutput = LOGGER.isLoggable(Level.FINER);
        String uri = null;
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        boolean success = false;
        while ((line = in.readLine()) != null) {
            LOGGER.log(Level.FINER, line);
            sb.append(line).append('\n');
            String uriLineContains = "Binding on ";
            int uriLineContainsIdx = line.indexOf(uriLineContains);
            if (uriLineContainsIdx >= 0) {
                String host = line.substring(uriLineContainsIdx + uriLineContains.length(), line.lastIndexOf(32));
                String port = line.substring(line.lastIndexOf(58) + 1);
                int sslIdx = cmd.indexOf("--rpc-ssl");
                boolean sslEnabled = sslIdx >= 0 ? "enabled".equalsIgnoreCase(cmd.get(sslIdx + 1)) : false;
                uri = (sslEnabled ? "https" : "http") + "://" + host + ":" + port;
            }
            if (!line.contains("Starting wallet RPC server")) continue;
            if (printOutput) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            BufferedReader in = new BufferedReader(new InputStreamReader(MoneroWalletRpc.this.process.getInputStream()));
                            while ((line = in.readLine()) != null) {
                                LOGGER.log(Level.FINER, line);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }).start();
            }
            success = true;
            break;
        }
        if (!printOutput) {
            in.close();
        }
        if (!success) {
            throw new MoneroError("Failed to start monero-wallet-rpc server:\n\n" + sb.toString().trim());
        }
        int userPassIdx = cmd.indexOf("--rpc-login");
        String userPass = userPassIdx >= 0 ? cmd.get(userPassIdx + 1) : null;
        String username = userPass == null ? null : userPass.substring(0, userPass.indexOf(58));
        String password = userPass == null ? null : userPass.substring(userPass.indexOf(58) + 1);
        int zmqUriIdx = cmd.indexOf("--zmq-pub");
        String zmqUri = zmqUriIdx >= 0 ? cmd.get(zmqUriIdx + 1) : null;
        this.rpc = new MoneroRpcConnection(uri, username, password, zmqUri);
        this.addressCache = new HashMap<Integer, Map<Integer, String>>();
    }

    public Process getProcess() {
        return this.process;
    }

    public int stopProcess() {
        return this.stopProcess(false);
    }

    public int stopProcess(boolean force) {
        if (this.process == null) {
            throw new MoneroError("MoneroWalletRpc instance not created from new process");
        }
        this.clear();
        if (force) {
            this.process.destroyForcibly();
        } else {
            this.process.destroy();
        }
        try {
            return this.process.waitFor();
        }
        catch (Exception e) {
            throw new MoneroError(e);
        }
    }

    public MoneroRpcConnection getRpcConnection() {
        return this.rpc;
    }

    public MoneroWalletRpc openWallet(String name, String password) {
        return this.openWallet(new MoneroWalletConfig().setPath(name).setPassword(password));
    }

    public MoneroWalletRpc openWallet(MoneroWalletConfig config) {
        if (config == null) {
            throw new MoneroError("Must provide configuration of wallet to open");
        }
        if (config.getPath() == null || config.getPath().isEmpty()) {
            throw new MoneroError("Filename is not initialized");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filename", config.getPath());
        params.put("password", config.getPassword() == null ? "" : config.getPassword());
        this.rpc.sendJsonRequest("open_wallet", params);
        this.clear();
        this.path = config.getPath();
        if (config.getConnectionManager() != null) {
            if (config.getServer() != null) {
                throw new MoneroError("Wallet can be opened with a server or connection manager but not both");
            }
            this.setConnectionManager(config.getConnectionManager());
        } else if (config.getServer() != null) {
            this.setDaemonConnection(config.getServer());
        }
        return this;
    }

    public MoneroWalletRpc createWallet(MoneroWalletConfig config) {
        if (config == null) {
            throw new MoneroError("Must specify config to create wallet");
        }
        if (config.getNetworkType() != null) {
            throw new MoneroError("Cannot specify network type when creating RPC wallet");
        }
        if (config.getSeed() != null && (config.getPrimaryAddress() != null || config.getPrivateViewKey() != null || config.getPrivateSpendKey() != null)) {
            throw new MoneroError("Wallet can be initialized with a seed or keys but not both");
        }
        if (config.getAccountLookahead() != null || config.getSubaddressLookahead() != null) {
            throw new MoneroError("monero-wallet-rpc does not support creating wallets with subaddress lookahead over rpc");
        }
        if (config.getConnectionManager() != null) {
            if (config.getServer() != null) {
                throw new MoneroError("Wallet can be created with a server or connection manager but not both");
            }
            config.setServer(config.getConnectionManager().getConnection());
        }
        if (config.getSeed() != null) {
            this.createWalletFromSeed(config);
        } else if (config.getPrivateSpendKey() != null || config.getPrimaryAddress() != null) {
            this.createWalletFromKeys(config);
        } else {
            this.createWalletRandom(config);
        }
        if (config.getConnectionManager() != null) {
            this.setConnectionManager(config.getConnectionManager());
        } else if (config.getServer() != null) {
            this.setDaemonConnection(config.getServer());
        }
        return this;
    }

    private MoneroWalletRpc createWalletRandom(MoneroWalletConfig config) {
        if ((config = config.copy()).getSeedOffset() != null) {
            throw new MoneroError("Cannot specify seed offset when creating random wallet");
        }
        if (config.getRestoreHeight() != null) {
            throw new MoneroError("Cannot specify restore height when creating random wallet");
        }
        if (Boolean.FALSE.equals(config.getSaveCurrent())) {
            throw new MoneroError("Current wallet is saved automatically when creating random wallet");
        }
        if (config.getPath() == null || config.getPath().isEmpty()) {
            throw new MoneroError("Wallet name is not initialized");
        }
        if (config.getLanguage() == null || config.getLanguage().isEmpty()) {
            config.setLanguage("English");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filename", config.getPath());
        params.put("password", config.getPassword());
        params.put("language", config.getLanguage());
        try {
            this.rpc.sendJsonRequest("create_wallet", params);
        }
        catch (MoneroRpcError e) {
            this.handleCreateWalletError(config.getPath(), e);
        }
        this.clear();
        this.path = config.getPath();
        return this;
    }

    private MoneroWalletRpc createWalletFromSeed(MoneroWalletConfig config) {
        if ((config = config.copy()).getLanguage() == null || config.getLanguage().isEmpty()) {
            config.setLanguage("English");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filename", config.getPath());
        params.put("password", config.getPassword());
        params.put("seed", config.getSeed());
        params.put("seed_offset", config.getSeedOffset());
        params.put("restore_height", config.getRestoreHeight());
        params.put("language", config.getLanguage());
        params.put("autosave_current", config.getSaveCurrent());
        params.put("enable_multisig_experimental", config.isMultisig());
        try {
            this.rpc.sendJsonRequest("restore_deterministic_wallet", params);
        }
        catch (MoneroRpcError e) {
            this.handleCreateWalletError(config.getPath(), e);
        }
        this.clear();
        this.path = config.getPath();
        return this;
    }

    private MoneroWalletRpc createWalletFromKeys(MoneroWalletConfig config) {
        if ((config = config.copy()).getSeedOffset() != null) {
            throw new MoneroError("Cannot specify seed offset when creating wallet from keys");
        }
        if (config.getRestoreHeight() == null) {
            config.setRestoreHeight(0L);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filename", config.getPath());
        params.put("password", config.getPassword());
        params.put("address", config.getPrimaryAddress());
        params.put("viewkey", config.getPrivateViewKey());
        params.put("spendkey", config.getPrivateSpendKey());
        params.put("restore_height", config.getRestoreHeight());
        params.put("autosave_current", config.getSaveCurrent());
        try {
            this.rpc.sendJsonRequest("generate_from_keys", params);
        }
        catch (MoneroRpcError e) {
            this.handleCreateWalletError(config.getPath(), e);
        }
        this.clear();
        this.path = config.getPath();
        return this;
    }

    private void handleCreateWalletError(String name, MoneroRpcError e) {
        if (e.getMessage().equals("Cannot create wallet. Already exists.")) {
            throw new MoneroRpcError("Wallet already exists: " + name, e.getCode(), e.getRpcMethod(), e.getRpcParams());
        }
        if (e.getMessage().equals("Electrum-style word list failed verification")) {
            throw new MoneroRpcError("Invalid mnemonic", e.getCode(), e.getRpcMethod(), e.getRpcParams());
        }
        throw e;
    }

    public List<String> getSeedLanguages() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_languages");
        Map result = (Map)resp.get("result");
        return (List)result.get("languages");
    }

    public void stop() {
        this.clear();
        this.rpc.sendJsonRequest("stop_wallet");
    }

    @Override
    public void addListener(MoneroWalletListenerI listener) {
        super.addListener(listener);
        this.refreshListening();
    }

    @Override
    public void removeListener(MoneroWalletListenerI listener) {
        super.removeListener(listener);
        this.refreshListening();
    }

    @Override
    public boolean isViewOnly() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("key_type", "mnemonic");
            this.rpc.sendJsonRequest("query_key", params);
            return false;
        }
        catch (MoneroError e) {
            if (Integer.valueOf(-29).equals(e.getCode())) {
                return true;
            }
            if (Integer.valueOf(-1).equals(e.getCode())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void setDaemonConnection(MoneroRpcConnection connection) {
        this.setDaemonConnection(connection, null, null);
    }

    public void setDaemonConnection(MoneroRpcConnection connection, Boolean isTrusted, SslOptions sslOptions) {
        if (sslOptions == null) {
            sslOptions = new SslOptions();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", connection == null ? "placeholder" : connection.getUri());
        params.put("username", connection == null ? "" : connection.getUsername());
        params.put("password", connection == null ? "" : connection.getPassword());
        params.put("trusted", isTrusted);
        params.put("ssl_support", "autodetect");
        params.put("ssl_private_key_path", sslOptions.getPrivateKeyPath());
        params.put("ssl_certificate_path", sslOptions.getCertificatePath());
        params.put("ssl_ca_file", sslOptions.getCertificateAuthorityFile());
        params.put("ssl_allowed_fingerprints", sslOptions.getAllowedFingerprints());
        params.put("ssl_allow_any_cert", sslOptions.getAllowAnyCert());
        this.rpc.sendJsonRequest("set_daemon", params);
        this.daemonConnection = connection == null || connection.getUri() == null || connection.getUri().isEmpty() ? null : new MoneroRpcConnection(connection);
    }

    @Override
    public void setProxyUri(String uri) {
        throw new MoneroError("MoneroWalletRpc.setProxyUri() not supported. Start monero-wallet-rpc with --proxy instead.");
    }

    @Override
    public MoneroRpcConnection getDaemonConnection() {
        return this.daemonConnection;
    }

    @Override
    public boolean isConnectedToDaemon() {
        try {
            this.checkReserveProof(this.getPrimaryAddress(), "", "");
            throw new RuntimeException("check reserve expected to fail");
        }
        catch (MoneroError e) {
            return !e.getMessage().contains("Failed to connect to daemon");
        }
    }

    @Override
    public MoneroVersion getVersion() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_version");
        Map result = (Map)resp.get("result");
        return new MoneroVersion(((BigInteger)result.get("version")).intValue(), (Boolean)result.get("release"));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSeed() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_type", "mnemonic");
        Map<String, Object> resp = this.rpc.sendJsonRequest("query_key", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("key");
    }

    @Override
    public String getSeedLanguage() {
        throw new MoneroError("MoneroWalletRpc.getSeedLanguage() not supported");
    }

    @Override
    public String getPrivateViewKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_type", "view_key");
        Map<String, Object> resp = this.rpc.sendJsonRequest("query_key", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("key");
    }

    @Override
    public String getPublicViewKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_type", "public_view_key");
        Map<String, Object> resp = this.rpc.sendJsonRequest("query_key", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("key");
    }

    @Override
    public String getPublicSpendKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_type", "public_spend_key");
        Map<String, Object> resp = this.rpc.sendJsonRequest("query_key", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("key");
    }

    @Override
    public String getPrivateSpendKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_type", "spend_key");
        Map<String, Object> resp = this.rpc.sendJsonRequest("query_key", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("key");
    }

    @Override
    public String getAddress(int accountIdx, int subaddressIdx) {
        Map<Integer, String> subaddressMap = this.addressCache.get(accountIdx);
        if (subaddressMap == null) {
            this.getSubaddresses(accountIdx, null, true);
            return this.getAddress(accountIdx, subaddressIdx);
        }
        String address = subaddressMap.get(subaddressIdx);
        if (address == null) {
            this.getSubaddresses(accountIdx, null, true);
            return this.addressCache.get(accountIdx).get(subaddressIdx);
        }
        return address;
    }

    @Override
    public MoneroSubaddress getAddressIndex(String address) {
        Map result;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("address", address);
            Map<String, Object> resp = this.rpc.sendJsonRequest("get_address_index", params);
            result = (Map)resp.get("result");
        }
        catch (MoneroRpcError e) {
            System.out.println(e.getMessage());
            if (Integer.valueOf(-2).equals(e.getCode())) {
                throw new MoneroError(e.getMessage(), e.getCode());
            }
            throw e;
        }
        Map rpcIndices = (Map)result.get("index");
        MoneroSubaddress subaddress = new MoneroSubaddress(address);
        subaddress.setAccountIndex(((BigInteger)rpcIndices.get("major")).intValue());
        subaddress.setIndex(((BigInteger)rpcIndices.get("minor")).intValue());
        return subaddress;
    }

    @Override
    public MoneroIntegratedAddress getIntegratedAddress(String standardAddress, String paymentId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("standard_address", standardAddress);
            params.put("payment_id", paymentId);
            Map<String, Object> resp = this.rpc.sendJsonRequest("make_integrated_address", params);
            Map result = (Map)resp.get("result");
            String integratedAddressStr = (String)result.get("integrated_address");
            return this.decodeIntegratedAddress(integratedAddressStr);
        }
        catch (MoneroRpcError e) {
            if (e.getMessage().contains("Invalid payment ID")) {
                throw new MoneroError("Invalid payment ID: " + paymentId, -5);
            }
            throw e;
        }
    }

    @Override
    public MoneroIntegratedAddress decodeIntegratedAddress(String integratedAddress) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("integrated_address", integratedAddress);
        Map<String, Object> resp = this.rpc.sendJsonRequest("split_integrated_address", params);
        Map result = (Map)resp.get("result");
        return new MoneroIntegratedAddress((String)result.get("standard_address"), (String)result.get("payment_id"), integratedAddress);
    }

    @Override
    public long getHeight() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_height");
        Map result = (Map)resp.get("result");
        return ((BigInteger)result.get("height")).longValue();
    }

    @Override
    public long getDaemonHeight() {
        throw new MoneroError("monero-wallet-rpc does not support getting the chain height");
    }

    @Override
    public long getHeightByDate(int year, int month, int day) {
        throw new MoneroError("monero-wallet-rpc does not support getting a height by date");
    }

    @Override
    public MoneroSyncResult sync(Long startHeight, MoneroWalletListenerI listener) {
        if (listener != null) {
            throw new MoneroError("Monero Wallet RPC does not support reporting sync progress");
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("start_height", startHeight);
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            try {
                Map<String, Object> resp = this.rpc.sendJsonRequest("refresh", params);
                this.poll();
                Map result = (Map)resp.get("result");
                return new MoneroSyncResult(((BigInteger)result.get("blocks_fetched")).longValue(), (Boolean)result.get("received_money"));
            }
            catch (MoneroError err) {
                if (err.getMessage().equals("no connection to daemon")) {
                    throw new MoneroError("Wallet is not connected to daemon");
                }
                throw err;
            }
        }
    }

    @Override
    public void startSyncing(Long syncPeriodInMs) {
        long syncPeriodInSeconds = (syncPeriodInMs == null ? 20000L : syncPeriodInMs) / 1000L;
        HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
        params.put("enable", Boolean.valueOf(true));
        params.put("period", Long.valueOf(syncPeriodInSeconds));
        this.rpc.sendJsonRequest("auto_refresh", params);
        this.syncPeriodInMs = syncPeriodInSeconds * 1000L;
        if (this.walletPoller != null) {
            this.walletPoller.setPeriodInMs(this.syncPeriodInMs);
        }
        this.poll();
    }

    @Override
    public void stopSyncing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("enable", false);
        this.rpc.sendJsonRequest("auto_refresh", params);
    }

    @Override
    public void scanTxs(Collection<String> txHashes) {
        if (txHashes == null || txHashes.isEmpty()) {
            throw new MoneroError("No tx hashes given to scan");
        }
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        params.put("txids", txHashes);
        this.rpc.sendJsonRequest("scan_tx", params);
        this.poll();
    }

    @Override
    public void rescanSpent() {
        this.rpc.sendJsonRequest("rescan_spent");
    }

    @Override
    public void rescanBlockchain() {
        this.rpc.sendJsonRequest("rescan_blockchain");
    }

    @Override
    public BigInteger getBalance(Integer accountIdx, Integer subaddressIdx) {
        return this.getBalances(accountIdx, subaddressIdx)[0];
    }

    @Override
    public BigInteger getUnlockedBalance(Integer accountIdx, Integer subaddressIdx) {
        return this.getBalances(accountIdx, subaddressIdx)[1];
    }

    @Override
    public List<MoneroAccount> getAccounts(boolean includeSubaddresses, String tag) {
        return this.getAccounts(includeSubaddresses, tag, false);
    }

    public List<MoneroAccount> getAccounts(boolean includeSubaddresses, String tag, boolean skipBalances) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tag", tag);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_accounts", params);
        Map result = (Map)resp.get("result");
        ArrayList<MoneroAccount> accounts = new ArrayList<MoneroAccount>();
        for (Map rpcAccount : (List)result.get("subaddress_accounts")) {
            MoneroAccount account = MoneroWalletRpc.convertRpcAccount(rpcAccount);
            if (includeSubaddresses) {
                account.setSubaddresses(this.getSubaddresses(account.getIndex(), null, true));
            }
            accounts.add(account);
        }
        if (includeSubaddresses && !skipBalances) {
            for (MoneroAccount account : accounts) {
                for (MoneroSubaddress subaddress : account.getSubaddresses()) {
                    subaddress.setBalance(BigInteger.valueOf(0L));
                    subaddress.setUnlockedBalance(BigInteger.valueOf(0L));
                    subaddress.setNumUnspentOutputs(0L);
                    subaddress.setNumBlocksToUnlock(0L);
                }
            }
            params.clear();
            params.put("all_accounts", true);
            resp = this.rpc.sendJsonRequest("get_balance", params);
            result = (Map)resp.get("result");
            if (result.containsKey("per_subaddress")) {
                for (Map rpcSubaddress : (List)result.get("per_subaddress")) {
                    MoneroSubaddress subaddress = MoneroWalletRpc.convertRpcSubaddress(rpcSubaddress);
                    MoneroAccount account = (MoneroAccount)accounts.get(subaddress.getAccountIndex());
                    GenUtils.assertEquals("RPC accounts are out of order", account.getIndex(), subaddress.getAccountIndex());
                    MoneroSubaddress tgtSubaddress = account.getSubaddresses().get(subaddress.getIndex());
                    GenUtils.assertEquals("RPC subaddresses are out of order", tgtSubaddress.getIndex(), subaddress.getIndex());
                    if (subaddress.getBalance() != null) {
                        tgtSubaddress.setBalance(subaddress.getBalance());
                    }
                    if (subaddress.getUnlockedBalance() != null) {
                        tgtSubaddress.setUnlockedBalance(subaddress.getUnlockedBalance());
                    }
                    if (subaddress.getNumUnspentOutputs() != null) {
                        tgtSubaddress.setNumUnspentOutputs(subaddress.getNumUnspentOutputs());
                    }
                    if (subaddress.getNumBlocksToUnlock() == null) continue;
                    tgtSubaddress.setNumBlocksToUnlock(subaddress.getNumBlocksToUnlock());
                }
            }
        }
        return accounts;
    }

    @Override
    public MoneroAccount getAccount(int accountIdx, boolean includeSubaddresses) {
        return this.getAccount(accountIdx, includeSubaddresses, false);
    }

    public MoneroAccount getAccount(int accountIdx, boolean includeSubaddresses, boolean skipBalances) {
        if (accountIdx < 0) {
            throw new MoneroError("Account index must be greater than or equal to 0");
        }
        for (MoneroAccount account : this.getAccounts()) {
            if (account.getIndex() != accountIdx) continue;
            if (includeSubaddresses) {
                account.setSubaddresses(this.getSubaddresses(accountIdx, null, skipBalances));
            }
            return account;
        }
        throw new MoneroError("Account with index " + accountIdx + " does not exist");
    }

    @Override
    public MoneroAccount createAccount(String label) {
        label = label == null || label.isEmpty() ? null : label;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("label", label);
        Map<String, Object> resp = this.rpc.sendJsonRequest("create_account", params);
        Map result = (Map)resp.get("result");
        return new MoneroAccount(((BigInteger)result.get("account_index")).intValue(), (String)result.get("address"), BigInteger.valueOf(0L), BigInteger.valueOf(0L), null);
    }

    @Override
    public List<MoneroSubaddress> getSubaddresses(int accountIdx, List<Integer> subaddressIndices) {
        return this.getSubaddresses(accountIdx, subaddressIndices, false);
    }

    public List<MoneroSubaddress> getSubaddresses(int accountIdx, List<Integer> subaddressIndices, boolean skipBalances) {
        Map<Integer, String> subaddressMap;
        MoneroSubaddress subaddress3;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account_index", accountIdx);
        if (subaddressIndices != null && !subaddressIndices.isEmpty()) {
            params.put("address_index", subaddressIndices);
        }
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_address", params);
        Map result = (Map)resp.get("result");
        ArrayList<MoneroSubaddress> subaddresses = new ArrayList<MoneroSubaddress>();
        for (Map rpcSubaddress : (List)result.get("addresses")) {
            subaddress3 = MoneroWalletRpc.convertRpcSubaddress(rpcSubaddress);
            subaddress3.setAccountIndex(accountIdx);
            subaddresses.add(subaddress3);
        }
        if (!skipBalances) {
            for (MoneroSubaddress subaddress2 : subaddresses) {
                subaddress2.setBalance(BigInteger.valueOf(0L));
                subaddress2.setUnlockedBalance(BigInteger.valueOf(0L));
                subaddress2.setNumUnspentOutputs(0L);
                subaddress2.setNumBlocksToUnlock(0L);
            }
            resp = this.rpc.sendJsonRequest("get_balance", params);
            result = (Map)resp.get("result");
            if (result.containsKey("per_subaddress")) {
                for (Map rpcSubaddress : (List)result.get("per_subaddress")) {
                    subaddress3 = MoneroWalletRpc.convertRpcSubaddress(rpcSubaddress);
                    for (MoneroSubaddress tgtSubaddress : subaddresses) {
                        if (!tgtSubaddress.getIndex().equals(subaddress3.getIndex())) continue;
                        if (subaddress3.getBalance() != null) {
                            tgtSubaddress.setBalance(subaddress3.getBalance());
                        }
                        if (subaddress3.getUnlockedBalance() != null) {
                            tgtSubaddress.setUnlockedBalance(subaddress3.getUnlockedBalance());
                        }
                        if (subaddress3.getNumUnspentOutputs() != null) {
                            tgtSubaddress.setNumUnspentOutputs(subaddress3.getNumUnspentOutputs());
                        }
                        if (subaddress3.getNumBlocksToUnlock() == null) continue;
                        tgtSubaddress.setNumBlocksToUnlock(subaddress3.getNumBlocksToUnlock());
                    }
                }
            }
        }
        if ((subaddressMap = this.addressCache.get(accountIdx)) == null) {
            subaddressMap = new HashMap<Integer, String>();
            this.addressCache.put(accountIdx, subaddressMap);
        }
        for (MoneroSubaddress subaddress3 : subaddresses) {
            subaddressMap.put(subaddress3.getIndex(), subaddress3.getAddress());
        }
        return subaddresses;
    }

    @Override
    public MoneroSubaddress createSubaddress(int accountIdx, String label) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account_index", accountIdx);
        params.put("label", label);
        Map<String, Object> resp = this.rpc.sendJsonRequest("create_address", params);
        Map result = (Map)resp.get("result");
        MoneroSubaddress subaddress = new MoneroSubaddress();
        subaddress.setAccountIndex(accountIdx);
        subaddress.setIndex(((BigInteger)result.get("address_index")).intValue());
        subaddress.setAddress((String)result.get("address"));
        subaddress.setLabel(label);
        subaddress.setBalance(BigInteger.valueOf(0L));
        subaddress.setUnlockedBalance(BigInteger.valueOf(0L));
        subaddress.setNumUnspentOutputs(0L);
        subaddress.setIsUsed(false);
        subaddress.setNumBlocksToUnlock(0L);
        return subaddress;
    }

    @Override
    public void setSubaddressLabel(int accountIdx, int subaddressIdx, String label) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Integer> idx = new HashMap<String, Integer>();
        idx.put("major", accountIdx);
        idx.put("minor", subaddressIdx);
        params.put("index", idx);
        params.put("label", label);
        this.rpc.sendJsonRequest("label_address", params);
    }

    @Override
    public List<MoneroTxWallet> getTxs(MoneroTxQuery query) {
        MoneroTxQuery moneroTxQuery = query = query == null ? new MoneroTxQuery() : query.copy();
        if (query.getInputQuery() != null) {
            query.getInputQuery().setTxQuery(query);
        }
        if (query.getOutputQuery() != null) {
            query.getOutputQuery().setTxQuery(query);
        }
        MoneroTransferQuery transferQuery = query.getTransferQuery();
        MoneroOutputQuery inputQuery = query.getInputQuery();
        MoneroOutputQuery outputQuery = query.getOutputQuery();
        query.setTransferQuery(null);
        query.setInputQuery(null);
        query.setOutputQuery(null);
        List<MoneroTransfer> transfers = this.getTransfersAux(new MoneroTransferQuery().setTxQuery(MoneroWalletRpc.decontextualize(query.copy())));
        ArrayList<MoneroTxWallet> txs = new ArrayList<MoneroTxWallet>();
        HashSet<MoneroTxWallet> txsSet = new HashSet<MoneroTxWallet>();
        for (MoneroTransfer transfer : transfers) {
            if (txsSet.contains(transfer.getTx())) continue;
            txs.add(transfer.getTx());
            txsSet.add(transfer.getTx());
        }
        HashMap<String, MoneroTxWallet> txMap = new HashMap<String, MoneroTxWallet>();
        HashMap<Long, MoneroBlock> blockMap = new HashMap<Long, MoneroBlock>();
        for (MoneroTxWallet tx : txs) {
            MoneroWalletRpc.mergeTx(tx, txMap, blockMap);
        }
        if (Boolean.TRUE.equals(query.getIncludeOutputs()) || outputQuery != null) {
            MoneroOutputQuery outputQueryAux = (outputQuery != null ? outputQuery.copy() : new MoneroOutputQuery()).setTxQuery(MoneroWalletRpc.decontextualize(query.copy()));
            Iterator outputs = this.getOutputsAux(outputQueryAux);
            HashSet<MoneroTxWallet> hashSet = new HashSet<MoneroTxWallet>();
            Iterator<Object> iterator = outputs.iterator();
            while (iterator.hasNext()) {
                MoneroOutputWallet output = iterator.next();
                if (hashSet.contains(output.getTx())) continue;
                MoneroWalletRpc.mergeTx(output.getTx(), txMap, blockMap);
                hashSet.add(output.getTx());
            }
        }
        query.setTransferQuery(transferQuery);
        query.setInputQuery(inputQuery);
        query.setOutputQuery(outputQuery);
        ArrayList<MoneroTxWallet> txsQueried = new ArrayList<MoneroTxWallet>();
        for (MoneroTxWallet moneroTxWallet : txs) {
            if (query.meetsCriteria(moneroTxWallet)) {
                txsQueried.add(moneroTxWallet);
                continue;
            }
            if (moneroTxWallet.getBlock() == null) continue;
            moneroTxWallet.getBlock().getTxs().remove(moneroTxWallet);
        }
        txs = txsQueried;
        for (MoneroTxWallet moneroTxWallet : txs) {
            if ((!moneroTxWallet.isConfirmed().booleanValue() || moneroTxWallet.getBlock() != null) && (moneroTxWallet.isConfirmed().booleanValue() || moneroTxWallet.getBlock() == null)) continue;
            LOGGER.warning("Inconsistency detected building txs from multiple rpc calls, re-fetching");
            return this.getTxs(query);
        }
        if (query.getHashes() != null && !query.getHashes().isEmpty()) {
            HashMap<String, MoneroTxWallet> txsById = new HashMap<String, MoneroTxWallet>();
            for (MoneroTxWallet tx : txs) {
                txsById.put(tx.getHash(), tx);
            }
            ArrayList<MoneroTxWallet> arrayList = new ArrayList<MoneroTxWallet>();
            for (String txHash : query.getHashes()) {
                if (txsById.get(txHash) == null) continue;
                arrayList.add((MoneroTxWallet)txsById.get(txHash));
            }
            txs = arrayList;
        }
        return txs;
    }

    @Override
    public List<MoneroTransfer> getTransfers(MoneroTransferQuery query) {
        if (!MoneroWalletRpc.isContextual(query = this.normalizeTransferQuery(query))) {
            return this.getTransfersAux(query);
        }
        ArrayList<MoneroTransfer> transfers = new ArrayList<MoneroTransfer>();
        query.getTxQuery().setTransferQuery(query);
        for (MoneroTxWallet tx : this.getTxs(query.getTxQuery())) {
            transfers.addAll(tx.filterTransfers(query));
        }
        return transfers;
    }

    @Override
    public List<MoneroOutputWallet> getOutputs(MoneroOutputQuery query) {
        if (!MoneroWalletRpc.isContextual(query)) {
            return this.getOutputsAux(query);
        }
        ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
        for (MoneroTxWallet tx : this.getTxs(query.getTxQuery())) {
            outputs.addAll(tx.filterOutputsWallet(query));
        }
        return outputs;
    }

    @Override
    public String exportOutputs(boolean all) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("all", all);
        Map<String, Object> resp = this.rpc.sendJsonRequest("export_outputs", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("outputs_data_hex");
    }

    @Override
    public int importOutputs(String outputsHex) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("outputs_data_hex", outputsHex);
        Map<String, Object> resp = this.rpc.sendJsonRequest("import_outputs", params);
        Map result = (Map)resp.get("result");
        return ((BigInteger)result.get("num_imported")).intValue();
    }

    @Override
    public List<MoneroKeyImage> exportKeyImages(boolean all) {
        return this.rpcExportKeyImages(all);
    }

    @Override
    public MoneroKeyImageImportResult importKeyImages(List<MoneroKeyImage> keyImages) {
        ArrayList rpcKeyImages = new ArrayList();
        for (MoneroKeyImage keyImage : keyImages) {
            HashMap<String, String> rpcKeyImage = new HashMap<String, String>();
            rpcKeyImage.put("key_image", keyImage.getHex());
            rpcKeyImage.put("signature", keyImage.getSignature());
            rpcKeyImages.add(rpcKeyImage);
        }
        HashMap params = new HashMap();
        params.put("signed_key_images", rpcKeyImages);
        Map<String, Object> resp = this.rpc.sendJsonRequest("import_key_images", params);
        Map result = (Map)resp.get("result");
        MoneroKeyImageImportResult importResult = new MoneroKeyImageImportResult();
        importResult.setHeight(((BigInteger)result.get("height")).longValue());
        importResult.setSpentAmount((BigInteger)result.get("spent"));
        importResult.setUnspentAmount((BigInteger)result.get("unspent"));
        return importResult;
    }

    @Override
    public List<MoneroKeyImage> getNewKeyImagesFromLastImport() {
        return this.rpcExportKeyImages(false);
    }

    @Override
    public void freezeOutput(String keyImage) {
        if (keyImage == null) {
            throw new MoneroError("Must specify key image to freeze");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_image", keyImage);
        this.rpc.sendJsonRequest("freeze", params);
    }

    @Override
    public void thawOutput(String keyImage) {
        if (keyImage == null) {
            throw new MoneroError("Must specify key image to thaw");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_image", keyImage);
        this.rpc.sendJsonRequest("thaw", params);
    }

    @Override
    public boolean isOutputFrozen(String keyImage) {
        if (keyImage == null) {
            throw new MoneroError("Must specify key image to check if frozen");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key_image", keyImage);
        Map<String, Object> resp = this.rpc.sendJsonRequest("frozen", params);
        Map result = (Map)resp.get("result");
        return Boolean.TRUE.equals(result.get("frozen"));
    }

    @Override
    public MoneroTxPriority getDefaultFeePriority() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_default_fee_priority");
        Map result = (Map)resp.get("result");
        int priority = ((BigInteger)result.get("priority")).intValue();
        return MoneroTxPriority.values()[priority];
    }

    @Override
    public List<MoneroTxWallet> createTxs(MoneroTxConfig config) {
        int numTxs;
        if (config == null) {
            throw new MoneroError("Send request cannot be null");
        }
        GenUtils.assertNotNull(config.getDestinations());
        GenUtils.assertNull(config.getSweepEachSubaddress());
        GenUtils.assertNull(config.getBelowAmount());
        if (config.getCanSplit() == null) {
            config = config.copy();
            config.setCanSplit(true);
        }
        if (Boolean.TRUE.equals(config.getRelay()) && this.isMultisig()) {
            throw new MoneroError("Cannot relay multisig transaction until co-signed");
        }
        Integer accountIdx = config.getAccountIndex();
        if (accountIdx == null) {
            throw new MoneroError("Must specify the account index to send from");
        }
        ArrayList<Integer> subaddressIndices = config.getSubaddressIndices() == null ? null : new ArrayList<Integer>(config.getSubaddressIndices());
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList destinationMaps = new ArrayList();
        params.put("destinations", destinationMaps);
        for (MoneroDestination destination : config.getDestinations()) {
            GenUtils.assertNotNull("Destination address is not defined", destination.getAddress());
            GenUtils.assertNotNull("Destination amount is not defined", destination.getAmount());
            HashMap<String, String> destinationMap = new HashMap<String, String>();
            destinationMap.put("address", destination.getAddress());
            destinationMap.put("amount", destination.getAmount().toString());
            destinationMaps.add(destinationMap);
        }
        if (config.getSubtractFeeFrom() != null) {
            params.put("subtract_fee_from_outputs", config.getSubtractFeeFrom());
        }
        params.put("account_index", accountIdx);
        params.put("subaddr_indices", subaddressIndices);
        params.put("payment_id", config.getPaymentId());
        params.put("do_not_relay", !Boolean.TRUE.equals(config.getRelay()));
        params.put("priority", config.getPriority() == null ? null : Integer.valueOf(config.getPriority().ordinal()));
        params.put("get_tx_hex", true);
        params.put("get_tx_metadata", true);
        if (config.getCanSplit().booleanValue()) {
            params.put("get_tx_keys", true);
        } else {
            params.put("get_tx_key", true);
        }
        if (config.getCanSplit().booleanValue() && config.getSubtractFeeFrom() != null && config.getSubtractFeeFrom().size() > 0) {
            throw new MoneroError("subtractfeefrom transfers cannot be split over multiple transactions yet");
        }
        Map result = null;
        try {
            Map<String, Object> resp = this.rpc.sendJsonRequest(config.getCanSplit() != false ? "transfer_split" : "transfer", params);
            result = (Map)resp.get("result");
        }
        catch (MoneroRpcError err) {
            if (err.getMessage().indexOf("WALLET_RPC_ERROR_CODE_WRONG_ADDRESS") > -1) {
                throw new MoneroError("Invalid destination address");
            }
            throw err;
        }
        ArrayList<MoneroTxWallet> txs = null;
        int n = config.getCanSplit().booleanValue() ? (result.containsKey("fee_list") ? ((List)result.get("fee_list")).size() : 0) : (numTxs = result.containsKey("fee") ? 1 : 0);
        if (numTxs > 0) {
            txs = new ArrayList<MoneroTxWallet>();
        }
        boolean copyDestinations = numTxs == 1;
        for (int i = 0; i < numTxs; ++i) {
            MoneroTxWallet tx = new MoneroTxWallet();
            MoneroWalletRpc.initSentTxWallet(config, tx, copyDestinations);
            tx.getOutgoingTransfer().setAccountIndex(accountIdx);
            if (subaddressIndices != null && subaddressIndices.size() == 1) {
                tx.getOutgoingTransfer().setSubaddressIndices(subaddressIndices);
            }
            txs.add(tx);
        }
        if (Boolean.TRUE.equals(config.getRelay())) {
            this.poll();
        }
        if (config.getCanSplit().booleanValue()) {
            return MoneroWalletRpc.convertRpcSentTxsToTxSet(result, txs, config).getTxs();
        }
        return MoneroWalletRpc.convertRpcTxToTxSet(result, txs == null ? null : (MoneroTxWallet)txs.get(0), true, config).getTxs();
    }

    @Override
    public MoneroTxWallet sweepOutput(MoneroTxConfig config) {
        GenUtils.assertNull(config.getSweepEachSubaddress());
        GenUtils.assertNull(config.getBelowAmount());
        GenUtils.assertNull("Splitting is not applicable when sweeping output", config.getCanSplit());
        if (config.getDestinations() == null || config.getDestinations().size() != 1 || config.getDestinations().get(0).getAddress() == null || config.getDestinations().get(0).getAddress().isEmpty()) {
            throw new MoneroError("Must provide exactly one destination address to sweep output to");
        }
        if (config.getSubtractFeeFrom() != null && config.getSubtractFeeFrom().size() > 0) {
            throw new MoneroError("Sweep transactions do not support subtracting fees from destinations");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", config.getDestinations().get(0).getAddress());
        params.put("account_index", config.getAccountIndex());
        params.put("subaddr_indices", config.getSubaddressIndices());
        params.put("key_image", config.getKeyImage());
        params.put("do_not_relay", !Boolean.TRUE.equals(config.getRelay()));
        params.put("priority", config.getPriority() == null ? null : Integer.valueOf(config.getPriority().ordinal()));
        params.put("payment_id", config.getPaymentId());
        params.put("get_tx_key", true);
        params.put("get_tx_hex", true);
        params.put("get_tx_metadata", true);
        Map<String, Object> resp = this.rpc.sendJsonRequest("sweep_single", params);
        Map result = (Map)resp.get("result");
        if (Boolean.TRUE.equals(config.getRelay())) {
            this.poll();
        }
        MoneroTxWallet tx = MoneroWalletRpc.initSentTxWallet(config, null, true);
        MoneroWalletRpc.convertRpcTxToTxSet(result, tx, true, config);
        tx.getOutgoingTransfer().getDestinations().get(0).setAmount(tx.getOutgoingTransfer().getAmount());
        return tx;
    }

    @Override
    public List<MoneroTxWallet> sweepUnlocked(MoneroTxConfig config) {
        if (config == null) {
            throw new MoneroError("Sweep request cannot be null");
        }
        if (config.getDestinations() == null || config.getDestinations().size() != 1) {
            throw new MoneroError("Must specify exactly one destination to sweep to");
        }
        if (config.getDestinations().get(0).getAddress() == null) {
            throw new MoneroError("Must specify destination address to sweep to");
        }
        if (config.getDestinations().get(0).getAmount() != null) {
            throw new MoneroError("Cannot specify amount in sweep request");
        }
        if (config.getKeyImage() != null) {
            throw new MoneroError("Key image defined; use sweepOutput() to sweep an output by its key image");
        }
        if (config.getSubaddressIndices() != null && config.getSubaddressIndices().isEmpty()) {
            config.setSubaddressIndices((List<Integer>)null);
        }
        if (config.getAccountIndex() == null && config.getSubaddressIndices() != null) {
            throw new MoneroError("Must specify account index if subaddress indices are specified");
        }
        if (config.getSubtractFeeFrom() != null && config.getSubtractFeeFrom().size() > 0) {
            throw new MoneroError("Sweep transactions do not support subtracting fees from destinations");
        }
        LinkedHashMap<Integer, List<Integer>> indices = new LinkedHashMap<Integer, List<Integer>>();
        if (config.getAccountIndex() != null) {
            if (config.getSubaddressIndices() != null) {
                indices.put(config.getAccountIndex(), config.getSubaddressIndices());
            } else {
                ArrayList<Integer> subaddressIndices = new ArrayList<Integer>();
                indices.put(config.getAccountIndex(), subaddressIndices);
                for (MoneroSubaddress subaddress : this.getSubaddresses(config.getAccountIndex())) {
                    if (subaddress.getUnlockedBalance().compareTo(BigInteger.valueOf(0L)) <= 0) continue;
                    subaddressIndices.add(subaddress.getIndex());
                }
            }
        } else {
            List accounts = this.getAccounts(true);
            for (MoneroAccount account : accounts) {
                if (account.getUnlockedBalance().compareTo(BigInteger.valueOf(0L)) <= 0) continue;
                ArrayList<Integer> subaddressIndices = new ArrayList<Integer>();
                indices.put(account.getIndex(), subaddressIndices);
                for (MoneroSubaddress subaddress : account.getSubaddresses()) {
                    if (subaddress.getUnlockedBalance().compareTo(BigInteger.valueOf(0L)) <= 0) continue;
                    subaddressIndices.add(subaddress.getIndex());
                }
            }
        }
        ArrayList<MoneroTxWallet> txs = new ArrayList<MoneroTxWallet>();
        for (Integer accountIdx : indices.keySet()) {
            MoneroTxConfig copy = config.copy();
            copy.setAccountIndex(accountIdx);
            copy.setSweepEachSubaddress(false);
            if (!Boolean.TRUE.equals(copy.getSweepEachSubaddress())) {
                copy.setSubaddressIndices((List)indices.get(accountIdx));
                txs.addAll(this.rpcSweepAccount(copy));
                continue;
            }
            Iterator<MoneroSubaddress> iterator = ((List)indices.get(accountIdx)).iterator();
            while (iterator.hasNext()) {
                int subaddressIdx = (Integer)((Object)iterator.next());
                copy.setSubaddressIndices(subaddressIdx);
                txs.addAll(this.rpcSweepAccount(copy));
            }
        }
        if (Boolean.TRUE.equals(config.getRelay())) {
            this.poll();
        }
        return txs;
    }

    @Override
    public List<MoneroTxWallet> sweepDust(boolean relay) {
        Map result;
        MoneroTxSet txSet;
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("do_not_relay", !relay);
        Map<String, Object> resp = this.rpc.sendJsonRequest("sweep_dust", params);
        if (relay) {
            this.poll();
        }
        if ((txSet = MoneroWalletRpc.convertRpcSentTxsToTxSet(result = (Map)resp.get("result"), null, null)).getTxs() == null) {
            return new ArrayList<MoneroTxWallet>();
        }
        for (MoneroTxWallet tx : txSet.getTxs()) {
            tx.setIsRelayed(relay);
            tx.setInTxPool(relay);
        }
        return txSet.getTxs();
    }

    @Override
    public List<String> relayTxs(Collection<String> txMetadatas) {
        if (txMetadatas == null || txMetadatas.isEmpty()) {
            throw new MoneroError("Must provide an array of tx metadata to relay");
        }
        ArrayList<String> txHashes = new ArrayList<String>();
        for (String txMetadata : txMetadatas) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("hex", txMetadata);
            Map<String, Object> resp = this.rpc.sendJsonRequest("relay_tx", params);
            Map result = (Map)resp.get("result");
            txHashes.add((String)result.get("tx_hash"));
        }
        this.poll();
        return txHashes;
    }

    @Override
    public MoneroTxSet describeTxSet(MoneroTxSet txSet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unsigned_txset", txSet.getUnsignedTxHex());
        params.put("multisig_txset", txSet.getMultisigTxHex());
        Map<String, Object> resp = this.rpc.sendJsonRequest("describe_transfer", params);
        return MoneroWalletRpc.convertRpcDescribeTransfer((Map)resp.get("result"));
    }

    @Override
    public MoneroTxSet signTxs(String unsignedTxHex) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unsigned_txset", unsignedTxHex);
        Map<String, Object> resp = this.rpc.sendJsonRequest("sign_transfer", params);
        Map result = (Map)resp.get("result");
        return MoneroWalletRpc.convertRpcSentTxsToTxSet(result, null, null);
    }

    @Override
    public List<String> submitTxs(String signedTxHex) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tx_data_hex", signedTxHex);
        Map<String, Object> resp = this.rpc.sendJsonRequest("submit_transfer", params);
        this.poll();
        Map result = (Map)resp.get("result");
        return (List)result.get("tx_hash_list");
    }

    @Override
    public String signMessage(String msg, MoneroMessageSignatureType signatureType, int accountIdx, int subaddressIdx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", msg);
        params.put("signature_type", signatureType == MoneroMessageSignatureType.SIGN_WITH_SPEND_KEY ? "spend" : "view");
        params.put("account_index", accountIdx);
        params.put("address_index", subaddressIdx);
        Map<String, Object> resp = this.rpc.sendJsonRequest("sign", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("signature");
    }

    @Override
    public MoneroMessageSignatureResult verifyMessage(String msg, String address, String signature) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", msg);
        params.put("address", address);
        params.put("signature", signature);
        try {
            Map<String, Object> resp = this.rpc.sendJsonRequest("verify", params);
            Map result = (Map)resp.get("result");
            boolean isGood = (Boolean)result.get("good");
            return new MoneroMessageSignatureResult(isGood, !isGood ? null : (Boolean)result.get("old"), !isGood || !result.containsKey("signature_type") ? null : ("view".equals(result.get("signature_type")) ? MoneroMessageSignatureType.SIGN_WITH_VIEW_KEY : MoneroMessageSignatureType.SIGN_WITH_SPEND_KEY), !isGood ? null : Integer.valueOf(((BigInteger)result.get("version")).intValue()));
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-2).equals(e.getCode())) {
                return new MoneroMessageSignatureResult(false, null, null, null);
            }
            throw e;
        }
    }

    @Override
    public String getTxKey(String txHash) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("txid", txHash);
            Map<String, Object> resp = this.rpc.sendJsonRequest("get_tx_key", params);
            Map result = (Map)resp.get("result");
            return (String)result.get("tx_key");
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-8).equals(e.getCode()) && e.getMessage().indexOf("TX ID has invalid format") != -1) {
                e = new MoneroRpcError("TX hash has invalid format", e.getCode(), e.getRpcMethod(), e.getRpcParams());
            }
            throw e;
        }
    }

    @Override
    public MoneroCheckTx checkTxKey(String txHash, String txKey, String address) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("txid", txHash);
            params.put("tx_key", txKey);
            params.put("address", address);
            Map<String, Object> resp = this.rpc.sendJsonRequest("check_tx_key", params);
            Map result = (Map)resp.get("result");
            MoneroCheckTx check = new MoneroCheckTx();
            check.setIsGood(true);
            check.setNumConfirmations(((BigInteger)result.get("confirmations")).longValue());
            check.setInTxPool((Boolean)result.get("in_pool"));
            check.setReceivedAmount((BigInteger)result.get("received"));
            return check;
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-8).equals(e.getCode()) && e.getMessage().indexOf("TX ID has invalid format") != -1) {
                e = new MoneroRpcError("TX hash has invalid format", e.getCode(), e.getRpcMethod(), e.getRpcParams());
            }
            throw e;
        }
    }

    @Override
    public String getTxProof(String txHash, String address, String message) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("txid", txHash);
            params.put("address", address);
            params.put("message", message);
            Map<String, Object> resp = this.rpc.sendJsonRequest("get_tx_proof", params);
            Map result = (Map)resp.get("result");
            return (String)result.get("signature");
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-8).equals(e.getCode()) && e.getMessage().indexOf("TX ID has invalid format") != -1) {
                e = new MoneroRpcError("TX hash has invalid format", e.getCode(), e.getRpcMethod(), e.getRpcParams());
            }
            throw e;
        }
    }

    @Override
    public MoneroCheckTx checkTxProof(String txHash, String address, String message, String signature) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("txid", txHash);
            params.put("address", address);
            params.put("message", message);
            params.put("signature", signature);
            Map<String, Object> resp = this.rpc.sendJsonRequest("check_tx_proof", params);
            Map result = (Map)resp.get("result");
            boolean isGood = (Boolean)result.get("good");
            MoneroCheckTx check = new MoneroCheckTx();
            check.setIsGood(isGood);
            if (isGood) {
                check.setNumConfirmations(((BigInteger)result.get("confirmations")).longValue());
                check.setInTxPool((boolean)((Boolean)result.get("in_pool")));
                check.setReceivedAmount((BigInteger)result.get("received"));
            }
            return check;
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-1).equals(e.getCode()) && e.getMessage().equals("basic_string")) {
                e = new MoneroRpcError("Must provide signature to check tx proof", -1, null, null);
            }
            if (Integer.valueOf(-8).equals(e.getCode()) && e.getMessage().indexOf("TX ID has invalid format") != -1) {
                e = new MoneroRpcError("TX hash has invalid format", e.getCode(), e.getRpcMethod(), e.getRpcParams());
            }
            throw e;
        }
    }

    @Override
    public String getSpendProof(String txHash, String message) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("txid", txHash);
            params.put("message", message);
            Map<String, Object> resp = this.rpc.sendJsonRequest("get_spend_proof", params);
            Map result = (Map)resp.get("result");
            return (String)result.get("signature");
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-8).equals(e.getCode()) && e.getMessage().indexOf("TX ID has invalid format") != -1) {
                e = new MoneroRpcError("TX hash has invalid format", e.getCode(), e.getRpcMethod(), e.getRpcParams());
            }
            throw e;
        }
    }

    @Override
    public boolean checkSpendProof(String txHash, String message, String signature) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("txid", txHash);
            params.put("message", message);
            params.put("signature", signature);
            Map<String, Object> resp = this.rpc.sendJsonRequest("check_spend_proof", params);
            Map result = (Map)resp.get("result");
            return (Boolean)result.get("good");
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-8).equals(e.getCode()) && e.getMessage().indexOf("TX ID has invalid format") != -1) {
                e = new MoneroRpcError("TX hash has invalid format", e.getCode(), e.getRpcMethod(), e.getRpcParams());
            }
            throw e;
        }
    }

    @Override
    public String getReserveProofWallet(String message) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("all", true);
        params.put("message", message);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_reserve_proof", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("signature");
    }

    @Override
    public String getReserveProofAccount(int accountIdx, BigInteger amount, String message) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account_index", accountIdx);
        params.put("amount", amount.toString());
        params.put("message", message);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_reserve_proof", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("signature");
    }

    @Override
    public MoneroCheckReserve checkReserveProof(String address, String message, String signature) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("address", address);
        params.put("message", message);
        params.put("signature", signature);
        Map<String, Object> resp = this.rpc.sendJsonRequest("check_reserve_proof", params);
        Map result = (Map)resp.get("result");
        boolean isGood = (Boolean)result.get("good");
        MoneroCheckReserve check = new MoneroCheckReserve();
        check.setIsGood(isGood);
        if (isGood) {
            check.setTotalAmount((BigInteger)result.get("total"));
            check.setUnconfirmedSpentAmount((BigInteger)result.get("spent"));
        }
        return check;
    }

    @Override
    public List<String> getTxNotes(List<String> txHashes) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("txids", txHashes);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_tx_notes", params);
        Map result = (Map)resp.get("result");
        return (List)result.get("notes");
    }

    @Override
    public void setTxNotes(List<String> txHashes, List<String> notes) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("txids", txHashes);
        params.put("notes", notes);
        this.rpc.sendJsonRequest("set_tx_notes", params);
    }

    @Override
    public List<MoneroAddressBookEntry> getAddressBookEntries(List<Integer> entryIndices) {
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        params.put("entries", entryIndices);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_address_book", params);
        Map resultMap = (Map)respMap.get("result");
        ArrayList<MoneroAddressBookEntry> entries = new ArrayList<MoneroAddressBookEntry>();
        if (!resultMap.containsKey("entries")) {
            return entries;
        }
        for (Map entryMap : (List)resultMap.get("entries")) {
            MoneroAddressBookEntry entry = new MoneroAddressBookEntry(((BigInteger)entryMap.get("index")).intValue(), (String)entryMap.get("address"), (String)entryMap.get("description"), (String)entryMap.get("payment_id"));
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public int addAddressBookEntry(String address, String description) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("address", address);
        params.put("description", description);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("add_address_book", params);
        Map resultMap = (Map)respMap.get("result");
        return ((BigInteger)resultMap.get("index")).intValue();
    }

    @Override
    public void editAddressBookEntry(int index, boolean setAddress, String address, boolean setDescription, String description) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("index", index);
        params.put("set_address", setAddress);
        params.put("address", address);
        params.put("set_description", setDescription);
        params.put("description", description);
        this.rpc.sendJsonRequest("edit_address_book", params);
    }

    @Override
    public void deleteAddressBookEntry(int entryIdx) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("index", entryIdx);
        this.rpc.sendJsonRequest("delete_address_book", params);
    }

    @Override
    public void tagAccounts(String tag, Collection<Integer> accountIndices) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tag", tag);
        params.put("accounts", accountIndices);
        this.rpc.sendJsonRequest("tag_accounts", params);
    }

    @Override
    public void untagAccounts(Collection<Integer> accountIndices) {
        HashMap<String, Collection<Integer>> params = new HashMap<String, Collection<Integer>>();
        params.put("accounts", accountIndices);
        this.rpc.sendJsonRequest("untag_accounts", params);
    }

    @Override
    public List<MoneroAccountTag> getAccountTags() {
        ArrayList<MoneroAccountTag> tags = new ArrayList<MoneroAccountTag>();
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_account_tags");
        Map resultMap = (Map)respMap.get("result");
        List accountTagMaps = (List)resultMap.get("account_tags");
        if (accountTagMaps != null) {
            for (Map accountTagMap : accountTagMaps) {
                MoneroAccountTag tag = new MoneroAccountTag();
                tags.add(tag);
                tag.setTag((String)accountTagMap.get("tag"));
                tag.setLabel((String)accountTagMap.get("label"));
                List accountIndicesBI = (List)accountTagMap.get("accounts");
                ArrayList<Integer> accountIndices = new ArrayList<Integer>();
                for (BigInteger idx : accountIndicesBI) {
                    accountIndices.add(idx.intValue());
                }
                tag.setAccountIndices(accountIndices);
            }
        }
        return tags;
    }

    @Override
    public void setAccountTagLabel(String tag, String label) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tag", tag);
        params.put("description", label);
        this.rpc.sendJsonRequest("set_account_tag_description", params);
    }

    @Override
    public String getPaymentUri(MoneroTxConfig config) {
        GenUtils.assertNotNull("Must provide send request to create a payment URI", config);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("address", config.getDestinations().get(0).getAddress());
        params.put("amount", config.getDestinations().get(0).getAmount() != null ? config.getDestinations().get(0).getAmount().toString() : null);
        params.put("payment_id", config.getPaymentId());
        params.put("recipient_name", config.getRecipientName());
        params.put("tx_description", config.getNote());
        Map<String, Object> resp = this.rpc.sendJsonRequest("make_uri", params);
        Map result = (Map)resp.get("result");
        return (String)result.get("uri");
    }

    @Override
    public MoneroTxConfig parsePaymentUri(String uri) {
        GenUtils.assertNotNull("Must provide URI to parse", uri);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uri", uri);
        Map<String, Object> resp = this.rpc.sendJsonRequest("parse_uri", params);
        Map result = (Map)resp.get("result");
        Map rpcUri = (Map)result.get("uri");
        MoneroTxConfig config = new MoneroTxConfig().setAddress((String)rpcUri.get("address")).setAmount((BigInteger)rpcUri.get("amount"));
        config.setPaymentId((String)rpcUri.get("payment_id"));
        config.setRecipientName((String)rpcUri.get("recipient_name"));
        config.setNote((String)rpcUri.get("tx_description"));
        if ("".equals(config.getDestinations().get(0).getAddress())) {
            config.getDestinations().get(0).setAddress(null);
        }
        if ("".equals(config.getPaymentId())) {
            config.setPaymentId(null);
        }
        if ("".equals(config.getRecipientName())) {
            config.setRecipientName(null);
        }
        if ("".equals(config.getNote())) {
            config.setNote(null);
        }
        return config;
    }

    @Override
    public String getAttribute(String key) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", key);
        try {
            Map<String, Object> resp = this.rpc.sendJsonRequest("get_attribute", params);
            Map result = (Map)resp.get("result");
            String value = (String)result.get("value");
            return value.isEmpty() ? null : value;
        }
        catch (MoneroRpcError e) {
            if (Integer.valueOf(-45).equals(e.getCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void setAttribute(String key, String val) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", key);
        params.put("value", val);
        this.rpc.sendJsonRequest("set_attribute", params);
    }

    @Override
    public void startMining(Long numThreads, Boolean backgroundMining, Boolean ignoreBattery) {
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("threads_count", numThreads);
        params.put("do_background_mining", backgroundMining);
        params.put("ignore_battery", ignoreBattery);
        this.rpc.sendJsonRequest("start_mining", params);
    }

    @Override
    public void stopMining() {
        this.rpc.sendJsonRequest("stop_mining");
    }

    @Override
    public boolean isMultisigImportNeeded() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_balance");
        Map result = (Map)resp.get("result");
        return Boolean.TRUE.equals(result.get("multisig_import_needed"));
    }

    @Override
    public MoneroMultisigInfo getMultisigInfo() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("is_multisig");
        Map result = (Map)resp.get("result");
        MoneroMultisigInfo info = new MoneroMultisigInfo();
        info.setIsMultisig((Boolean)result.get("multisig"));
        info.setIsReady((boolean)((Boolean)result.get("ready")));
        info.setThreshold(((BigInteger)result.get("threshold")).intValue());
        info.setNumParticipants(((BigInteger)result.get("total")).intValue());
        return info;
    }

    @Override
    public String prepareMultisig() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("enable_multisig_experimental", true);
        Map<String, Object> resp = this.rpc.sendJsonRequest("prepare_multisig", params);
        this.addressCache.clear();
        Map result = (Map)resp.get("result");
        return (String)result.get("multisig_info");
    }

    @Override
    public String makeMultisig(List<String> multisigHexes, int threshold, String password) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("multisig_info", multisigHexes);
        params.put("threshold", threshold);
        params.put("password", password);
        Map<String, Object> resp = this.rpc.sendJsonRequest("make_multisig", params);
        this.addressCache.clear();
        Map result = (Map)resp.get("result");
        return (String)result.get("multisig_info");
    }

    @Override
    public MoneroMultisigInitResult exchangeMultisigKeys(List<String> multisigHexes, String password) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("multisig_info", multisigHexes);
        params.put("password", password);
        Map<String, Object> resp = this.rpc.sendJsonRequest("exchange_multisig_keys", params);
        this.addressCache.clear();
        Map result = (Map)resp.get("result");
        MoneroMultisigInitResult msResult = new MoneroMultisigInitResult();
        msResult.setAddress((String)result.get("address"));
        msResult.setMultisigHex((String)result.get("multisig_info"));
        if (msResult.getAddress().isEmpty()) {
            msResult.setAddress(null);
        }
        if (msResult.getMultisigHex().isEmpty()) {
            msResult.setMultisigHex(null);
        }
        return msResult;
    }

    @Override
    public String exportMultisigHex() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("export_multisig_info");
        Map result = (Map)resp.get("result");
        return (String)result.get("info");
    }

    @Override
    public int importMultisigHex(List<String> multisigHexes) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("info", multisigHexes);
        Map<String, Object> resp = this.rpc.sendJsonRequest("import_multisig_info", params);
        Map result = (Map)resp.get("result");
        return ((BigInteger)result.get("n_outputs")).intValue();
    }

    @Override
    public MoneroMultisigSignResult signMultisigTxHex(String multisigTxHex) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tx_data_hex", multisigTxHex);
        Map<String, Object> resp = this.rpc.sendJsonRequest("sign_multisig", params);
        Map result = (Map)resp.get("result");
        MoneroMultisigSignResult signResult = new MoneroMultisigSignResult();
        signResult.setSignedMultisigTxHex((String)result.get("tx_data_hex"));
        signResult.setTxHashes((List)result.get("tx_hash_list"));
        return signResult;
    }

    @Override
    public List<String> submitMultisigTxHex(String signedMultisigTxHex) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tx_data_hex", signedMultisigTxHex);
        Map<String, Object> resp = this.rpc.sendJsonRequest("submit_multisig", params);
        Map result = (Map)resp.get("result");
        return (List)result.get("tx_hash_list");
    }

    @Override
    public void changePassword(String oldPassword, String newPassword) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("old_password", oldPassword);
        params.put("new_password", newPassword);
        this.rpc.sendJsonRequest("change_wallet_password", params);
    }

    @Override
    public void save() {
        this.rpc.sendJsonRequest("store");
    }

    @Override
    public void close(boolean save) {
        super.close(save);
        this.clear();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("autosave_current", save);
        this.rpc.sendJsonRequest("close_wallet", params);
    }

    @Override
    public boolean isClosed() {
        try {
            this.getPrimaryAddress();
        }
        catch (Exception e) {
            return e instanceof MoneroRpcError && Integer.valueOf(-8).equals(((MoneroRpcError)e).getCode()) && ((MoneroRpcError)e).getMessage().indexOf("No wallet file") > -1;
        }
        return false;
    }

    private void clear() {
        this.listeners.clear();
        this.refreshListening();
        this.addressCache.clear();
        this.path = null;
    }

    private Map<Integer, List<Integer>> getAccountIndices(boolean getSubaddressIndices) {
        HashMap<Integer, List<Integer>> indices = new HashMap<Integer, List<Integer>>();
        for (MoneroAccount account : this.getAccounts()) {
            indices.put(account.getIndex(), getSubaddressIndices ? this.getSubaddressIndices(account.getIndex()) : null);
        }
        return indices;
    }

    private List<Integer> getSubaddressIndices(int accountIdx) {
        ArrayList<Integer> subaddressIndices = new ArrayList<Integer>();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("account_index", accountIdx);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_address", params);
        Map result = (Map)resp.get("result");
        for (Map address : (List)result.get("addresses")) {
            subaddressIndices.add(((BigInteger)address.get("address_index")).intValue());
        }
        return subaddressIndices;
    }

    private List<MoneroKeyImage> rpcExportKeyImages(boolean all) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("all", all);
        Map<String, Object> resp = this.rpc.sendJsonRequest("export_key_images", params);
        Map result = (Map)resp.get("result");
        ArrayList<MoneroKeyImage> images = new ArrayList<MoneroKeyImage>();
        if (!result.containsKey("signed_key_images")) {
            return images;
        }
        for (Map rpcImage : (List)result.get("signed_key_images")) {
            images.add(new MoneroKeyImage((String)rpcImage.get("key_image"), (String)rpcImage.get("signature")));
        }
        return images;
    }

    private BigInteger[] getBalances(Integer accountIdx, Integer subaddressIdx) {
        Integer[] integerArray;
        if (accountIdx == null) {
            GenUtils.assertNull("Must provide account index with subaddress index", subaddressIdx);
            BigInteger balance = BigInteger.valueOf(0L);
            BigInteger unlockedBalance = BigInteger.valueOf(0L);
            for (MoneroAccount account : this.getAccounts()) {
                balance = balance.add(account.getBalance());
                unlockedBalance = unlockedBalance.add(account.getUnlockedBalance());
            }
            return new BigInteger[]{balance, unlockedBalance};
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account_index", accountIdx);
        if (subaddressIdx == null) {
            integerArray = null;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = subaddressIdx;
        }
        params.put("address_indices", integerArray);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_balance", params);
        Map result = (Map)resp.get("result");
        if (subaddressIdx == null) {
            return new BigInteger[]{(BigInteger)result.get("balance"), (BigInteger)result.get("unlocked_balance")};
        }
        List rpcBalancesPerSubaddress = (List)result.get("per_subaddress");
        return new BigInteger[]{(BigInteger)((Map)rpcBalancesPerSubaddress.get(0)).get("balance"), (BigInteger)((Map)rpcBalancesPerSubaddress.get(0)).get("unlocked_balance")};
    }

    private List<MoneroTransfer> getTransfersAux(MoneroTransferQuery query) {
        boolean canBeOutgoing;
        MoneroTxQuery txQuery;
        if (query == null) {
            query = new MoneroTransferQuery();
        } else if (query.getTxQuery() == null) {
            query = query.copy();
        } else {
            txQuery = query.getTxQuery().copy();
            if (query.getTxQuery().getTransferQuery() == query) {
                query = txQuery.getTransferQuery();
            } else {
                GenUtils.assertNull("Transfer query's tx query must be circular reference or null", query.getTxQuery().getTransferQuery());
                query = query.copy();
                query.setTxQuery(txQuery);
            }
        }
        if (query.getTxQuery() == null) {
            query.setTxQuery(new MoneroTxQuery());
        }
        txQuery = query.getTxQuery();
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean canBeConfirmed = !Boolean.FALSE.equals(txQuery.isConfirmed()) && !Boolean.TRUE.equals(txQuery.inTxPool()) && !Boolean.TRUE.equals(txQuery.isFailed()) && !Boolean.FALSE.equals(txQuery.isRelayed());
        boolean canBeInTxPool = !Boolean.TRUE.equals(txQuery.isConfirmed()) && !Boolean.FALSE.equals(txQuery.inTxPool()) && !Boolean.TRUE.equals(txQuery.isFailed()) && txQuery.getHeight() == null && txQuery.getMaxHeight() == null && !Boolean.FALSE.equals(txQuery.isLocked());
        boolean canBeIncoming = !Boolean.FALSE.equals(query.isIncoming()) && !Boolean.TRUE.equals(query.isOutgoing()) && !Boolean.TRUE.equals(query.hasDestinations());
        boolean bl = canBeOutgoing = !Boolean.FALSE.equals(query.isOutgoing()) && !Boolean.TRUE.equals(query.isIncoming());
        if (Boolean.TRUE.equals(txQuery.inTxPool()) && !canBeInTxPool) {
            throw new MoneroError("Cannot fetch pool transactions because it contradicts configuration");
        }
        params.put("in", canBeIncoming && canBeConfirmed);
        params.put("out", canBeOutgoing && canBeConfirmed);
        params.put("pool", canBeIncoming && canBeInTxPool);
        params.put("pending", canBeOutgoing && canBeInTxPool);
        params.put("failed", !Boolean.FALSE.equals(txQuery.isFailed()) && !Boolean.TRUE.equals(txQuery.isConfirmed()) && !Boolean.TRUE.equals(txQuery.inTxPool()));
        if (txQuery.getMinHeight() != null) {
            if (txQuery.getMinHeight() > 0L) {
                params.put("min_height", txQuery.getMinHeight() - 1L);
            } else {
                params.put("min_height", txQuery.getMinHeight());
            }
        }
        if (txQuery.getMaxHeight() != null) {
            params.put("max_height", txQuery.getMaxHeight());
        }
        params.put("filter_by_height", txQuery.getMinHeight() != null || txQuery.getMaxHeight() != null);
        if (query.getAccountIndex() == null) {
            GenUtils.assertTrue("Filter specifies a subaddress index but not an account index", query.getSubaddressIndex() == null && query.getSubaddressIndices() == null);
            params.put("all_accounts", true);
        } else {
            params.put("account_index", query.getAccountIndex());
            HashSet<Integer> subaddressIndices = new HashSet<Integer>();
            if (query.getSubaddressIndex() != null) {
                subaddressIndices.add(query.getSubaddressIndex());
            }
            if (query.getSubaddressIndices() != null) {
                for (int subaddressIdx : query.getSubaddressIndices()) {
                    subaddressIndices.add(subaddressIdx);
                }
            }
            if (!subaddressIndices.isEmpty()) {
                params.put("subaddr_indices", new ArrayList(subaddressIndices));
            }
        }
        HashMap<String, MoneroTxWallet> txMap = new HashMap<String, MoneroTxWallet>();
        HashMap<Long, MoneroBlock> blockMap = new HashMap<Long, MoneroBlock>();
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_transfers", params);
        Map result = (Map)resp.get("result");
        for (String key : result.keySet()) {
            for (Map rpcTx : (List)result.get(key)) {
                MoneroTxWallet tx = MoneroWalletRpc.convertRpcTxWithTransfer(rpcTx, null, null, null);
                if (tx.isConfirmed().booleanValue()) {
                    GenUtils.assertTrue(tx.getBlock().getTxs().contains(tx));
                }
                if (tx.getOutgoingTransfer() != null && Boolean.TRUE.equals(tx.isRelayed()) && !Boolean.TRUE.equals(tx.isFailed()) && tx.getOutgoingTransfer().getDestinations() != null && tx.getOutgoingAmount().compareTo(BigInteger.valueOf(0L)) == 0) {
                    MoneroOutgoingTransfer outgoingTransfer = tx.getOutgoingTransfer();
                    BigInteger transferTotal = BigInteger.valueOf(0L);
                    for (MoneroDestination destination : outgoingTransfer.getDestinations()) {
                        transferTotal = transferTotal.add(destination.getAmount());
                    }
                    tx.getOutgoingTransfer().setAmount(transferTotal);
                }
                MoneroWalletRpc.mergeTx(tx, txMap, blockMap);
            }
        }
        ArrayList txs = new ArrayList(txMap.values());
        Collections.sort(txs, new TxHeightComparator());
        ArrayList<MoneroTransfer> transfers = new ArrayList<MoneroTransfer>();
        for (MoneroTxWallet tx : txs) {
            if (tx.isIncoming() == null) {
                tx.setIsIncoming(false);
            }
            if (tx.isOutgoing() == null) {
                tx.setIsOutgoing(false);
            }
            if (tx.getIncomingTransfers() != null) {
                Collections.sort(tx.getIncomingTransfers(), new IncomingTransferComparator());
            }
            transfers.addAll(tx.filterTransfers(query));
            if (tx.getBlock() == null || tx.getOutgoingTransfer() != null || tx.getIncomingTransfers() != null) continue;
            tx.getBlock().getTxs().remove(tx);
        }
        return transfers;
    }

    private List<MoneroOutputWallet> getOutputsAux(MoneroOutputQuery query) {
        if (query == null) {
            query = new MoneroOutputQuery();
        } else if (query.getTxQuery() == null) {
            query = query.copy();
        } else {
            MoneroTxQuery txQuery = query.getTxQuery().copy();
            if (query.getTxQuery().getOutputQuery() == query) {
                query = txQuery.getOutputQuery();
            } else {
                GenUtils.assertNull("Output request's tx request must be circular reference or null", query.getTxQuery().getOutputQuery());
                query = query.copy();
                query.setTxQuery(txQuery);
            }
        }
        if (query.getTxQuery() == null) {
            query.setTxQuery(new MoneroTxQuery());
        }
        Map<Object, Object> indices = new HashMap();
        if (query.getAccountIndex() != null) {
            HashSet<Integer> subaddressIndices = new HashSet<Integer>();
            if (query.getSubaddressIndex() != null) {
                subaddressIndices.add(query.getSubaddressIndex());
            }
            if (query.getSubaddressIndices() != null) {
                for (int subaddressIdx : query.getSubaddressIndices()) {
                    subaddressIndices.add(subaddressIdx);
                }
            }
            indices.put(query.getAccountIndex(), subaddressIndices.isEmpty() ? null : new ArrayList(subaddressIndices));
        } else {
            GenUtils.assertEquals("Request specifies a subaddress index but not an account index", null, query.getSubaddressIndex());
            GenUtils.assertTrue("Request specifies subaddress indices but not an account index", query.getSubaddressIndices() == null || query.getSubaddressIndices().size() == 0);
            indices = this.getAccountIndices(false);
        }
        HashMap<String, MoneroTxWallet> txMap = new HashMap<String, MoneroTxWallet>();
        HashMap<Long, MoneroBlock> blockMap = new HashMap<Long, MoneroBlock>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String transferType = Boolean.TRUE.equals(query.isSpent()) ? "unavailable" : (Boolean.FALSE.equals(query.isSpent()) ? "available" : "all");
        params.put("transfer_type", transferType);
        params.put("verbose", true);
        Iterator<Object> iterator = indices.keySet().iterator();
        while (iterator.hasNext()) {
            int accountIdx = (Integer)iterator.next();
            params.put("account_index", accountIdx);
            params.put("subaddr_indices", indices.get(accountIdx));
            Map<String, Object> resp = this.rpc.sendJsonRequest("incoming_transfers", params);
            Map result = (Map)resp.get("result");
            if (!result.containsKey("transfers")) continue;
            for (Map rpcOutput : (List)result.get("transfers")) {
                MoneroTxWallet tx = MoneroWalletRpc.convertRpcTxWithOutput(rpcOutput);
                MoneroWalletRpc.mergeTx(tx, txMap, blockMap);
            }
        }
        ArrayList txs = new ArrayList(txMap.values());
        Collections.sort(txs, new TxHeightComparator());
        ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
        for (MoneroTxWallet tx : txs) {
            if (tx.getOutputs() != null) {
                Collections.sort(tx.getOutputs(), new OutputComparator());
            }
            outputs.addAll(tx.filterOutputsWallet(query));
            if (tx.getOutputs() != null || tx.getBlock() == null) continue;
            tx.getBlock().getTxs().remove(tx);
        }
        return outputs;
    }

    private List<MoneroTxWallet> rpcSweepAccount(MoneroTxConfig config) {
        if (config == null) {
            throw new MoneroError("Sweep request cannot be null");
        }
        if (config.getAccountIndex() == null) {
            throw new MoneroError("Must specify an account index to sweep from");
        }
        if (config.getDestinations() == null || config.getDestinations().size() != 1) {
            throw new MoneroError("Must specify exactly one destination to sweep to");
        }
        if (config.getDestinations().get(0).getAddress() == null) {
            throw new MoneroError("Must specify destination address to sweep to");
        }
        if (config.getDestinations().get(0).getAmount() != null) {
            throw new MoneroError("Cannot specify amount in sweep request");
        }
        if (config.getKeyImage() != null) {
            throw new MoneroError("Key image defined; use sweepOutput() to sweep an output by its key image");
        }
        if (config.getSubaddressIndices() != null && config.getSubaddressIndices().size() == 0) {
            throw new MoneroError("Empty list given for subaddresses indices to sweep");
        }
        if (Boolean.TRUE.equals(config.getSweepEachSubaddress())) {
            throw new MoneroError("Cannot sweep each subaddress with RPC `sweep_all`");
        }
        if (config.getSubtractFeeFrom() != null && config.getSubtractFeeFrom().size() > 0) {
            throw new MoneroError("Sweeping output does not support subtracting fees from destinations");
        }
        if (config.getSubaddressIndices() == null) {
            config.setSubaddressIndices(new ArrayList<Integer>());
            for (MoneroSubaddress subaddress : this.getSubaddresses(config.getAccountIndex())) {
                config.getSubaddressIndices().add(subaddress.getIndex());
            }
        }
        if (config.getSubaddressIndices().size() == 0) {
            throw new MoneroError("No subaddresses to sweep from");
        }
        boolean relay = Boolean.TRUE.equals(config.getRelay());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account_index", config.getAccountIndex());
        params.put("subaddr_indices", config.getSubaddressIndices());
        params.put("address", config.getDestinations().get(0).getAddress());
        params.put("priority", config.getPriority() == null ? null : Integer.valueOf(config.getPriority().ordinal()));
        params.put("payment_id", config.getPaymentId());
        params.put("do_not_relay", !relay);
        params.put("below_amount", config.getBelowAmount());
        params.put("get_tx_keys", true);
        params.put("get_tx_hex", true);
        params.put("get_tx_metadata", true);
        Map<String, Object> resp = this.rpc.sendJsonRequest("sweep_all", params);
        Map result = (Map)resp.get("result");
        MoneroTxSet txSet = MoneroWalletRpc.convertRpcSentTxsToTxSet(result, null, config);
        for (MoneroTxWallet tx : txSet.getTxs()) {
            tx.setIsLocked(true);
            tx.setIsConfirmed(false);
            tx.setNumConfirmations(0L);
            tx.setRelay(relay);
            tx.setInTxPool(relay);
            tx.setIsRelayed(relay);
            tx.setIsMinerTx(false);
            tx.setIsFailed(false);
            tx.setRingSize(12);
            MoneroOutgoingTransfer transfer = tx.getOutgoingTransfer();
            transfer.setAccountIndex(config.getAccountIndex());
            if (config.getSubaddressIndices().size() == 1) {
                transfer.setSubaddressIndices(new ArrayList<Integer>(config.getSubaddressIndices()));
            }
            MoneroDestination destination = new MoneroDestination(config.getDestinations().get(0).getAddress(), transfer.getAmount());
            transfer.setDestinations(Arrays.asList(destination));
            tx.setPaymentId(config.getPaymentId());
            if (tx.getUnlockTime() == null) {
                tx.setUnlockTime(BigInteger.valueOf(0L));
            }
            if (!tx.getRelay().booleanValue()) continue;
            if (tx.getLastRelayedTimestamp() == null) {
                tx.setLastRelayedTimestamp(System.currentTimeMillis());
            }
            if (tx.isDoubleSpendSeen() != null) continue;
            tx.setIsDoubleSpendSeen(false);
        }
        return txSet.getTxs();
    }

    private void refreshListening() {
        if (this.rpc.getZmqUri() == null) {
            if (this.walletPoller == null && this.listeners.size() > 0) {
                this.walletPoller = new WalletPoller(this);
            }
            if (this.walletPoller != null) {
                this.walletPoller.setIsPolling(this.listeners.size() > 0);
            }
        } else {
            if (this.zmqListener == null && this.listeners.size() > 0) {
                this.zmqListener = new WalletRpcZmqListener();
            }
            if (this.zmqListener != null) {
                this.zmqListener.setIsPolling(this.listeners.size() > 0);
            }
        }
    }

    private void poll() {
        if (this.walletPoller != null && this.walletPoller.isPolling) {
            this.walletPoller.poll();
        }
    }

    private static MoneroTxQuery decontextualize(MoneroTxQuery query) {
        query.setIsIncoming(null);
        query.setIsOutgoing(null);
        query.setTransferQuery(null);
        query.setInputQuery(null);
        query.setOutputQuery(null);
        return query;
    }

    private static boolean isContextual(MoneroTransferQuery query) {
        if (query == null) {
            return false;
        }
        if (query.getTxQuery() == null) {
            return false;
        }
        if (query.getTxQuery().isIncoming() != null) {
            return true;
        }
        if (query.getTxQuery().isOutgoing() != null) {
            return true;
        }
        if (query.getTxQuery().getInputQuery() != null) {
            return true;
        }
        return query.getTxQuery().getOutputQuery() != null;
    }

    private static boolean isContextual(MoneroOutputQuery query) {
        if (query == null) {
            return false;
        }
        if (query.getTxQuery() == null) {
            return false;
        }
        if (query.getTxQuery().isIncoming() != null) {
            return true;
        }
        if (query.getTxQuery().isOutgoing() != null) {
            return true;
        }
        return query.getTxQuery().getTransferQuery() != null;
    }

    private static MoneroAccount convertRpcAccount(Map<String, Object> rpcAccount) {
        MoneroAccount account = new MoneroAccount();
        for (String key : rpcAccount.keySet()) {
            Object val = rpcAccount.get(key);
            if (key.equals("account_index")) {
                account.setIndex(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("balance")) {
                account.setBalance((BigInteger)val);
                continue;
            }
            if (key.equals("unlocked_balance")) {
                account.setUnlockedBalance((BigInteger)val);
                continue;
            }
            if (key.equals("base_address")) {
                account.setPrimaryAddress((String)val);
                continue;
            }
            if (key.equals("tag")) {
                account.setTag((String)val);
                continue;
            }
            if (key.equals("label")) continue;
            LOGGER.warning("ignoring unexpected account field: " + key + ": " + val);
        }
        if ("".equals(account.getTag())) {
            account.setTag(null);
        }
        return account;
    }

    private static MoneroSubaddress convertRpcSubaddress(Map<String, Object> rpcSubaddress) {
        MoneroSubaddress subaddress = new MoneroSubaddress();
        for (String key : rpcSubaddress.keySet()) {
            Object val = rpcSubaddress.get(key);
            if (key.equals("account_index")) {
                subaddress.setAccountIndex(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("address_index")) {
                subaddress.setIndex(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("address")) {
                subaddress.setAddress((String)val);
                continue;
            }
            if (key.equals("balance")) {
                subaddress.setBalance((BigInteger)val);
                continue;
            }
            if (key.equals("unlocked_balance")) {
                subaddress.setUnlockedBalance((BigInteger)val);
                continue;
            }
            if (key.equals("num_unspent_outputs")) {
                subaddress.setNumUnspentOutputs(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("label")) {
                if ("".equals(val)) continue;
                subaddress.setLabel((String)val);
                continue;
            }
            if (key.equals("used")) {
                subaddress.setIsUsed((Boolean)val);
                continue;
            }
            if (key.equals("blocks_to_unlock")) {
                subaddress.setNumBlocksToUnlock(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("time_to_unlock")) continue;
            LOGGER.warning("ignoring unexpected subaddress field: " + key + ": " + val);
        }
        return subaddress;
    }

    private static MoneroTxWallet initSentTxWallet(MoneroTxConfig config, MoneroTxWallet tx, boolean copyDestinations) {
        if (tx == null) {
            tx = new MoneroTxWallet();
        }
        boolean relay = Boolean.TRUE.equals(config.getRelay());
        tx.setIsOutgoing(true);
        tx.setIsConfirmed(false);
        tx.setNumConfirmations(0L);
        tx.setInTxPool(relay);
        tx.setRelay(relay);
        tx.setIsRelayed(relay);
        tx.setIsMinerTx(false);
        tx.setIsFailed(false);
        tx.setIsLocked(true);
        tx.setRingSize(12);
        MoneroOutgoingTransfer transfer = new MoneroOutgoingTransfer().setTx(tx);
        if (config.getSubaddressIndices() != null && config.getSubaddressIndices().size() == 1) {
            transfer.setSubaddressIndices(new ArrayList<Integer>(config.getSubaddressIndices()));
        }
        if (copyDestinations) {
            ArrayList<MoneroDestination> destCopies = new ArrayList<MoneroDestination>();
            for (MoneroDestination dest : config.getDestinations()) {
                destCopies.add(dest.copy());
            }
            transfer.setDestinations(destCopies);
        }
        tx.setOutgoingTransfer(transfer);
        tx.setPaymentId(config.getPaymentId());
        if (tx.getUnlockTime() == null) {
            tx.setUnlockTime(BigInteger.valueOf(0L));
        }
        if (tx.getRelay().booleanValue()) {
            if (tx.getLastRelayedTimestamp() == null) {
                tx.setLastRelayedTimestamp(System.currentTimeMillis());
            }
            if (tx.isDoubleSpendSeen() == null) {
                tx.setIsDoubleSpendSeen(false);
            }
        }
        return tx;
    }

    private static MoneroTxSet convertRpcTxSet(Map<String, Object> rpcMap) {
        MoneroTxSet txSet = new MoneroTxSet();
        txSet.setMultisigTxHex((String)rpcMap.get("multisig_txset"));
        txSet.setUnsignedTxHex((String)rpcMap.get("unsigned_txset"));
        txSet.setSignedTxHex((String)rpcMap.get("signed_txset"));
        if (txSet.getMultisigTxHex() != null && txSet.getMultisigTxHex().isEmpty()) {
            txSet.setMultisigTxHex(null);
        }
        if (txSet.getUnsignedTxHex() != null && txSet.getUnsignedTxHex().isEmpty()) {
            txSet.setUnsignedTxHex(null);
        }
        if (txSet.getSignedTxHex() != null && txSet.getSignedTxHex().isEmpty()) {
            txSet.setSignedTxHex(null);
        }
        return txSet;
    }

    private static MoneroTxSet convertRpcSentTxsToTxSet(Map<String, Object> rpcTxs, List<MoneroTxWallet> txs, MoneroTxConfig config) {
        int numTxs;
        MoneroTxSet txSet = MoneroWalletRpc.convertRpcTxSet(rpcTxs);
        String numTxsKey = rpcTxs.containsKey("fee_list") ? "fee_list" : (rpcTxs.containsKey("tx_hash_list") ? "tx_hash_list" : null);
        int n = numTxs = numTxsKey == null ? 0 : ((List)rpcTxs.get(numTxsKey)).size();
        if (numTxs == 0) {
            GenUtils.assertNull(txs);
            return txSet;
        }
        if (txs != null) {
            txSet.setTxs(txs);
        } else {
            txs = new ArrayList<MoneroTxWallet>();
            for (int i = 0; i < numTxs; ++i) {
                txs.add(new MoneroTxWallet());
            }
        }
        for (MoneroTxWallet tx : txs) {
            tx.setTxSet(txSet);
            tx.setIsOutgoing(true);
        }
        txSet.setTxs(txs);
        for (String key : rpcTxs.keySet()) {
            int i;
            Object val = rpcTxs.get(key);
            if (key.equals("tx_hash_list")) {
                List hashes = (List)val;
                for (i = 0; i < hashes.size(); ++i) {
                    txs.get(i).setHash((String)hashes.get(i));
                }
                continue;
            }
            if (key.equals("tx_key_list")) {
                List keys = (List)val;
                for (i = 0; i < keys.size(); ++i) {
                    txs.get(i).setKey((String)keys.get(i));
                }
                continue;
            }
            if (key.equals("tx_blob_list")) {
                List blobs = (List)val;
                for (i = 0; i < blobs.size(); ++i) {
                    txs.get(i).setFullHex((String)blobs.get(i));
                }
                continue;
            }
            if (key.equals("tx_metadata_list")) {
                List metadatas = (List)val;
                for (i = 0; i < metadatas.size(); ++i) {
                    txs.get(i).setMetadata((String)metadatas.get(i));
                }
                continue;
            }
            if (key.equals("fee_list")) {
                List fees = (List)val;
                for (i = 0; i < fees.size(); ++i) {
                    txs.get(i).setFee((BigInteger)fees.get(i));
                }
                continue;
            }
            if (key.equals("amount_list")) {
                List amounts = (List)val;
                for (i = 0; i < amounts.size(); ++i) {
                    if (txs.get(i).getOutgoingTransfer() == null) {
                        txs.get(i).setOutgoingTransfer(new MoneroOutgoingTransfer().setTx(txs.get(i)));
                    }
                    txs.get(i).getOutgoingTransfer().setAmount((BigInteger)amounts.get(i));
                }
                continue;
            }
            if (key.equals("weight_list")) {
                List weights = (List)val;
                for (i = 0; i < weights.size(); ++i) {
                    txs.get(i).setWeight(((BigInteger)weights.get(i)).longValue());
                }
                continue;
            }
            if (key.equals("multisig_txset") || key.equals("unsigned_txset") || key.equals("signed_txset")) continue;
            if (key.equals("spent_key_images_list")) {
                List inputKeyImagesList = (List)val;
                for (i = 0; i < inputKeyImagesList.size(); ++i) {
                    GenUtils.assertTrue(txs.get(i).getInputs() == null);
                    txs.get(i).setInputsWallet(new ArrayList<MoneroOutputWallet>());
                    for (String inputKeyImage : (List)((Map)inputKeyImagesList.get(i)).get("key_images")) {
                        txs.get(i).getInputs().add(new MoneroOutputWallet().setKeyImage(new MoneroKeyImage().setHex(inputKeyImage)).setTx(txs.get(i)));
                    }
                }
                continue;
            }
            if (key.equals("amounts_by_dest_list")) {
                List amountsByDestList = (List)val;
                int destinationIdx = 0;
                for (int txIdx = 0; txIdx < amountsByDestList.size(); ++txIdx) {
                    List amountsByDest = (List)((Map)amountsByDestList.get(txIdx)).get("amounts");
                    if (txs.get(txIdx).getOutgoingTransfer() == null) {
                        txs.get(txIdx).setOutgoingTransfer(new MoneroOutgoingTransfer().setTx(txs.get(txIdx)));
                    }
                    txs.get(txIdx).getOutgoingTransfer().setDestinations(new ArrayList<MoneroDestination>());
                    for (BigInteger amount : amountsByDest) {
                        if (config.getDestinations().size() == 1) {
                            txs.get(txIdx).getOutgoingTransfer().getDestinations().add(new MoneroDestination(config.getDestinations().get(0).getAddress(), amount));
                            continue;
                        }
                        txs.get(txIdx).getOutgoingTransfer().getDestinations().add(new MoneroDestination(config.getDestinations().get(destinationIdx++).getAddress(), amount));
                    }
                }
                continue;
            }
            LOGGER.warning("ignoring unexpected transaction list field: " + key + ": " + val);
        }
        return txSet;
    }

    private static MoneroTxSet convertRpcTxToTxSet(Map<String, Object> rpcTx, MoneroTxWallet tx, Boolean isOutgoing, MoneroTxConfig config) {
        MoneroTxSet txSet = MoneroWalletRpc.convertRpcTxSet(rpcTx);
        txSet.setTxs(Arrays.asList(MoneroWalletRpc.convertRpcTxWithTransfer(rpcTx, tx, isOutgoing, config).setTxSet(txSet)));
        return txSet;
    }

    private static MoneroTxWallet convertRpcTxWithTransfer(Map<String, Object> rpcTx, MoneroTxWallet tx, Boolean isOutgoing, MoneroTxConfig config) {
        if (tx == null) {
            tx = new MoneroTxWallet();
        }
        if (rpcTx.containsKey("type")) {
            isOutgoing = MoneroWalletRpc.decodeRpcType((String)rpcTx.get("type"), tx);
        } else {
            GenUtils.assertNotNull("Must indicate if tx is outgoing (true) xor incoming (false) since unknown", isOutgoing);
        }
        MoneroBlockHeader header = null;
        MoneroTransfer transfer = null;
        for (String key : rpcTx.keySet()) {
            Object val = rpcTx.get(key);
            if (key.equals("txid")) {
                tx.setHash((String)val);
                continue;
            }
            if (key.equals("tx_hash")) {
                tx.setHash((String)val);
                continue;
            }
            if (key.equals("fee")) {
                tx.setFee((BigInteger)val);
                continue;
            }
            if (key.equals("note")) {
                if ("".equals(val)) continue;
                tx.setNote((String)val);
                continue;
            }
            if (key.equals("tx_key")) {
                tx.setKey((String)val);
                continue;
            }
            if (key.equals("type")) continue;
            if (key.equals("tx_size")) {
                tx.setSize(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("unlock_time")) {
                tx.setUnlockTime((BigInteger)val);
                continue;
            }
            if (key.equals("weight")) {
                tx.setWeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("locked")) {
                tx.setIsLocked((Boolean)val);
                continue;
            }
            if (key.equals("tx_blob")) {
                tx.setFullHex((String)val);
                continue;
            }
            if (key.equals("tx_metadata")) {
                tx.setMetadata((String)val);
                continue;
            }
            if (key.equals("double_spend_seen")) {
                tx.setIsDoubleSpendSeen((Boolean)val);
                continue;
            }
            if (key.equals("block_height") || key.equals("height")) {
                if (!tx.isConfirmed().booleanValue()) continue;
                if (header == null) {
                    header = new MoneroBlockHeader();
                }
                header.setHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("timestamp")) {
                if (!tx.isConfirmed().booleanValue()) continue;
                if (header == null) {
                    header = new MoneroBlockHeader();
                }
                header.setTimestamp(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("confirmations")) {
                tx.setNumConfirmations(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("suggested_confirmations_threshold")) {
                if (transfer == null) {
                    transfer = (isOutgoing != false ? new MoneroOutgoingTransfer() : new MoneroIncomingTransfer()).setTx(tx);
                }
                if (isOutgoing.booleanValue()) continue;
                ((MoneroIncomingTransfer)transfer).setNumSuggestedConfirmations(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("amount")) {
                if (transfer == null) {
                    transfer = (isOutgoing != false ? new MoneroOutgoingTransfer() : new MoneroIncomingTransfer()).setTx(tx);
                }
                transfer.setAmount((BigInteger)val);
                continue;
            }
            if (key.equals("amounts")) continue;
            if (key.equals("address")) {
                if (isOutgoing.booleanValue()) continue;
                if (transfer == null) {
                    transfer = new MoneroIncomingTransfer().setTx(tx);
                }
                ((MoneroIncomingTransfer)transfer).setAddress((String)val);
                continue;
            }
            if (key.equals("payment_id")) {
                if ("".equals(val) || "0000000000000000".equals(val)) continue;
                tx.setPaymentId((String)val);
                continue;
            }
            if (key.equals("subaddr_index")) {
                GenUtils.assertTrue(rpcTx.containsKey("subaddr_indices"));
                continue;
            }
            if (key.equals("subaddr_indices")) {
                if (transfer == null) {
                    transfer = (isOutgoing != false ? new MoneroOutgoingTransfer() : new MoneroIncomingTransfer()).setTx(tx);
                }
                List rpcIndices = (List)val;
                transfer.setAccountIndex(((BigInteger)((Map)rpcIndices.get(0)).get("major")).intValue());
                if (isOutgoing.booleanValue()) {
                    ArrayList<Integer> subaddressIndices = new ArrayList<Integer>();
                    for (Map rpcIndex : rpcIndices) {
                        subaddressIndices.add(((BigInteger)rpcIndex.get("minor")).intValue());
                    }
                    ((MoneroOutgoingTransfer)transfer).setSubaddressIndices(subaddressIndices);
                    continue;
                }
                GenUtils.assertEquals(1, rpcIndices.size());
                ((MoneroIncomingTransfer)transfer).setSubaddressIndex(((BigInteger)((Map)rpcIndices.get(0)).get("minor")).intValue());
                continue;
            }
            if (key.equals("destinations") || key.equals("recipients")) {
                GenUtils.assertTrue(isOutgoing);
                ArrayList<MoneroDestination> destinations = new ArrayList<MoneroDestination>();
                for (Map rpcDestination : (List)val) {
                    MoneroDestination destination = new MoneroDestination();
                    destinations.add(destination);
                    for (String destinationKey : rpcDestination.keySet()) {
                        if (destinationKey.equals("address")) {
                            destination.setAddress((String)rpcDestination.get(destinationKey));
                            continue;
                        }
                        if (destinationKey.equals("amount")) {
                            destination.setAmount((BigInteger)rpcDestination.get(destinationKey));
                            continue;
                        }
                        throw new MoneroError("Unrecognized transaction destination field: " + destinationKey);
                    }
                }
                if (transfer == null) {
                    transfer = new MoneroOutgoingTransfer().setTx(tx);
                }
                ((MoneroOutgoingTransfer)transfer).setDestinations(destinations);
                continue;
            }
            if (key.equals("multisig_txset") && val != null || key.equals("unsigned_txset") && val != null) continue;
            if (key.equals("amount_in")) {
                tx.setInputSum((BigInteger)val);
                continue;
            }
            if (key.equals("amount_out")) {
                tx.setOutputSum((BigInteger)val);
                continue;
            }
            if (key.equals("change_address")) {
                tx.setChangeAddress("".equals(val) ? null : (String)val);
                continue;
            }
            if (key.equals("change_amount")) {
                tx.setChangeAmount((BigInteger)val);
                continue;
            }
            if (key.equals("dummy_outputs")) {
                tx.setNumDummyOutputs(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("extra")) {
                tx.setExtraHex((String)val);
                continue;
            }
            if (key.equals("ring_size")) {
                tx.setRingSize(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("spent_key_images")) {
                List inputKeyImages = (List)((Map)val).get("key_images");
                GenUtils.assertTrue(tx.getInputs() == null);
                tx.setInputs((List)new ArrayList());
                for (String inputKeyImage : inputKeyImages) {
                    tx.getInputs().add(new MoneroOutputWallet().setKeyImage(new MoneroKeyImage().setHex(inputKeyImage)).setTx(tx));
                }
                continue;
            }
            if (key.equals("amounts_by_dest")) {
                GenUtils.assertTrue(isOutgoing);
                List amountsByDest = (List)((Map)val).get("amounts");
                GenUtils.assertEquals(config.getDestinations().size(), amountsByDest.size());
                if (transfer == null) {
                    transfer = new MoneroOutgoingTransfer().setTx(tx);
                }
                ((MoneroOutgoingTransfer)transfer).setDestinations(new ArrayList<MoneroDestination>());
                for (int i = 0; i < config.getDestinations().size(); ++i) {
                    ((MoneroOutgoingTransfer)transfer).getDestinations().add(new MoneroDestination(config.getDestinations().get(i).getAddress(), (BigInteger)amountsByDest.get(i)));
                }
                continue;
            }
            LOGGER.warning("ignoring unexpected transaction field with transfer: " + key + ": " + val);
        }
        if (header != null) {
            tx.setBlock(new MoneroBlock(header).setTxs(tx));
        }
        if (transfer != null) {
            if (tx.isConfirmed() == null) {
                tx.setIsConfirmed(false);
            }
            if (!transfer.getTx().isConfirmed().booleanValue()) {
                tx.setNumConfirmations(0L);
            }
            if (isOutgoing.booleanValue()) {
                tx.setIsOutgoing(true);
                if (tx.getOutgoingTransfer() != null) {
                    if (((MoneroOutgoingTransfer)transfer).getDestinations() != null) {
                        tx.getOutgoingTransfer().setDestinations(null);
                    }
                    tx.getOutgoingTransfer().merge(transfer);
                } else {
                    tx.setOutgoingTransfer((MoneroOutgoingTransfer)transfer);
                }
            } else {
                tx.setIsIncoming(true);
                tx.setIncomingTransfers(new ArrayList<MoneroIncomingTransfer>(Arrays.asList((MoneroIncomingTransfer)transfer)));
            }
        }
        return tx;
    }

    private static MoneroTxWallet convertRpcTxWithOutput(Map<String, Object> rpcOutput) {
        MoneroTxWallet tx = new MoneroTxWallet();
        tx.setIsConfirmed(true);
        tx.setIsRelayed(true);
        tx.setIsFailed(false);
        MoneroOutputWallet output = new MoneroOutputWallet().setTx(tx);
        for (String key : rpcOutput.keySet()) {
            Object val = rpcOutput.get(key);
            if (key.equals("amount")) {
                output.setAmount((BigInteger)val);
                continue;
            }
            if (key.equals("spent")) {
                output.setIsSpent((Boolean)val);
                continue;
            }
            if (key.equals("key_image")) {
                if ("".equals(val)) continue;
                output.setKeyImage(new MoneroKeyImage((String)val));
                continue;
            }
            if (key.equals("global_index")) {
                output.setIndex(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("tx_hash")) {
                tx.setHash((String)val);
                continue;
            }
            if (key.equals("unlocked")) {
                tx.setIsLocked((Boolean)val == false);
                continue;
            }
            if (key.equals("frozen")) {
                output.setIsFrozen((Boolean)val);
                continue;
            }
            if (key.equals("pubkey")) {
                output.setStealthPublicKey((String)val);
                continue;
            }
            if (key.equals("subaddr_index")) {
                Map rpcIndices = (Map)val;
                output.setAccountIndex(((BigInteger)rpcIndices.get("major")).intValue());
                output.setSubaddressIndex(((BigInteger)rpcIndices.get("minor")).intValue());
                continue;
            }
            if (key.equals("block_height")) {
                long height = ((BigInteger)val).longValue();
                tx.setBlock(new MoneroBlock().setHeight(height).setTxs(tx));
                continue;
            }
            LOGGER.warning("ignoring unexpected transaction field with output: " + key + ": " + val);
        }
        ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
        outputs.add(output);
        tx.setOutputs(outputs);
        return tx;
    }

    private static MoneroTxSet convertRpcDescribeTransfer(Map<String, Object> rpcDescribeTransferResult) {
        MoneroTxSet txSet = new MoneroTxSet();
        for (String key : rpcDescribeTransferResult.keySet()) {
            Object val = rpcDescribeTransferResult.get(key);
            if (key.equals("desc")) {
                txSet.setTxs(new ArrayList<MoneroTxWallet>());
                for (Map txMap : (List)val) {
                    MoneroTxWallet tx = MoneroWalletRpc.convertRpcTxWithTransfer(txMap, null, true, null);
                    tx.setTxSet(txSet);
                    txSet.getTxs().add(tx);
                }
                continue;
            }
            if (key.equals("summary")) continue;
            LOGGER.warning("ignoring unexpected describe transfer field: " + key + ": " + val);
        }
        return txSet;
    }

    private static boolean decodeRpcType(String rpcType, MoneroTxWallet tx) {
        boolean isOutgoing;
        if (rpcType.equals("in")) {
            isOutgoing = false;
            tx.setIsConfirmed(true);
            tx.setInTxPool(false);
            tx.setIsRelayed(true);
            tx.setRelay(true);
            tx.setIsFailed(false);
            tx.setIsMinerTx(false);
        } else if (rpcType.equals("out")) {
            isOutgoing = true;
            tx.setIsConfirmed(true);
            tx.setInTxPool(false);
            tx.setIsRelayed(true);
            tx.setRelay(true);
            tx.setIsFailed(false);
            tx.setIsMinerTx(false);
        } else if (rpcType.equals("pool")) {
            isOutgoing = false;
            tx.setIsConfirmed(false);
            tx.setInTxPool(true);
            tx.setIsRelayed(true);
            tx.setRelay(true);
            tx.setIsFailed(false);
            tx.setIsMinerTx(false);
        } else if (rpcType.equals("pending")) {
            isOutgoing = true;
            tx.setIsConfirmed(false);
            tx.setInTxPool(true);
            tx.setIsRelayed(true);
            tx.setRelay(true);
            tx.setIsFailed(false);
            tx.setIsMinerTx(false);
        } else if (rpcType.equals("block")) {
            isOutgoing = false;
            tx.setIsConfirmed(true);
            tx.setInTxPool(false);
            tx.setIsRelayed(true);
            tx.setRelay(true);
            tx.setIsFailed(false);
            tx.setIsMinerTx(true);
        } else if (rpcType.equals("failed")) {
            isOutgoing = true;
            tx.setIsConfirmed(false);
            tx.setInTxPool(false);
            tx.setIsRelayed(true);
            tx.setRelay(true);
            tx.setIsFailed(true);
            tx.setIsMinerTx(false);
        } else {
            throw new MoneroError("Unrecognized transfer type: " + rpcType);
        }
        return isOutgoing;
    }

    private static void mergeTx(MoneroTxWallet tx, Map<String, MoneroTxWallet> txMap, Map<Long, MoneroBlock> blockMap) {
        GenUtils.assertNotNull(tx.getHash());
        MoneroTxWallet aTx = txMap.get(tx.getHash());
        if (aTx == null) {
            txMap.put(tx.getHash(), tx);
        } else {
            aTx.merge(tx);
        }
        if (tx.getHeight() != null) {
            MoneroBlock aBlock = blockMap.get(tx.getHeight());
            if (aBlock == null) {
                blockMap.put(tx.getHeight(), tx.getBlock());
            } else {
                aBlock.merge(tx.getBlock());
            }
        }
    }

    private static class TxHeightComparator
    implements Comparator<MoneroTx> {
        private TxHeightComparator() {
        }

        @Override
        public int compare(MoneroTx tx1, MoneroTx tx2) {
            if (tx1.getHeight() == null && tx2.getHeight() == null) {
                return 0;
            }
            if (tx1.getHeight() == null) {
                return 1;
            }
            if (tx2.getHeight() == null) {
                return -1;
            }
            int diff = tx1.getHeight().compareTo(tx2.getHeight());
            if (diff != 0) {
                return diff;
            }
            return tx1.getBlock().getTxs().indexOf(tx1) - tx2.getBlock().getTxs().indexOf(tx2);
        }
    }

    private class WalletPoller {
        private MoneroWalletDefault wallet;
        private boolean isPolling;
        private TaskLooper looper;
        private int numPolling = 0;
        private Long prevHeight;
        private BigInteger[] prevBalances;
        private List<MoneroTxWallet> prevLockedTxs = new ArrayList<MoneroTxWallet>();
        private Set<String> prevUnconfirmedNotifications = new HashSet<String>();
        private Set<String> prevConfirmedNotifications = new HashSet<String>();

        public WalletPoller(MoneroWalletDefault wallet) {
            this.wallet = wallet;
            this.looper = new TaskLooper(new Runnable(){

                @Override
                public void run() {
                    WalletPoller.this.poll();
                }
            });
        }

        public void setIsPolling(boolean isPolling) {
            this.isPolling = isPolling;
            if (isPolling) {
                this.looper.start(MoneroWalletRpc.this.syncPeriodInMs);
            } else {
                this.looper.stop();
            }
        }

        public void setPeriodInMs(long periodInMs) {
            this.looper.setPeriodInMs(periodInMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void poll() {
            if (this.numPolling > 1) {
                return;
            }
            ++this.numPolling;
            WalletPoller walletPoller = this;
            synchronized (walletPoller) {
                block13: {
                    try {
                        if (this.wallet.isClosed()) {
                            --this.numPolling;
                            return;
                        }
                        if (this.prevBalances == null) {
                            this.prevHeight = MoneroWalletRpc.this.getHeight();
                            this.prevLockedTxs = MoneroWalletRpc.this.getTxs(new MoneroTxQuery().setIsLocked(true));
                            this.prevBalances = MoneroWalletRpc.this.getBalances(null, null);
                            --this.numPolling;
                            return;
                        }
                        long height = MoneroWalletRpc.this.getHeight();
                        if (this.prevHeight != height) {
                            for (long i = this.prevHeight.longValue(); i < height; ++i) {
                                this.onNewBlock(i);
                            }
                            this.prevHeight = height;
                        }
                        long minHeight = Math.max(0L, height - 70L);
                        List<MoneroTxWallet> lockedTxs = MoneroWalletRpc.this.getTxs(new MoneroTxQuery().setIsLocked(true).setMinHeight(minHeight).setIncludeOutputs(true));
                        ArrayList<String> noLongerLockedHashes = new ArrayList<String>();
                        for (MoneroTxWallet prevLockedTx : this.prevLockedTxs) {
                            if (this.getTx(lockedTxs, prevLockedTx.getHash()) != null) continue;
                            noLongerLockedHashes.add(prevLockedTx.getHash());
                        }
                        this.prevLockedTxs = lockedTxs;
                        ArrayList unlockedTxs = noLongerLockedHashes.isEmpty() ? new ArrayList() : MoneroWalletRpc.this.getTxs(new MoneroTxQuery().setIsLocked(false).setMinHeight(minHeight).setHashes(noLongerLockedHashes).setIncludeOutputs(true));
                        for (MoneroTxWallet lockedTx : lockedTxs) {
                            boolean unannounced = lockedTx.isConfirmed() != false ? this.prevConfirmedNotifications.add(lockedTx.getHash()) : this.prevUnconfirmedNotifications.add(lockedTx.getHash());
                            if (!unannounced) continue;
                            this.notifyOutputs(lockedTx);
                        }
                        for (MoneroTxWallet unlockedTx : unlockedTxs) {
                            this.prevUnconfirmedNotifications.remove(unlockedTx.getHash());
                            this.prevConfirmedNotifications.remove(unlockedTx.getHash());
                            this.notifyOutputs(unlockedTx);
                        }
                        this.checkForChangedBalances();
                        --this.numPolling;
                    }
                    catch (Exception e) {
                        --this.numPolling;
                        if (!this.isPolling) break block13;
                        System.err.println("Failed to background poll wallet '" + MoneroWalletRpc.this.path + "': " + e.getMessage());
                    }
                }
            }
        }

        private void notifyOutputs(MoneroTxWallet tx) {
            block6: {
                if (tx.getOutgoingTransfer() != null) {
                    GenUtils.assertNull(tx.getInputs());
                    MoneroOutputWallet output = new MoneroOutputWallet().setAmount(tx.getOutgoingTransfer().getAmount().add(tx.getFee())).setAccountIndex(tx.getOutgoingTransfer().getAccountIndex()).setSubaddressIndex(tx.getOutgoingTransfer().getSubaddressIndices().size() == 1 ? tx.getOutgoingTransfer().getSubaddressIndices().get(0) : null).setTx(tx);
                    tx.setInputsWallet(Arrays.asList(output));
                    MoneroWalletRpc.this.announceOutputSpent(output);
                }
                if (tx.getIncomingTransfers() == null) break block6;
                if (tx.getOutputs() != null && !tx.getOutputs().isEmpty()) {
                    for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                        MoneroWalletRpc.this.announceOutputReceived(output);
                    }
                } else {
                    ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
                    for (MoneroIncomingTransfer transfer : tx.getIncomingTransfers()) {
                        outputs.add(new MoneroOutputWallet().setAccountIndex(transfer.getAccountIndex()).setSubaddressIndex(transfer.getSubaddressIndex()).setAmount(transfer.getAmount()).setTx(tx));
                    }
                    tx.setOutputsWallet(outputs);
                    for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                        MoneroWalletRpc.this.announceOutputReceived(output);
                    }
                }
            }
        }

        private void onNewBlock(long height) {
            MoneroWalletRpc.this.announceNewBlock(height);
        }

        private MoneroTxWallet getTx(List<MoneroTxWallet> txs, String txHash) {
            for (MoneroTxWallet tx : txs) {
                if (!txHash.equals(tx.getHash())) continue;
                return tx;
            }
            return null;
        }

        private boolean checkForChangedBalances() {
            BigInteger[] balances = MoneroWalletRpc.this.getBalances(null, null);
            if (!balances[0].equals(this.prevBalances[0]) || !balances[1].equals(this.prevBalances[1])) {
                this.prevBalances = balances;
                MoneroWalletRpc.this.announceBalancesChanged(balances[0], balances[1]);
                return true;
            }
            return false;
        }
    }

    public static class IncomingTransferComparator
    implements Comparator<MoneroIncomingTransfer> {
        @Override
        public int compare(MoneroIncomingTransfer t1, MoneroIncomingTransfer t2) {
            int heightComparison = TX_HEIGHT_COMPARATOR.compare(t1.getTx(), t2.getTx());
            if (heightComparison != 0) {
                return heightComparison;
            }
            if (t1.getAccountIndex() < t2.getAccountIndex()) {
                return -1;
            }
            if (t1.getAccountIndex() == t2.getAccountIndex()) {
                return t1.getSubaddressIndex().compareTo(t2.getSubaddressIndex());
            }
            return 1;
        }
    }

    public static class OutputComparator
    implements Comparator<MoneroOutput> {
        @Override
        public int compare(MoneroOutput o1, MoneroOutput o2) {
            MoneroOutputWallet ow1 = (MoneroOutputWallet)o1;
            MoneroOutputWallet ow2 = (MoneroOutputWallet)o2;
            int heightComparison = TX_HEIGHT_COMPARATOR.compare(ow1.getTx(), ow2.getTx());
            if (heightComparison != 0) {
                return heightComparison;
            }
            int compare = ow1.getAccountIndex().compareTo(ow2.getAccountIndex());
            if (compare != 0) {
                return compare;
            }
            compare = ow1.getSubaddressIndex().compareTo(ow2.getSubaddressIndex());
            if (compare != 0) {
                return compare;
            }
            compare = ow1.getIndex().compareTo(ow2.getIndex());
            if (compare != 0) {
                return compare;
            }
            return ow1.getKeyImage().getHex().compareTo(ow2.getKeyImage().getHex());
        }
    }

    private class WalletRpcZmqListener {
        private boolean isPolling;
        private Thread pollThread;
        private ExecutorService processNotificationPool;
        private ZContext context;
        private ZMQ.Socket subscriber;
        private BigInteger prevBalance;
        private BigInteger prevUnlockedBalance;
        private List<String> prevLockedTxHashes = new ArrayList<String>();

        public WalletRpcZmqListener() {
            this.prevBalance = MoneroWalletRpc.this.getBalance();
            this.prevUnlockedBalance = MoneroWalletRpc.this.getUnlockedBalance();
        }

        public void setIsPolling(boolean isPolling) {
            if (isPolling) {
                this.start();
            } else {
                this.stop();
            }
        }

        private void start() {
            if (this.isPolling) {
                return;
            }
            this.isPolling = true;
            this.checkForChangedUnlockedTxs();
            this.processNotificationPool = Executors.newFixedThreadPool(1);
            this.pollThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    WalletRpcZmqListener.this.context = new ZContext();
                    WalletRpcZmqListener.this.subscriber = WalletRpcZmqListener.this.context.createSocket(SocketType.SUB);
                    WalletRpcZmqListener.this.subscriber.connect(MoneroWalletRpc.this.getRpcConnection().getZmqUri());
                    WalletRpcZmqListener.this.subscriber.subscribe("json-minimal-chain_main".getBytes());
                    WalletRpcZmqListener.this.subscriber.subscribe("json-full-money_received".getBytes());
                    WalletRpcZmqListener.this.subscriber.subscribe("json-full-money_spent".getBytes());
                    WalletRpcZmqListener.this.subscriber.subscribe("json-full-unconfirmed_money_received".getBytes());
                    ZMQ.Poller poller = WalletRpcZmqListener.this.context.createPoller(1);
                    poller.register(WalletRpcZmqListener.this.subscriber, 1);
                    while (!Thread.currentThread().isInterrupted() && WalletRpcZmqListener.this.isPolling) {
                        try {
                            poller.poll();
                            if (!poller.pollin(0)) continue;
                            final String notification = WalletRpcZmqListener.this.subscriber.recvStr();
                            WalletRpcZmqListener.this.processNotificationPool.submit(new Runnable(){

                                @Override
                                public void run() {
                                    WalletRpcZmqListener.this.processZmqNotification(notification);
                                }
                            });
                        }
                        catch (Exception e) {
                            if (Thread.currentThread().isInterrupted() || !WalletRpcZmqListener.this.isPolling) continue;
                            throw e;
                        }
                    }
                    WalletRpcZmqListener.this.stop();
                }
            });
            this.pollThread.start();
        }

        private void stop() {
            if (!this.isPolling) {
                return;
            }
            this.isPolling = false;
            this.subscriber.close();
            this.context.close();
            this.prevLockedTxHashes.clear();
            this.processNotificationPool.shutdown();
            this.pollThread.interrupt();
        }

        private void processZmqNotification(String content) {
            System.out.println("Processing zmq notification: " + content);
            int bodyIdx = content.indexOf(":");
            String topic = content.substring(0, bodyIdx);
            if (content.substring(bodyIdx + 1).isEmpty()) {
                System.out.println("WARNING: empty body to parse zmq notification");
                return;
            }
            if (topic.equals("json-minimal-chain_main")) {
                Map<String, Object> contentMap = JsonUtils.toMap(MoneroRpcConnection.MAPPER, content.substring(bodyIdx + 1));
                long height = ((BigInteger)contentMap.get("first_height")).longValue();
                MoneroWalletRpc.this.announceNewBlock(height);
                boolean balancesChanged = this.checkForChangedBalances();
                if (balancesChanged) {
                    this.checkForChangedUnlockedTxs();
                }
            } else {
                Map<String, Object> contentMap = JsonUtils.toMap(MoneroRpcConnection.MAPPER, content.substring(bodyIdx + 1));
                Map txMap = (Map)(contentMap.containsKey("tx_in") ? contentMap.get("tx_in") : contentMap.get("tx"));
                MoneroOutputWallet output = new MoneroOutputWallet();
                output.setAmount((BigInteger)contentMap.get("amount"));
                output.setAccountIndex(((BigInteger)contentMap.get("subaddr_index_major")).intValue());
                output.setSubaddressIndex(((BigInteger)contentMap.get("subaddr_index_minor")).intValue());
                MoneroTxWallet tx = new MoneroTxWallet();
                tx.setHash((String)contentMap.get("txid"));
                tx.setVersion(((BigInteger)txMap.get("version")).intValue());
                tx.setUnlockTime((BigInteger)txMap.get("unlock_time"));
                output.setTx(tx);
                tx.setOutputs((List)Arrays.asList(output));
                long height = ((BigInteger)contentMap.get("height")).longValue();
                tx.setIsLocked(true);
                if (height > 0L) {
                    MoneroBlock block = new MoneroBlock().setHeight(height);
                    block.setTxs(Arrays.asList(tx));
                    tx.setBlock(block);
                    tx.setIsConfirmed(true);
                    tx.setInTxPool(false);
                    tx.setIsFailed(false);
                } else {
                    tx.setIsConfirmed(false);
                    tx.setInTxPool(true);
                }
                if (topic.equals("json-full-money_received")) {
                    tx.setIsIncoming(true);
                    this.prevLockedTxHashes.add(tx.getHash());
                    MoneroWalletRpc.this.announceOutputReceived(output);
                } else if (topic.equals("json-full-money_spent")) {
                    tx.setIsIncoming(false);
                    this.prevLockedTxHashes.add(tx.getHash());
                    MoneroWalletRpc.this.announceOutputSpent(output);
                } else if (topic.equals("json-full-unconfirmed_money_received")) {
                    tx.setIsIncoming(true);
                    MoneroWalletRpc.this.announceOutputReceived(output);
                    this.checkForChangedBalances();
                } else {
                    LOGGER.warning("Received unsupported notification: " + content);
                }
            }
        }

        private boolean checkForChangedBalances() {
            BigInteger balance = MoneroWalletRpc.this.getBalance();
            BigInteger unlockedBalance = MoneroWalletRpc.this.getUnlockedBalance();
            if (!balance.equals(this.prevBalance) || !unlockedBalance.equals(this.prevUnlockedBalance)) {
                this.prevBalance = balance;
                this.prevUnlockedBalance = unlockedBalance;
                MoneroWalletRpc.this.announceBalancesChanged(balance, unlockedBalance);
                return true;
            }
            return false;
        }

        private void checkForChangedUnlockedTxs() {
            List<MoneroTxWallet> lockedTxs = MoneroWalletRpc.this.getTxs(new MoneroTxQuery().setIsLocked(true).setIsConfirmed(true));
            ArrayList<String> txHashesNoLongerLocked = new ArrayList<String>();
            for (String prevLockedTxHash : this.prevLockedTxHashes) {
                boolean found = false;
                for (MoneroTxWallet lockedTx : lockedTxs) {
                    if (!lockedTx.getHash().equals(prevLockedTxHash)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                txHashesNoLongerLocked.add(prevLockedTxHash);
            }
            List<Object> txsNoLongerLocked = new ArrayList();
            if (!txHashesNoLongerLocked.isEmpty()) {
                MoneroTxQuery query = new MoneroTxQuery().setHashes(txHashesNoLongerLocked).setIsLocked(false).setIsConfirmed(true).setIncludeOutputs(true);
                txsNoLongerLocked = MoneroWalletRpc.this.getTxs(query);
            }
            for (MoneroTxWallet unlockedTx : txsNoLongerLocked) {
                for (MoneroOutputWallet output : unlockedTx.getOutputsWallet()) {
                    MoneroWalletRpc.this.announceOutputReceived(output);
                }
            }
            this.prevLockedTxHashes.clear();
            for (MoneroTxWallet lockedTx : lockedTxs) {
                this.prevLockedTxHashes.add(lockedTx.getHash());
            }
        }
    }
}

