/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet;

import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import monero.common.MoneroConnectionManager;
import monero.common.MoneroConnectionManagerListener;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroKeyImage;
import monero.wallet.MoneroWallet;
import monero.wallet.model.MoneroAccount;
import monero.wallet.model.MoneroAddressBookEntry;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroIntegratedAddress;
import monero.wallet.model.MoneroMessageSignatureType;
import monero.wallet.model.MoneroOutgoingTransfer;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroSubaddress;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTransferQuery;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletListenerI;

abstract class MoneroWalletDefault
implements MoneroWallet {
    protected Set<MoneroWalletListenerI> listeners = new LinkedHashSet<MoneroWalletListenerI>();
    protected MoneroConnectionManager connectionManager;
    protected MoneroConnectionManagerListener connectionManagerListener;
    protected boolean isClosed = false;

    @Override
    public void addListener(MoneroWalletListenerI listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(MoneroWalletListenerI listener) {
        if (!this.listeners.contains(listener)) {
            throw new MoneroError("Listener is not registered with wallet");
        }
        this.listeners.remove(listener);
    }

    @Override
    public Set<MoneroWalletListenerI> getListeners() {
        return new HashSet<MoneroWalletListenerI>(this.listeners);
    }

    protected void announceSyncProgress(long height, long startHeight, long endHeight, double percentDone, String message) {
        for (MoneroWalletListenerI listener : this.listeners) {
            try {
                listener.onSyncProgress(height, startHeight, endHeight, percentDone, message);
            }
            catch (Exception e) {
                System.err.println("Error calling listener on sync progress: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void announceNewBlock(long height) {
        for (MoneroWalletListenerI listener : this.listeners) {
            try {
                listener.onNewBlock(height);
            }
            catch (Exception e) {
                System.err.println("Error calling listener on new block: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void announceBalancesChanged(BigInteger balance, BigInteger unlockedBalance) {
        for (MoneroWalletListenerI listener : this.listeners) {
            try {
                listener.onBalancesChanged(balance, unlockedBalance);
            }
            catch (Exception e) {
                System.err.println("Error calling listener on balances changed: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void announceOutputReceived(MoneroOutputWallet output) {
        for (MoneroWalletListenerI listener : this.listeners) {
            try {
                listener.onOutputReceived(output);
            }
            catch (Exception e) {
                System.err.println("Error calling listener on output received: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void announceOutputSpent(MoneroOutputWallet output) {
        for (MoneroWalletListenerI listener : this.listeners) {
            try {
                listener.onOutputSpent(output);
            }
            catch (Exception e) {
                System.err.println("Error calling listener on output spent: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDaemonConnection(String uri) {
        this.setDaemonConnection(uri, null, null);
    }

    @Override
    public void setDaemonConnection(String uri, String username, String password) {
        if (uri == null) {
            this.setDaemonConnection((MoneroRpcConnection)null);
        } else {
            this.setDaemonConnection(new MoneroRpcConnection(uri, username, password));
        }
    }

    @Override
    public void setConnectionManager(MoneroConnectionManager connectionManager) {
        if (this.connectionManager != null) {
            this.connectionManager.removeListener(this.connectionManagerListener);
        }
        this.connectionManager = connectionManager;
        if (connectionManager == null) {
            return;
        }
        if (this.connectionManagerListener == null) {
            this.connectionManagerListener = new MoneroConnectionManagerListener(){

                @Override
                public void onConnectionChanged(MoneroRpcConnection connection) {
                    MoneroWalletDefault.this.setDaemonConnection(connection);
                }
            };
        }
        connectionManager.addListener(this.connectionManagerListener);
        this.setDaemonConnection(connectionManager.getConnection());
    }

    @Override
    public MoneroConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public String getPrimaryAddress() {
        return this.getAddress(0, 0);
    }

    @Override
    public MoneroIntegratedAddress getIntegratedAddress() {
        return this.getIntegratedAddress(null, null);
    }

    @Override
    public MoneroSyncResult sync() {
        return this.sync(null, null);
    }

    @Override
    public MoneroSyncResult sync(MoneroWalletListenerI listener) {
        return this.sync(null, listener);
    }

    @Override
    public MoneroSyncResult sync(Long startHeight) {
        return this.sync(startHeight, null);
    }

    @Override
    public MoneroSyncResult sync(Long startHeight, MoneroWalletListenerI listener) {
        return this.sync(startHeight, listener);
    }

    @Override
    public void startSyncing() {
        this.startSyncing(null);
    }

    @Override
    public BigInteger getBalance() {
        return this.getBalance(null, null);
    }

    @Override
    public BigInteger getBalance(Integer accountIdx) {
        return this.getBalance(accountIdx, null);
    }

    @Override
    public BigInteger getUnlockedBalance() {
        return this.getUnlockedBalance(null, null);
    }

    @Override
    public BigInteger getUnlockedBalance(Integer accountIdx) {
        return this.getUnlockedBalance(accountIdx, null);
    }

    @Override
    public List<MoneroAccount> getAccounts() {
        return this.getAccounts(false, null);
    }

    @Override
    public List<MoneroAccount> getAccounts(boolean includeSubaddresses) {
        return this.getAccounts(includeSubaddresses, null);
    }

    @Override
    public List<MoneroAccount> getAccounts(String tag) {
        return this.getAccounts(false, tag);
    }

    @Override
    public MoneroAccount getAccount(int accountIdx) {
        return this.getAccount(accountIdx, false);
    }

    @Override
    public MoneroAccount createAccount() {
        return this.createAccount(null);
    }

    @Override
    public void setAccountLabel(int accountIdx, String label) {
        this.setSubaddressLabel(accountIdx, 0, label);
    }

    @Override
    public List<MoneroSubaddress> getSubaddresses(int accountIdx) {
        return this.getSubaddresses(accountIdx, null);
    }

    @Override
    public MoneroSubaddress getSubaddress(int accountIdx, int subaddressIdx) {
        List<MoneroSubaddress> subaddresses = this.getSubaddresses(accountIdx, Arrays.asList(subaddressIdx));
        if (subaddresses.isEmpty()) {
            throw new MoneroError("Subaddress at index " + subaddressIdx + " is not initialized");
        }
        GenUtils.assertEquals("Only 1 subaddress should be returned", 1, subaddresses.size());
        return subaddresses.get(0);
    }

    @Override
    public MoneroSubaddress createSubaddress(int accountIdx) {
        return this.createSubaddress(accountIdx, null);
    }

    @Override
    public MoneroTxWallet getTx(String txHash) {
        List<MoneroTxWallet> txs = this.getTxs(txHash);
        return txs.isEmpty() ? null : txs.get(0);
    }

    @Override
    public List<MoneroTxWallet> getTxs() {
        return this.getTxs(new MoneroTxQuery());
    }

    @Override
    public List<MoneroTxWallet> getTxs(String ... txHashes) {
        return this.getTxs(new MoneroTxQuery().setHashes(txHashes));
    }

    @Override
    public List<MoneroTxWallet> getTxs(List<String> txHashes) {
        return this.getTxs(new MoneroTxQuery().setHashes(txHashes));
    }

    @Override
    public List<MoneroTransfer> getTransfers() {
        return this.getTransfers(null);
    }

    @Override
    public List<MoneroTransfer> getTransfers(int accountIdx) {
        MoneroTransferQuery query = new MoneroTransferQuery().setAccountIndex(accountIdx);
        return this.getTransfers(query);
    }

    @Override
    public List<MoneroTransfer> getTransfers(int accountIdx, int subaddressIdx) {
        MoneroTransferQuery query = new MoneroTransferQuery().setAccountIndex(accountIdx).setSubaddressIndex(subaddressIdx);
        return this.getTransfers(query);
    }

    @Override
    public List<MoneroIncomingTransfer> getIncomingTransfers() {
        return this.getIncomingTransfers(null);
    }

    @Override
    public List<MoneroIncomingTransfer> getIncomingTransfers(MoneroTransferQuery query) {
        if (Boolean.FALSE.equals((query = this.normalizeTransferQuery(query)).isIncoming())) {
            throw new MoneroError("Transfer query contradicts getting incoming transfers");
        }
        query.setIsIncoming(true);
        ArrayList<MoneroIncomingTransfer> inTransfers = new ArrayList<MoneroIncomingTransfer>();
        for (MoneroTransfer transfer : this.getTransfers(query)) {
            inTransfers.add((MoneroIncomingTransfer)transfer);
        }
        return inTransfers;
    }

    @Override
    public List<MoneroOutgoingTransfer> getOutgoingTransfers() {
        return this.getOutgoingTransfers(null);
    }

    @Override
    public List<MoneroOutgoingTransfer> getOutgoingTransfers(MoneroTransferQuery query) {
        if (Boolean.FALSE.equals((query = this.normalizeTransferQuery(query)).isOutgoing())) {
            throw new MoneroError("Transfer query contradicts getting outgoing transfers");
        }
        query.setIsOutgoing(true);
        ArrayList<MoneroOutgoingTransfer> outTransfers = new ArrayList<MoneroOutgoingTransfer>();
        for (MoneroTransfer transfer : this.getTransfers(query)) {
            outTransfers.add((MoneroOutgoingTransfer)transfer);
        }
        return outTransfers;
    }

    @Override
    public List<MoneroOutputWallet> getOutputs() {
        return this.getOutputs(null);
    }

    @Override
    public String exportOutputs() {
        return this.exportOutputs(false);
    }

    @Override
    public List<MoneroKeyImage> exportKeyImages() {
        return this.exportKeyImages(false);
    }

    @Override
    public MoneroTxWallet createTx(MoneroTxConfig config) {
        if (config == null) {
            throw new MoneroError("Send request cannot be null");
        }
        if (Boolean.TRUE.equals(config.getCanSplit())) {
            throw new MoneroError("Cannot request split transactions with createTx() which prevents splitting; use createTxs() instead");
        }
        config = config.copy();
        config.setCanSplit(false);
        return this.createTxs(config).get(0);
    }

    @Override
    public String relayTx(String txMetadata) {
        return this.relayTxs((Collection<String>)Arrays.asList(txMetadata)).get(0);
    }

    @Override
    public String relayTx(MoneroTxWallet tx) {
        return this.relayTx(tx.getMetadata());
    }

    @Override
    public List<String> relayTxs(List<MoneroTxWallet> txs) {
        ArrayList<String> txHexes = new ArrayList<String>();
        for (MoneroTxWallet tx : txs) {
            txHexes.add(tx.getMetadata());
        }
        return this.relayTxs((Collection<String>)txHexes);
    }

    @Override
    public MoneroTxSet describeUnsignedTxSet(String unsignedTxHex) {
        return this.describeTxSet(new MoneroTxSet().setUnsignedTxHex(unsignedTxHex));
    }

    @Override
    public MoneroTxSet describeMultisigTxSet(String multisigTxHex) {
        return this.describeTxSet(new MoneroTxSet().setMultisigTxHex(multisigTxHex));
    }

    @Override
    public String signMessage(String message) {
        return this.signMessage(message, MoneroMessageSignatureType.SIGN_WITH_SPEND_KEY, 0, 0);
    }

    @Override
    public String getTxProof(String txHash, String address) {
        return this.getTxProof(txHash, address, null);
    }

    @Override
    public String getSpendProof(String txHash) {
        return this.getSpendProof(txHash, null);
    }

    @Override
    public String getTxNote(String txHash) {
        return this.getTxNotes(Arrays.asList(txHash)).get(0);
    }

    @Override
    public void setTxNote(String txHash, String note) {
        this.setTxNotes(Arrays.asList(txHash), Arrays.asList(note));
    }

    @Override
    public List<MoneroAddressBookEntry> getAddressBookEntries() {
        return this.getAddressBookEntries(null);
    }

    @Override
    public boolean isMultisig() {
        return this.getMultisigInfo().isMultisig();
    }

    @Override
    public int importMultisigHex(String ... multisigHexes) {
        return this.importMultisigHex(Arrays.asList(multisigHexes));
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean save) {
        if (this.connectionManager != null) {
            this.connectionManager.removeListener(this.connectionManagerListener);
        }
        this.connectionManager = null;
        this.connectionManagerListener = null;
        this.listeners.clear();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected MoneroTransferQuery normalizeTransferQuery(MoneroTransferQuery query) {
        if (query == null) {
            query = new MoneroTransferQuery();
        } else if (query.getTxQuery() == null) {
            query = query.copy();
        } else {
            MoneroTxQuery txQuery = query.getTxQuery().copy();
            if (query.getTxQuery().getTransferQuery() == query) {
                query = txQuery.getTransferQuery();
            } else {
                GenUtils.assertNull("Transfer query's tx query must be circular reference or null", query.getTxQuery().getTransferQuery());
                query = query.copy();
                query.setTxQuery(txQuery);
            }
        }
        if (query.getTxQuery() == null) {
            query.setTxQuery(new MoneroTxQuery());
        }
        query.getTxQuery().setTransferQuery(query);
        if (query.getTxQuery().getBlock() == null) {
            query.getTxQuery().setBlock(new MoneroBlock().setTxs(query.getTxQuery()));
        }
        return query;
    }
}

