/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroTx;

public class MoneroOutput {
    private MoneroTx tx;
    private MoneroKeyImage keyImage;
    private BigInteger amount;
    private Long index;
    private List<Long> ringOutputIndices;
    private String stealthPublicKey;

    public MoneroOutput() {
    }

    public MoneroOutput(MoneroOutput output) {
        if (output.keyImage != null) {
            this.keyImage = output.keyImage.copy();
        }
        this.amount = output.amount;
        this.index = output.index;
        if (output.ringOutputIndices != null) {
            this.ringOutputIndices = new ArrayList<Long>(output.ringOutputIndices);
        }
        this.stealthPublicKey = output.stealthPublicKey;
    }

    public MoneroOutput copy() {
        return new MoneroOutput(this);
    }

    @JsonBackReference
    public MoneroTx getTx() {
        return this.tx;
    }

    public MoneroOutput setTx(MoneroTx tx) {
        this.tx = tx;
        return this;
    }

    public MoneroKeyImage getKeyImage() {
        return this.keyImage;
    }

    public MoneroOutput setKeyImage(MoneroKeyImage keyImage) {
        this.keyImage = keyImage;
        return this;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public MoneroOutput setAmount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    public Long getIndex() {
        return this.index;
    }

    public MoneroOutput setIndex(Long index) {
        this.index = index;
        return this;
    }

    public List<Long> getRingOutputIndices() {
        return this.ringOutputIndices;
    }

    public MoneroOutput setRingOutputIndices(List<Long> ringOutputIndices) {
        this.ringOutputIndices = ringOutputIndices;
        return this;
    }

    public String getStealthPublicKey() {
        return this.stealthPublicKey;
    }

    public MoneroOutput setStealthPublicKey(String stealthPublicKey) {
        this.stealthPublicKey = stealthPublicKey;
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public MoneroOutput merge(MoneroOutput output) {
        GenUtils.assertTrue(output instanceof MoneroOutput);
        if (this == output) {
            return this;
        }
        if (this.getTx() != output.getTx()) {
            this.getTx().merge(output.getTx());
        } else {
            if (this.getKeyImage() == null) {
                this.setKeyImage(output.getKeyImage());
            } else if (output.getKeyImage() != null) {
                this.getKeyImage().merge(output.getKeyImage());
            }
            this.setAmount(GenUtils.reconcile(this.getAmount(), output.getAmount()));
            this.setIndex(GenUtils.reconcile(this.getIndex(), output.getIndex()));
        }
        return this;
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        if (this.getKeyImage() != null) {
            sb.append(GenUtils.kvLine("Key image", "", indent));
            sb.append(this.getKeyImage().toString(indent + 1) + "\n");
        }
        sb.append(GenUtils.kvLine("Amount", this.getAmount(), indent));
        sb.append(GenUtils.kvLine("Index", this.getIndex(), indent));
        sb.append(GenUtils.kvLine("Ring output indices", this.getRingOutputIndices(), indent));
        sb.append(GenUtils.kvLine("Stealth public key", this.getStealthPublicKey(), indent));
        String str = sb.toString();
        return str.isEmpty() ? str : str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.keyImage == null ? 0 : this.keyImage.hashCode());
        result = 31 * result + (this.ringOutputIndices == null ? 0 : this.ringOutputIndices.hashCode());
        result = 31 * result + (this.stealthPublicKey == null ? 0 : this.stealthPublicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroOutput other = (MoneroOutput)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.keyImage == null ? other.keyImage != null : !this.keyImage.equals(other.keyImage)) {
            return false;
        }
        if (this.ringOutputIndices == null ? other.ringOutputIndices != null : !this.ringOutputIndices.equals(other.ringOutputIndices)) {
            return false;
        }
        return !(this.stealthPublicKey == null ? other.stealthPublicKey != null : !this.stealthPublicKey.equals(other.stealthPublicKey));
    }
}

