/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import monero.common.MoneroError;

public enum MoneroNetworkType {
    MAINNET(18, 19, 42),
    TESTNET(53, 54, 63),
    STAGENET(24, 25, 36);

    private final int primaryAddressCode;
    private final int integratedAddressCode;
    private final int subaddressCode;

    private MoneroNetworkType(int primaryAddressCode, int integratedAddressCode, int subaddressCode) {
        this.primaryAddressCode = primaryAddressCode;
        this.integratedAddressCode = integratedAddressCode;
        this.subaddressCode = subaddressCode;
    }

    public int getPrimaryAddressCode() {
        return this.primaryAddressCode;
    }

    public int getIntegratedAddressCode() {
        return this.integratedAddressCode;
    }

    public int getSubaddressCode() {
        return this.subaddressCode;
    }

    public static MoneroNetworkType parse(String networkTypeStr) {
        if (networkTypeStr == null) {
            throw new MoneroError("Cannot parse null network type");
        }
        switch (networkTypeStr.toLowerCase()) {
            case "mainnet": {
                return MAINNET;
            }
            case "testnet": {
                return TESTNET;
            }
            case "stagenet": {
                return STAGENET;
            }
        }
        throw new MoneroError("Invalid network type to parse: " + networkTypeStr);
    }
}

