/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MoneroFeeEstimate {
    private BigInteger fee;
    private List<BigInteger> fees;
    private BigInteger quantizationMask;

    public MoneroFeeEstimate() {
    }

    public MoneroFeeEstimate(BigInteger fee, List<BigInteger> fees, BigInteger quantizationMask) {
        this.fee = fee;
        this.fees = fees;
        this.quantizationMask = quantizationMask;
    }

    public MoneroFeeEstimate(MoneroFeeEstimate feeEstimate) {
        this.fee = feeEstimate.fee;
        this.fees = new ArrayList<BigInteger>(feeEstimate.fees);
        this.quantizationMask = feeEstimate.quantizationMask;
    }

    public BigInteger getFee() {
        return this.fee;
    }

    public MoneroFeeEstimate setFee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    public List<BigInteger> getFees() {
        return this.fees;
    }

    public MoneroFeeEstimate setFees(List<BigInteger> fees) {
        this.fees = fees;
        return this;
    }

    public BigInteger getQuantizationMask() {
        return this.quantizationMask;
    }

    public MoneroFeeEstimate setQuantizationMask(BigInteger quantizationMask) {
        this.quantizationMask = quantizationMask;
        return this;
    }

    public MoneroFeeEstimate copy() {
        return new MoneroFeeEstimate(this);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Fee", this.getFee(), indent));
        sb.append(GenUtils.kvLine("Fees", this.getFees(), indent));
        sb.append(GenUtils.kvLine("Quantization mask", this.getQuantizationMask(), indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }
}

