/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon;

import com.fasterxml.jackson.core.type.TypeReference;
import common.utils.GenUtils;
import common.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.MoneroRpcError;
import monero.common.MoneroUtils;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemon;
import monero.daemon.MoneroDaemonDefault;
import monero.daemon.model.ConnectionType;
import monero.daemon.model.MoneroAltChain;
import monero.daemon.model.MoneroBan;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroBlockHeader;
import monero.daemon.model.MoneroBlockTemplate;
import monero.daemon.model.MoneroConnectionSpan;
import monero.daemon.model.MoneroDaemonInfo;
import monero.daemon.model.MoneroDaemonListener;
import monero.daemon.model.MoneroDaemonSyncInfo;
import monero.daemon.model.MoneroDaemonUpdateCheckResult;
import monero.daemon.model.MoneroDaemonUpdateDownloadResult;
import monero.daemon.model.MoneroFeeEstimate;
import monero.daemon.model.MoneroHardForkInfo;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import monero.daemon.model.MoneroMinerTxSum;
import monero.daemon.model.MoneroMiningStatus;
import monero.daemon.model.MoneroNetworkType;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroOutputDistributionEntry;
import monero.daemon.model.MoneroOutputHistogramEntry;
import monero.daemon.model.MoneroPeer;
import monero.daemon.model.MoneroPruneResult;
import monero.daemon.model.MoneroSubmitTxResult;
import monero.daemon.model.MoneroTx;
import monero.daemon.model.MoneroTxBacklogEntry;
import monero.daemon.model.MoneroTxPoolStats;
import monero.daemon.model.MoneroVersion;

public class MoneroDaemonRpc
extends MoneroDaemonDefault {
    private static final Logger LOGGER = Logger.getLogger(MoneroDaemonRpc.class.getName());
    private static final String DEFAULT_ID = "0000000000000000000000000000000000000000000000000000000000000000";
    private static long MAX_REQ_SIZE = 3000000L;
    private static int NUM_HEADERS_PER_REQ = 750;
    private MoneroRpcConnection rpc;
    private DaemonPoller daemonPoller;
    private List<MoneroDaemonListener> listeners = new ArrayList<MoneroDaemonListener>();
    private Map<Long, MoneroBlockHeader> cachedHeaders = new HashMap<Long, MoneroBlockHeader>();
    private Process process;

    private MoneroDaemonRpc() {
    }

    public MoneroDaemonRpc(URI uri) {
        this(new MoneroRpcConnection(uri));
    }

    public MoneroDaemonRpc(String uri) {
        this(new MoneroRpcConnection(uri));
    }

    public MoneroDaemonRpc(String uri, String username, String password) {
        this(new MoneroRpcConnection(uri, username, password));
    }

    public MoneroDaemonRpc(MoneroRpcConnection rpc) {
        this();
        GenUtils.assertNotNull(rpc);
        this.rpc = rpc;
    }

    public MoneroDaemonRpc(List<String> cmd) throws IOException {
        this();
        String line;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.environment().put("LANG", "en_US.UTF-8");
        pb.redirectErrorStream(true);
        this.process = pb.start();
        boolean printOutput = LOGGER.isLoggable(Level.FINER);
        String uri = null;
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        boolean success = false;
        while ((line = in.readLine()) != null) {
            LOGGER.log(Level.FINER, line);
            sb.append(line).append('\n');
            String uriLineContains = "Binding on ";
            int uriLineContainsIdx = line.indexOf(uriLineContains);
            if (uriLineContainsIdx >= 0) {
                String host = line.substring(uriLineContainsIdx + uriLineContains.length(), line.lastIndexOf(32));
                String port = line.substring(line.lastIndexOf(58) + 1);
                int sslIdx = cmd.indexOf("--rpc-ssl");
                boolean sslEnabled = sslIdx >= 0 ? "enabled".equalsIgnoreCase(cmd.get(sslIdx + 1)) : false;
                uri = (sslEnabled ? "https" : "http") + "://" + host + ":" + port;
            }
            if (!line.contains("Starting p2p net loop")) continue;
            if (printOutput) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            BufferedReader in = new BufferedReader(new InputStreamReader(MoneroDaemonRpc.this.process.getInputStream()));
                            while ((line = in.readLine()) != null) {
                                LOGGER.log(Level.FINER, line);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }).start();
            }
            success = true;
            break;
        }
        if (!printOutput) {
            in.close();
        }
        if (!success) {
            throw new MoneroError("Failed to start monerod:\n\n" + sb.toString().trim());
        }
        int userPassIdx = cmd.indexOf("--rpc-login");
        String userPass = userPassIdx >= 0 ? cmd.get(userPassIdx + 1) : null;
        String username = userPass == null ? null : userPass.substring(0, userPass.indexOf(58));
        String password = userPass == null ? null : userPass.substring(userPass.indexOf(58) + 1);
        int zmqUriIdx = cmd.indexOf("--zmq-pub");
        String zmqUri = zmqUriIdx >= 0 ? cmd.get(zmqUriIdx + 1) : null;
        this.rpc = new MoneroRpcConnection(uri, username, password, zmqUri);
    }

    public Process getProcess() {
        return this.process;
    }

    public int stopProcess() {
        return this.stopProcess(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopProcess(boolean force) {
        if (this.process == null) {
            throw new MoneroError("MoneroDaemonRpc instance not created from new process");
        }
        List<MoneroDaemonListener> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
            this.refreshListening();
        }
        if (force) {
            this.process.destroyForcibly();
        } else {
            this.process.destroy();
        }
        try {
            return this.process.waitFor();
        }
        catch (Exception e) {
            throw new MoneroError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MoneroDaemonListener listener) {
        List<MoneroDaemonListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            this.refreshListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MoneroDaemonListener listener) {
        List<MoneroDaemonListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                throw new MoneroError("Listener is not registered with daemon");
            }
            this.listeners.remove(listener);
            this.refreshListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MoneroDaemonListener> getListeners() {
        List<MoneroDaemonListener> list = this.listeners;
        synchronized (list) {
            return this.listeners;
        }
    }

    public MoneroRpcConnection getRpcConnection() {
        return this.rpc;
    }

    public void setProxyUri(String uri) {
        this.rpc.setProxyUri(uri);
    }

    public boolean isConnected() {
        try {
            this.getVersion();
            return true;
        }
        catch (MoneroError e) {
            return false;
        }
    }

    @Override
    public MoneroVersion getVersion() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_version");
        Map result = (Map)resp.get("result");
        return new MoneroVersion(((BigInteger)result.get("version")).intValue(), (Boolean)result.get("release"));
    }

    @Override
    public boolean isTrusted() {
        Map<String, Object> resp = this.rpc.sendPathRequest("get_height");
        MoneroDaemonRpc.checkResponseStatus(resp);
        return (Boolean)resp.get("untrusted") == false;
    }

    @Override
    public long getHeight() {
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block_count");
        Map resultMap = (Map)respMap.get("result");
        return ((BigInteger)resultMap.get("count")).intValue();
    }

    @Override
    public String getBlockHash(long height) {
        Map<String, Object> respMap = this.rpc.sendJsonRequest("on_get_block_hash", Arrays.asList(height));
        return (String)respMap.get("result");
    }

    @Override
    public MoneroBlockTemplate getBlockTemplate(String walletAddress, Integer reserveSize) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("wallet_address", walletAddress);
        params.put("reserve_size", reserveSize);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block_template", params);
        Map resultMap = (Map)respMap.get("result");
        MoneroBlockTemplate template = MoneroDaemonRpc.convertRpcBlockTemplate(resultMap);
        return template;
    }

    @Override
    public MoneroBlockHeader getLastBlockHeader() {
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_last_block_header");
        Map resultMap = (Map)respMap.get("result");
        MoneroDaemonRpc.checkResponseStatus(resultMap);
        MoneroBlockHeader header = MoneroDaemonRpc.convertRpcBlockHeader((Map)resultMap.get("block_header"));
        return header;
    }

    @Override
    public MoneroBlockHeader getBlockHeaderByHash(String blockHash) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", blockHash);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block_header_by_hash", params);
        Map resultMap = (Map)respMap.get("result");
        MoneroBlockHeader header = MoneroDaemonRpc.convertRpcBlockHeader((Map)resultMap.get("block_header"));
        return header;
    }

    @Override
    public MoneroBlockHeader getBlockHeaderByHeight(long height) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("height", height);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block_header_by_height", params);
        Map resultMap = (Map)respMap.get("result");
        MoneroBlockHeader header = MoneroDaemonRpc.convertRpcBlockHeader((Map)resultMap.get("block_header"));
        return header;
    }

    @Override
    public List<MoneroBlockHeader> getBlockHeadersByRange(Long startHeight, Long endHeight) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("start_height", startHeight);
        params.put("end_height", endHeight);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block_headers_range", params);
        Map resultMap = (Map)respMap.get("result");
        List rpcHeaders = (List)resultMap.get("headers");
        ArrayList<MoneroBlockHeader> headers = new ArrayList<MoneroBlockHeader>();
        for (Map rpcHeader : rpcHeaders) {
            MoneroBlockHeader header = MoneroDaemonRpc.convertRpcBlockHeader(rpcHeader);
            headers.add(header);
        }
        return headers;
    }

    @Override
    public MoneroBlock getBlockByHash(String blockHash) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", blockHash);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block", params);
        Map resultMap = (Map)respMap.get("result");
        MoneroBlock block = MoneroDaemonRpc.convertRpcBlock(resultMap);
        return block;
    }

    @Override
    public List<MoneroBlock> getBlocksByHash(List<String> blockHashes, Long startHeight, Boolean prune) {
        throw new RuntimeException("MoneroDaemonRpc.getBlocksByHash() not implemented");
    }

    @Override
    public MoneroBlock getBlockByHeight(long height) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("height", height);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_block", params);
        Map rpcBlock = (Map)respMap.get("result");
        MoneroBlock block = MoneroDaemonRpc.convertRpcBlock(rpcBlock);
        return block;
    }

    @Override
    public List<MoneroBlock> getBlocksByHeight(List<Long> heights) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("heights", heights);
        byte[] respBin = this.rpc.sendBinaryRequest("get_blocks_by_height.bin", params);
        Map<String, Object> rpcResp = MoneroUtils.binaryBlocksToMap(respBin);
        MoneroDaemonRpc.checkResponseStatus(rpcResp);
        ArrayList<MoneroBlock> blocks = new ArrayList<MoneroBlock>();
        List rpcBlocks = (List)rpcResp.get("blocks");
        List rpcTxs = (List)rpcResp.get("txs");
        GenUtils.assertEquals(rpcBlocks.size(), rpcTxs.size());
        for (int blockIdx = 0; blockIdx < rpcBlocks.size(); ++blockIdx) {
            MoneroBlock block = MoneroDaemonRpc.convertRpcBlock((Map)rpcBlocks.get(blockIdx));
            block.setHeight(heights.get(blockIdx));
            blocks.add(block);
            ArrayList<MoneroTx> txs = new ArrayList<MoneroTx>();
            for (int txIdx = 0; txIdx < ((List)rpcTxs.get(blockIdx)).size(); ++txIdx) {
                MoneroTx tx = new MoneroTx();
                txs.add(tx);
                List txHashes = (List)((Map)rpcBlocks.get(blockIdx)).get("tx_hashes");
                tx.setHash((String)txHashes.get(txIdx));
                tx.setIsConfirmed(true);
                tx.setInTxPool(false);
                tx.setIsMinerTx(false);
                tx.setRelay(true);
                tx.setIsRelayed(true);
                tx.setIsFailed(false);
                tx.setIsDoubleSpendSeen(false);
                List blockTxs = (List)rpcTxs.get(blockIdx);
                MoneroDaemonRpc.convertRpcTx((Map)blockTxs.get(txIdx), tx);
            }
            block.setTxs(new ArrayList<MoneroTx>());
            for (MoneroTx tx : txs) {
                if (tx.getBlock() != null) {
                    block.merge(tx.getBlock());
                    continue;
                }
                block.getTxs().add(tx.setBlock(block));
            }
        }
        return blocks;
    }

    @Override
    public List<MoneroBlock> getBlocksByRange(Long startHeight, Long endHeight) {
        if (startHeight == null) {
            startHeight = 0L;
        }
        if (endHeight == null) {
            endHeight = this.getHeight() - 1L;
        }
        ArrayList<Long> heights = new ArrayList<Long>();
        for (long height = startHeight.longValue(); height <= endHeight; ++height) {
            heights.add(height);
        }
        return this.getBlocksByHeight(heights);
    }

    @Override
    public List<MoneroBlock> getBlocksByRangeChunked(Long startHeight, Long endHeight, Long maxChunkSize) {
        if (startHeight == null) {
            startHeight = 0L;
        }
        if (endHeight == null) {
            endHeight = this.getHeight() - 1L;
        }
        long lastHeight = startHeight - 1L;
        ArrayList<MoneroBlock> blocks = new ArrayList<MoneroBlock>();
        while (lastHeight < endHeight) {
            blocks.addAll(this.getMaxBlocks(lastHeight + 1L, endHeight, maxChunkSize));
            lastHeight = ((MoneroBlock)blocks.get(blocks.size() - 1)).getHeight();
        }
        return blocks;
    }

    @Override
    public List<String> getBlockHashes(List<String> blockHashes, Long startHeight) {
        throw new RuntimeException("MoneroDaemonRpc.getBlockHashes() not implemented");
    }

    @Override
    public List<MoneroTx> getTxs(Collection<String> txHashes, Boolean prune) {
        if (txHashes.isEmpty()) {
            throw new MoneroError("Must provide an array of transaction hashes");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("txs_hashes", txHashes);
        params.put("decode_as_json", true);
        params.put("prune", prune);
        Map<String, Object> respMap = this.rpc.sendPathRequest("get_transactions", params);
        try {
            MoneroDaemonRpc.checkResponseStatus(respMap);
        }
        catch (MoneroError e) {
            if (e.getMessage().indexOf("Failed to parse hex representation of transaction hash") >= 0) {
                throw new MoneroError("Invalid transaction hash", e.getCode());
            }
            throw e;
        }
        List rpcTxs = (List)respMap.get("txs");
        ArrayList<MoneroTx> txs = new ArrayList<MoneroTx>();
        if (rpcTxs != null) {
            for (int i = 0; i < rpcTxs.size(); ++i) {
                MoneroTx tx = new MoneroTx();
                tx.setIsMinerTx(false);
                txs.add(MoneroDaemonRpc.convertRpcTx((Map)rpcTxs.get(i), tx));
            }
        }
        return txs;
    }

    @Override
    public List<String> getTxHexes(Collection<String> txHashes, Boolean prune) {
        ArrayList<String> hexes = new ArrayList<String>();
        for (MoneroTx tx : this.getTxs(txHashes, prune)) {
            hexes.add(Boolean.TRUE.equals(prune) ? tx.getPrunedHex() : tx.getFullHex());
        }
        return hexes;
    }

    @Override
    public MoneroMinerTxSum getMinerTxSum(long height, Long numBlocks) {
        GenUtils.assertTrue("Height must be an integer >= 0", height >= 0L);
        if (numBlocks == null) {
            numBlocks = this.getHeight();
        } else {
            GenUtils.assertTrue("Count must be an integer >= 0", numBlocks >= 0L);
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("height", height);
        params.put("count", numBlocks);
        Map<String, Object> respMap = this.rpc.sendJsonRequest("get_coinbase_tx_sum", params);
        Map resultMap = (Map)respMap.get("result");
        MoneroDaemonRpc.checkResponseStatus(resultMap);
        MoneroMinerTxSum txSum = new MoneroMinerTxSum();
        txSum.setEmissionSum((BigInteger)resultMap.get("emission_amount"));
        txSum.setFeeSum((BigInteger)resultMap.get("fee_amount"));
        return txSum;
    }

    @Override
    public MoneroFeeEstimate getFeeEstimate(Integer graceBlocks) {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_fee_estimate");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        MoneroFeeEstimate feeEstimate = new MoneroFeeEstimate();
        feeEstimate.setFee((BigInteger)result.get("fee"));
        feeEstimate.setQuantizationMask((BigInteger)result.get("quantization_mask"));
        if (result.containsKey("fees")) {
            ArrayList<BigInteger> fees = new ArrayList<BigInteger>();
            for (BigInteger fee : (List)result.get("fees")) {
                fees.add(fee);
            }
            feeEstimate.setFees(fees);
        }
        return feeEstimate;
    }

    @Override
    public MoneroSubmitTxResult submitTxHex(String txHex, Boolean doNotRelay) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tx_as_hex", txHex);
        params.put("do_not_relay", doNotRelay);
        Map<String, Object> resp = this.rpc.sendPathRequest("send_raw_transaction", params);
        MoneroSubmitTxResult submitResult = MoneroDaemonRpc.convertRpcSubmitTxResult(resp);
        try {
            MoneroDaemonRpc.checkResponseStatus(resp);
            submitResult.setIsGood(true);
        }
        catch (MoneroError e) {
            submitResult.setIsGood(false);
        }
        return submitResult;
    }

    @Override
    public void relayTxsByHash(Collection<String> txHashes) {
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        params.put("txids", txHashes);
        Map<String, Object> resp = this.rpc.sendJsonRequest("relay_tx", params);
        MoneroDaemonRpc.checkResponseStatus((Map)resp.get("result"));
    }

    @Override
    public List<MoneroTx> getTxPool() {
        Map<String, Object> resp = this.rpc.sendPathRequest("get_transaction_pool");
        MoneroDaemonRpc.checkResponseStatus(resp);
        ArrayList<MoneroTx> txs = new ArrayList<MoneroTx>();
        if (resp.containsKey("transactions")) {
            for (Map rpcTx : (List)resp.get("transactions")) {
                MoneroTx tx = new MoneroTx();
                txs.add(tx);
                tx.setIsConfirmed(false);
                tx.setIsMinerTx(false);
                tx.setInTxPool(true);
                tx.setNumConfirmations(0L);
                MoneroDaemonRpc.convertRpcTx(rpcTx, tx);
            }
        }
        return txs;
    }

    @Override
    public List<String> getTxPoolHashes() {
        throw new RuntimeException("MoneroDaemonRpc.getTxPoolHashes() not implemented");
    }

    @Override
    public List<MoneroTxBacklogEntry> getTxPoolBacklog() {
        throw new RuntimeException("MoneroDaemonRpc.getTxPoolBacklog() not implemented");
    }

    @Override
    public MoneroTxPoolStats getTxPoolStats() {
        Map<String, Object> resp = this.rpc.sendPathRequest("get_transaction_pool_stats");
        MoneroDaemonRpc.checkResponseStatus(resp);
        return this.convertRpcTxPoolStats((Map)resp.get("pool_stats"));
    }

    @Override
    public void flushTxPool() {
        this.flushTxPool(new String[0]);
    }

    @Override
    public void flushTxPool(String ... hashes) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("txids", hashes);
        Map<String, Object> resp = this.rpc.sendJsonRequest("flush_txpool", params);
        MoneroDaemonRpc.checkResponseStatus((Map)resp.get("result"));
    }

    @Override
    public void flushTxPool(Collection<String> hashes) {
        this.flushTxPool(hashes.toArray(new String[0]));
    }

    @Override
    public List<MoneroKeyImageSpentStatus> getKeyImageSpentStatuses(List<String> keyImages) {
        if (keyImages == null || keyImages.isEmpty()) {
            throw new MoneroError("Must provide key images to check the status of");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key_images", keyImages);
        Map<String, Object> resp = this.rpc.sendPathRequest("is_key_image_spent", params);
        MoneroDaemonRpc.checkResponseStatus(resp);
        ArrayList<MoneroKeyImageSpentStatus> statuses = new ArrayList<MoneroKeyImageSpentStatus>();
        for (BigInteger bi : (List)resp.get("spent_status")) {
            statuses.add(MoneroKeyImageSpentStatus.valueOf(bi.intValue()));
        }
        return statuses;
    }

    @Override
    public List<MoneroOutput> getOutputs(Collection<MoneroOutput> outputs) {
        throw new RuntimeException("MoneroDaemonRpc.getOutputs() not implemented");
    }

    @Override
    public List<MoneroOutputHistogramEntry> getOutputHistogram(Collection<BigInteger> amounts, Integer minCount, Integer maxCount, Boolean isUnlocked, Integer recentCutoff) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("amounts", amounts);
        params.put("min_count", minCount);
        params.put("max_count", maxCount);
        params.put("unlocked", isUnlocked);
        params.put("recent_cutoff", recentCutoff);
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_output_histogram", params);
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        ArrayList<MoneroOutputHistogramEntry> entries = new ArrayList<MoneroOutputHistogramEntry>();
        if (!result.containsKey("histogram")) {
            return entries;
        }
        for (Map rpcEntry : (List)result.get("histogram")) {
            entries.add(MoneroDaemonRpc.convertRpcOutputHistogramEntry(rpcEntry));
        }
        return entries;
    }

    @Override
    public List<MoneroOutputDistributionEntry> getOutputDistribution(Collection<BigInteger> amounts, Boolean isCumulative, Long startHeight, Long endHeight) {
        throw new RuntimeException("Not implemented (response 'distribution' field is binary)");
    }

    @Override
    public MoneroDaemonInfo getInfo() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_info");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        return MoneroDaemonRpc.convertRpcInfo(result);
    }

    @Override
    public MoneroDaemonSyncInfo getSyncInfo() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("sync_info");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        return MoneroDaemonRpc.convertRpcSyncInfo(result);
    }

    @Override
    public MoneroHardForkInfo getHardForkInfo() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("hard_fork_info");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        return MoneroDaemonRpc.convertRpcHardForkInfo(result);
    }

    @Override
    public List<MoneroAltChain> getAltChains() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_alternate_chains");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        ArrayList<MoneroAltChain> chains = new ArrayList<MoneroAltChain>();
        if (!result.containsKey("chains")) {
            return chains;
        }
        for (Map rpcChain : (List)result.get("chains")) {
            chains.add(MoneroDaemonRpc.convertRpcAltChain(rpcChain));
        }
        return chains;
    }

    @Override
    public List<String> getAltBlockHashes() {
        Map<String, Object> resp = this.rpc.sendPathRequest("get_alt_blocks_hashes");
        MoneroDaemonRpc.checkResponseStatus(resp);
        if (!resp.containsKey("blks_hashes")) {
            return new ArrayList<String>();
        }
        return (List)resp.get("blks_hashes");
    }

    @Override
    public int getDownloadLimit() {
        return this.getBandwidthLimits()[0];
    }

    @Override
    public int setDownloadLimit(int limit) {
        if (limit == -1) {
            return this.resetDownloadLimit();
        }
        if (limit <= 0) {
            throw new MoneroError("Download limit must be an integer greater than 0");
        }
        return this.setBandwidthLimits(limit, 0)[0];
    }

    @Override
    public int resetDownloadLimit() {
        return this.setBandwidthLimits(-1, 0)[0];
    }

    @Override
    public int getUploadLimit() {
        return this.getBandwidthLimits()[1];
    }

    @Override
    public int setUploadLimit(int limit) {
        if (limit == -1) {
            return this.resetUploadLimit();
        }
        if (limit <= 0) {
            throw new MoneroError("Upload limit must be an integer greater than 0");
        }
        return this.setBandwidthLimits(0, limit)[1];
    }

    @Override
    public int resetUploadLimit() {
        return this.setBandwidthLimits(0, -1)[1];
    }

    @Override
    public List<MoneroPeer> getPeers() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_connections");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        ArrayList<MoneroPeer> connections = new ArrayList<MoneroPeer>();
        if (!result.containsKey("connections")) {
            return connections;
        }
        for (Map rpcConnection : (List)result.get("connections")) {
            connections.add(MoneroDaemonRpc.convertRpcConnection(rpcConnection));
        }
        return connections;
    }

    @Override
    public List<MoneroPeer> getKnownPeers() {
        MoneroPeer peer;
        Map<String, Object> respMap = this.rpc.sendPathRequest("get_peer_list");
        MoneroDaemonRpc.checkResponseStatus(respMap);
        ArrayList<MoneroPeer> peers = new ArrayList<MoneroPeer>();
        if (respMap.containsKey("gray_list")) {
            for (Map rpcPeer : (List)respMap.get("gray_list")) {
                peer = MoneroDaemonRpc.convertRpcPeer(rpcPeer);
                peer.setIsOnline(false);
                peers.add(peer);
            }
        }
        if (respMap.containsKey("white_list")) {
            for (Map rpcPeer : (List)respMap.get("white_list")) {
                peer = MoneroDaemonRpc.convertRpcPeer(rpcPeer);
                peer.setIsOnline(true);
                peers.add(peer);
            }
        }
        return peers;
    }

    @Override
    public void setOutgoingPeerLimit(int limit) {
        if (limit < 0) {
            throw new MoneroError("Outgoing peer limit must be >= 0");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("out_peers", limit);
        Map<String, Object> resp = this.rpc.sendPathRequest("out_peers", params);
        MoneroDaemonRpc.checkResponseStatus(resp);
    }

    @Override
    public void setIncomingPeerLimit(int limit) {
        if (limit < 0) {
            throw new MoneroError("Incoming peer limit must be >= 0");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("in_peers", limit);
        Map<String, Object> resp = this.rpc.sendPathRequest("in_peers", params);
        MoneroDaemonRpc.checkResponseStatus(resp);
    }

    @Override
    public List<MoneroBan> getPeerBans() {
        Map<String, Object> resp = this.rpc.sendJsonRequest("get_bans");
        Map result = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(result);
        ArrayList<MoneroBan> bans = new ArrayList<MoneroBan>();
        for (Map rpcBan : (List)result.get("bans")) {
            MoneroBan ban = new MoneroBan();
            ban.setHost((String)rpcBan.get("host"));
            ban.setIp(((BigInteger)rpcBan.get("ip")).intValue());
            ban.setSeconds(((BigInteger)rpcBan.get("seconds")).longValue());
            bans.add(ban);
        }
        return bans;
    }

    @Override
    public void setPeerBans(List<MoneroBan> bans) {
        ArrayList<Map<String, Object>> rpcBans = new ArrayList<Map<String, Object>>();
        for (MoneroBan ban : bans) {
            rpcBans.add(MoneroDaemonRpc.convertToRpcBan(ban));
        }
        HashMap<String, ArrayList<Map<String, Object>>> params = new HashMap<String, ArrayList<Map<String, Object>>>();
        params.put("bans", rpcBans);
        Map<String, Object> resp = this.rpc.sendJsonRequest("set_bans", params);
        MoneroDaemonRpc.checkResponseStatus((Map)resp.get("result"));
    }

    @Override
    public void startMining(String address, Long numThreads, Boolean isBackground, Boolean ignoreBattery) {
        if (address == null || address.isEmpty()) {
            throw new MoneroError("Must provide address to mine to");
        }
        if (numThreads == null || numThreads <= 0L) {
            throw new MoneroError("Number of threads must be an integer greater than 0");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("miner_address", address);
        params.put("threads_count", numThreads);
        params.put("do_background_mining", isBackground);
        params.put("ignore_battery", ignoreBattery);
        Map<String, Object> resp = this.rpc.sendPathRequest("start_mining", params);
        MoneroDaemonRpc.checkResponseStatus(resp);
    }

    @Override
    public void stopMining() {
        Map<String, Object> resp = this.rpc.sendPathRequest("stop_mining");
        MoneroDaemonRpc.checkResponseStatus(resp);
    }

    @Override
    public MoneroMiningStatus getMiningStatus() {
        Map<String, Object> resp = this.rpc.sendPathRequest("mining_status");
        MoneroDaemonRpc.checkResponseStatus(resp);
        return MoneroDaemonRpc.convertRpcMiningStatus(resp);
    }

    @Override
    public void submitBlocks(Collection<String> blockBlobs) {
        if (blockBlobs.isEmpty()) {
            throw new MoneroError("Must provide an array of mined block blobs to submit");
        }
        Map<String, Object> resp = this.rpc.sendJsonRequest("submit_block", blockBlobs);
        MoneroDaemonRpc.checkResponseStatus((Map)resp.get("result"));
    }

    @Override
    public MoneroPruneResult pruneBlockchain(boolean check) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("check", check);
        Map<String, Object> resp = this.rpc.sendJsonRequest("prune_blockchain", params, 0L);
        Map resultMap = (Map)resp.get("result");
        MoneroDaemonRpc.checkResponseStatus(resultMap);
        MoneroPruneResult result = new MoneroPruneResult();
        result.setIsPruned((boolean)((Boolean)resultMap.get("pruned")));
        result.setPruningSeed(((BigInteger)resultMap.get("pruning_seed")).intValue());
        return result;
    }

    @Override
    public MoneroDaemonUpdateCheckResult checkForUpdate() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "check");
        Map<String, Object> respMap = this.rpc.sendPathRequest("update", params);
        MoneroDaemonRpc.checkResponseStatus(respMap);
        return MoneroDaemonRpc.convertRpcUpdateCheckResult(respMap);
    }

    @Override
    public MoneroDaemonUpdateDownloadResult downloadUpdate(String path) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "download");
        params.put("path", path);
        Map<String, Object> resp = this.rpc.sendPathRequest("update", params);
        MoneroDaemonRpc.checkResponseStatus(resp);
        return MoneroDaemonRpc.convertRpcUpdateDownloadResult(resp);
    }

    @Override
    public void stop() {
        Map<String, Object> resp = this.rpc.sendPathRequest("stop_daemon");
        MoneroDaemonRpc.checkResponseStatus(resp);
    }

    @Override
    public MoneroBlockHeader waitForNextBlockHeader() {
        Object syncObject;
        Object object = syncObject = new Object();
        synchronized (object) {
            try {
                MoneroDaemonListener customListener = new MoneroDaemonListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onBlockHeader(MoneroBlockHeader header) {
                        super.onBlockHeader(header);
                        Object object = syncObject;
                        synchronized (object) {
                            syncObject.notifyAll();
                        }
                    }
                };
                this.addListener(customListener);
                syncObject.wait();
                this.removeListener(customListener);
                return customListener.getLastBlockHeader();
            }
            catch (InterruptedException e) {
                throw new MoneroError(e);
            }
        }
    }

    private int[] getBandwidthLimits() {
        Map<String, Object> resp = this.rpc.sendPathRequest("get_limit");
        MoneroDaemonRpc.checkResponseStatus(resp);
        return new int[]{((BigInteger)resp.get("limit_down")).intValue(), ((BigInteger)resp.get("limit_up")).intValue()};
    }

    private int[] setBandwidthLimits(Integer downLimit, Integer upLimit) {
        if (downLimit == null) {
            downLimit = 0;
        }
        if (upLimit == null) {
            upLimit = 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit_down", downLimit);
        params.put("limit_up", upLimit);
        Map<String, Object> resp = this.rpc.sendPathRequest("set_limit", params);
        MoneroDaemonRpc.checkResponseStatus(resp);
        return new int[]{((BigInteger)resp.get("limit_down")).intValue(), ((BigInteger)resp.get("limit_up")).intValue()};
    }

    private List<MoneroBlock> getMaxBlocks(Long startHeight, Long maxHeight, Long chunkSize) {
        long endHeight;
        if (startHeight == null) {
            startHeight = 0L;
        }
        if (maxHeight == null) {
            maxHeight = this.getHeight() - 1L;
        }
        if (chunkSize == null) {
            chunkSize = MAX_REQ_SIZE;
        }
        int reqSize = 0;
        for (endHeight = startHeight - 1L; (long)reqSize < chunkSize && endHeight < maxHeight; ++endHeight) {
            MoneroBlockHeader header = this.getBlockHeaderByHeightCached(endHeight + 1L, maxHeight);
            GenUtils.assertTrue("Block exceeds maximum request size: " + header.getSize(), header.getSize() <= chunkSize);
            if ((long)reqSize + header.getSize() > chunkSize) break;
            reqSize = (int)((long)reqSize + header.getSize());
        }
        return endHeight >= startHeight ? this.getBlocksByRange(startHeight, endHeight) : new ArrayList<MoneroBlock>();
    }

    private MoneroBlockHeader getBlockHeaderByHeightCached(long height, long maxHeight) {
        MoneroBlockHeader cachedHeader = this.cachedHeaders.get(height);
        if (cachedHeader != null) {
            return cachedHeader;
        }
        long endHeight = Math.min(maxHeight, height + (long)NUM_HEADERS_PER_REQ - 1L);
        List<MoneroBlockHeader> headers = this.getBlockHeadersByRange(height, endHeight);
        for (MoneroBlockHeader header : headers) {
            this.cachedHeaders.put(header.getHeight(), header);
        }
        return this.cachedHeaders.get(height);
    }

    private static void checkResponseStatus(Map<String, Object> resp) {
        String status = (String)resp.get("status");
        if (!"OK".equals(status)) {
            throw new MoneroRpcError(status, null, null, null);
        }
    }

    private static MoneroBlockTemplate convertRpcBlockTemplate(Map<String, Object> rpcTemplate) {
        MoneroBlockTemplate template = new MoneroBlockTemplate();
        for (String key : rpcTemplate.keySet()) {
            Object val = rpcTemplate.get(key);
            if (key.equals("blockhashing_blob")) {
                template.setBlockHashingBlob((String)val);
                continue;
            }
            if (key.equals("blocktemplate_blob")) {
                template.setBlockTemplateBlob((String)val);
                continue;
            }
            if (key.equals("expected_reward")) {
                template.setExpectedReward((BigInteger)val);
                continue;
            }
            if (key.equals("difficulty") || key.equals("difficulty_top64")) continue;
            if (key.equals("wide_difficulty")) {
                template.setDifficulty(GenUtils.reconcile(template.getDifficulty(), MoneroDaemonRpc.prefixedHexToBI((String)val)));
                continue;
            }
            if (key.equals("height")) {
                template.setHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("prev_hash")) {
                template.setPrevHash((String)val);
                continue;
            }
            if (key.equals("reserved_offset")) {
                template.setReservedOffset(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("status") || key.equals("untrusted")) continue;
            if (key.equals("seed_height")) {
                template.setSeedHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("seed_hash")) {
                template.setSeedHash((String)val);
                continue;
            }
            if (key.equals("next_seed_hash")) {
                template.setNextSeedHash((String)val);
                continue;
            }
            LOGGER.warning("ignoring unexpected field in block template: " + key + ": " + val);
        }
        if ("".equals(template.getNextSeedHash())) {
            template.setNextSeedHash(null);
        }
        return template;
    }

    private static MoneroBlockHeader convertRpcBlockHeader(Map<String, Object> rpcHeader) {
        return MoneroDaemonRpc.convertRpcBlockHeader(rpcHeader, null);
    }

    private static MoneroBlockHeader convertRpcBlockHeader(Map<String, Object> rpcHeader, MoneroBlockHeader header) {
        if (header == null) {
            header = new MoneroBlockHeader();
        }
        for (String key : rpcHeader.keySet()) {
            Object val = rpcHeader.get(key);
            if (key.equals("block_size")) {
                header.setSize(GenUtils.reconcile(header.getSize(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("depth")) {
                header.setDepth(GenUtils.reconcile(header.getDepth(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("difficulty") || key.equals("cumulative_difficulty") || key.equals("difficulty_top64") || key.equals("cumulative_difficulty_top64")) continue;
            if (key.equals("wide_difficulty")) {
                header.setDifficulty(GenUtils.reconcile(header.getDifficulty(), MoneroDaemonRpc.prefixedHexToBI((String)val)));
                continue;
            }
            if (key.equals("wide_cumulative_difficulty")) {
                header.setCumulativeDifficulty(GenUtils.reconcile(header.getCumulativeDifficulty(), MoneroDaemonRpc.prefixedHexToBI((String)val)));
                continue;
            }
            if (key.equals("hash")) {
                header.setHash(GenUtils.reconcile(header.getHash(), (String)val));
                continue;
            }
            if (key.equals("height")) {
                header.setHeight(GenUtils.reconcile(header.getHeight(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("major_version")) {
                header.setMajorVersion(GenUtils.reconcile(header.getMajorVersion(), ((BigInteger)val).intValue()));
                continue;
            }
            if (key.equals("minor_version")) {
                header.setMinorVersion(GenUtils.reconcile(header.getMinorVersion(), ((BigInteger)val).intValue()));
                continue;
            }
            if (key.equals("nonce")) {
                header.setNonce(GenUtils.reconcile(header.getNonce(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("num_txes")) {
                header.setNumTxs(GenUtils.reconcile(header.getNumTxs(), ((BigInteger)val).intValue()));
                continue;
            }
            if (key.equals("orphan_status")) {
                header.setOrphanStatus(GenUtils.reconcile(header.getOrphanStatus(), (Boolean)val));
                continue;
            }
            if (key.equals("prev_hash") || key.equals("prev_id")) {
                header.setPrevHash(GenUtils.reconcile(header.getPrevHash(), (String)val));
                continue;
            }
            if (key.equals("reward")) {
                header.setReward(GenUtils.reconcile(header.getReward(), (BigInteger)val));
                continue;
            }
            if (key.equals("timestamp")) {
                header.setTimestamp(GenUtils.reconcile(header.getTimestamp(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("block_weight")) {
                header.setWeight(GenUtils.reconcile(header.getWeight(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("long_term_weight")) {
                header.setLongTermWeight(GenUtils.reconcile(header.getLongTermWeight(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("pow_hash")) {
                header.setPowHash(GenUtils.reconcile(header.getPowHash(), "".equals(val) ? null : (String)val));
                continue;
            }
            if (key.equals("tx_hashes") || key.equals("miner_tx")) continue;
            if (key.equals("miner_tx_hash")) {
                header.setMinerTxHash((String)val);
                continue;
            }
            LOGGER.warning("ignoring unexpected block header field: '" + key + "': " + val);
        }
        return header;
    }

    private static MoneroBlock convertRpcBlock(Map<String, Object> rpcBlock) {
        MoneroBlock block = new MoneroBlock();
        MoneroDaemonRpc.convertRpcBlockHeader(rpcBlock.containsKey("block_header") ? (Map)rpcBlock.get("block_header") : rpcBlock, block);
        block.setHex((String)rpcBlock.get("blob"));
        block.setTxHashes(rpcBlock.containsKey("tx_hashes") ? (List)rpcBlock.get("tx_hashes") : new ArrayList());
        Map rpcMinerTx = (Map)(rpcBlock.containsKey("json") ? JsonUtils.deserialize(MoneroRpcConnection.MAPPER, (String)rpcBlock.get("json"), new TypeReference<Map<String, Object>>(){}).get("miner_tx") : rpcBlock.get("miner_tx"));
        MoneroTx minerTx = new MoneroTx().setIsConfirmed(true).setInTxPool(false).setIsMinerTx(true);
        MoneroDaemonRpc.convertRpcTx(rpcMinerTx, minerTx);
        block.setMinerTx(minerTx);
        return block;
    }

    private static MoneroTx convertRpcTx(Map<String, Object> rpcTx, MoneroTx tx) {
        if (rpcTx == null) {
            return null;
        }
        if (tx == null) {
            tx = new MoneroTx();
        }
        MoneroBlock block = null;
        for (String key : rpcTx.keySet()) {
            Object bi2;
            Object val = rpcTx.get(key);
            if (key.equals("tx_hash") || key.equals("id_hash")) {
                tx.setHash(GenUtils.reconcile(tx.getHash(), (String)val));
                continue;
            }
            if (key.equals("block_timestamp")) {
                if (block == null) {
                    block = new MoneroBlock();
                }
                block.setTimestamp(GenUtils.reconcile(block.getTimestamp(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("block_height")) {
                if (block == null) {
                    block = new MoneroBlock();
                }
                block.setHeight(GenUtils.reconcile(block.getHeight(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("last_relayed_time")) {
                tx.setLastRelayedTimestamp(GenUtils.reconcile(tx.getLastRelayedTimestamp(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("receive_time") || key.equals("received_timestamp")) {
                tx.setReceivedTimestamp(GenUtils.reconcile(tx.getReceivedTimestamp(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("confirmations")) {
                tx.setNumConfirmations(GenUtils.reconcile(tx.getNumConfirmations(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("in_pool")) {
                tx.setIsConfirmed(GenUtils.reconcile(tx.isConfirmed(), (Boolean)val == false));
                tx.setInTxPool(GenUtils.reconcile(tx.inTxPool(), (Boolean)val));
                continue;
            }
            if (key.equals("double_spend_seen")) {
                tx.setIsDoubleSpendSeen(GenUtils.reconcile(tx.isDoubleSpendSeen(), (Boolean)val));
                continue;
            }
            if (key.equals("version")) {
                tx.setVersion(GenUtils.reconcile(tx.getVersion(), ((BigInteger)val).intValue()));
                continue;
            }
            if (key.equals("extra")) {
                if (val instanceof String) {
                    LOGGER.warning("extra field as string not being assigned to byte[]: " + key + ": " + val);
                    continue;
                }
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                for (Object bi2 : (List)val) {
                    bytes.add(((Number)bi2).byteValue());
                }
                tx.setExtra(GenUtils.reconcile(tx.getExtra(), GenUtils.listToByteArray(bytes)));
                continue;
            }
            if (key.equals("vin")) {
                List rpcInputs = (List)val;
                if (rpcInputs.size() == 1 && ((Map)rpcInputs.get(0)).containsKey("gen")) continue;
                ArrayList<MoneroOutput> inputs = new ArrayList<MoneroOutput>();
                bi2 = rpcInputs.iterator();
                while (bi2.hasNext()) {
                    Map rpcInput = (Map)bi2.next();
                    inputs.add(MoneroDaemonRpc.convertRpcOutput(rpcInput, tx));
                }
                tx.setInputs(inputs);
                continue;
            }
            if (key.equals("vout")) {
                List rpcOutputs = (List)val;
                ArrayList<MoneroOutput> outputs = new ArrayList<MoneroOutput>();
                bi2 = rpcOutputs.iterator();
                while (bi2.hasNext()) {
                    Map rpcOutput = (Map)bi2.next();
                    outputs.add(MoneroDaemonRpc.convertRpcOutput(rpcOutput, tx));
                }
                tx.setOutputs(outputs);
                continue;
            }
            if (key.equals("rct_signatures")) {
                Map rctSignaturesMap = (Map)val;
                tx.setRctSignatures(GenUtils.reconcile(tx.getRctSignatures(), rctSignaturesMap));
                if (!rctSignaturesMap.containsKey("txnFee")) continue;
                tx.setFee(GenUtils.reconcile(tx.getFee(), (BigInteger)rctSignaturesMap.get("txnFee")));
                continue;
            }
            if (key.equals("rctsig_prunable")) {
                tx.setRctSigPrunable(GenUtils.reconcile(tx.getRctSigPrunable(), val));
                continue;
            }
            if (key.equals("unlock_time")) {
                tx.setUnlockTime(GenUtils.reconcile(tx.getUnlockTime(), (BigInteger)val));
                continue;
            }
            if (key.equals("as_json") || key.equals("tx_json")) continue;
            if (key.equals("as_hex") || key.equals("tx_blob")) {
                tx.setFullHex(GenUtils.reconcile(tx.getFullHex(), "".equals(val) ? null : (String)val));
                continue;
            }
            if (key.equals("blob_size")) {
                tx.setSize(GenUtils.reconcile(tx.getSize(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("weight")) {
                tx.setWeight(GenUtils.reconcile(tx.getWeight(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("fee")) {
                tx.setFee(GenUtils.reconcile(tx.getFee(), (BigInteger)val));
                continue;
            }
            if (key.equals("relayed")) {
                tx.setIsRelayed(GenUtils.reconcile(tx.isRelayed(), (Boolean)val));
                continue;
            }
            if (key.equals("output_indices")) {
                ArrayList<Long> indices = new ArrayList<Long>();
                for (Object bi2 : (List)val) {
                    indices.add(((BigInteger)bi2).longValue());
                }
                tx.setOutputIndices(GenUtils.reconcile(tx.getOutputIndices(), indices));
                continue;
            }
            if (key.equals("do_not_relay")) {
                tx.setRelay(GenUtils.reconcile(tx.getRelay(), (Boolean)val == false));
                continue;
            }
            if (key.equals("kept_by_block")) {
                tx.setIsKeptByBlock(GenUtils.reconcile(tx.isKeptByBlock(), (Boolean)val));
                continue;
            }
            if (key.equals("signatures")) {
                tx.setSignatures(GenUtils.reconcile(tx.getSignatures(), (List)val));
                continue;
            }
            if (key.equals("last_failed_height")) {
                long lastFailedHeight = ((BigInteger)val).longValue();
                if (lastFailedHeight == 0L) {
                    tx.setIsFailed(GenUtils.reconcile(tx.isFailed(), false));
                    continue;
                }
                tx.setIsFailed(GenUtils.reconcile(tx.isFailed(), true));
                tx.setLastFailedHeight(GenUtils.reconcile(tx.getLastFailedHeight(), lastFailedHeight));
                continue;
            }
            if (key.equals("last_failed_id_hash")) {
                if (DEFAULT_ID.equals(val)) {
                    tx.setIsFailed(GenUtils.reconcile(tx.isFailed(), false));
                    continue;
                }
                tx.setIsFailed(GenUtils.reconcile(tx.isFailed(), true));
                tx.setLastFailedHash(GenUtils.reconcile(tx.getLastFailedHash(), (String)val));
                continue;
            }
            if (key.equals("max_used_block_height")) {
                tx.setMaxUsedBlockHeight(GenUtils.reconcile(tx.getMaxUsedBlockHeight(), ((BigInteger)val).longValue()));
                continue;
            }
            if (key.equals("max_used_block_id_hash")) {
                tx.setMaxUsedBlockHash(GenUtils.reconcile(tx.getMaxUsedBlockHash(), (String)val));
                continue;
            }
            if (key.equals("prunable_hash")) {
                tx.setPrunableHash(GenUtils.reconcile(tx.getPrunableHash(), "".equals(val) ? null : (String)val));
                continue;
            }
            if (key.equals("prunable_as_hex")) {
                tx.setPrunableHex(GenUtils.reconcile(tx.getPrunableHex(), "".equals(val) ? null : (String)val));
                continue;
            }
            if (key.equals("pruned_as_hex")) {
                tx.setPrunedHex(GenUtils.reconcile(tx.getPrunedHex(), "".equals(val) ? null : (String)val));
                continue;
            }
            LOGGER.warning("ignoring unexpected field in rpc tx: " + key + ": " + val);
        }
        if (block != null) {
            tx.setBlock(block.setTxs(Arrays.asList(tx)));
        }
        if (tx.getBlock() != null && tx.getBlock().getHeight() != null && tx.getBlock().getHeight().longValue() == tx.getBlock().getTimestamp().longValue()) {
            tx.setBlock(null);
            tx.setIsConfirmed(false);
        }
        if (tx.isConfirmed().booleanValue()) {
            tx.setRelay(GenUtils.reconcile(tx.getRelay(), true));
            tx.setIsRelayed(GenUtils.reconcile(tx.isRelayed(), true));
            tx.setIsFailed(GenUtils.reconcile(tx.isFailed(), false));
        } else {
            tx.setNumConfirmations(0L);
        }
        if (tx.isFailed() == null) {
            tx.setIsFailed(false);
        }
        if (tx.getOutputIndices() != null && tx.getOutputs() != null) {
            GenUtils.assertEquals(tx.getOutputIndices().size(), tx.getOutputs().size());
            for (int i = 0; i < tx.getOutputs().size(); ++i) {
                tx.getOutputs().get(i).setIndex(tx.getOutputIndices().get(i));
            }
        }
        if (rpcTx.containsKey("as_json") && !"".equals(rpcTx.get("as_json"))) {
            MoneroDaemonRpc.convertRpcTx(JsonUtils.deserialize(MoneroRpcConnection.MAPPER, (String)rpcTx.get("as_json"), new TypeReference<Map<String, Object>>(){}), tx);
        }
        if (rpcTx.containsKey("tx_json") && !"".equals(rpcTx.get("tx_json"))) {
            MoneroDaemonRpc.convertRpcTx(JsonUtils.deserialize(MoneroRpcConnection.MAPPER, (String)rpcTx.get("tx_json"), new TypeReference<Map<String, Object>>(){}), tx);
        }
        if (!Boolean.TRUE.equals(tx.isRelayed())) {
            tx.setLastRelayedTimestamp(null);
        }
        return tx;
    }

    private static MoneroOutput convertRpcOutput(Map<String, Object> rpcOutput, MoneroTx tx) {
        MoneroOutput output = new MoneroOutput();
        output.setTx(tx);
        for (String key : rpcOutput.keySet()) {
            Object val = rpcOutput.get(key);
            if (key.equals("gen")) {
                throw new Error("Output with 'gen' from daemon rpc is miner tx which we ignore (i.e. each miner input is null)");
            }
            if (key.equals("key")) {
                Map rpcKey = (Map)val;
                output.setAmount(GenUtils.reconcile(output.getAmount(), (BigInteger)rpcKey.get("amount")));
                output.setKeyImage(GenUtils.reconcile(output.getKeyImage(), new MoneroKeyImage((String)rpcKey.get("k_image"))));
                ArrayList<Long> ringOutputIndices = new ArrayList<Long>();
                for (BigInteger bi : (List)rpcKey.get("key_offsets")) {
                    ringOutputIndices.add(bi.longValue());
                }
                output.setRingOutputIndices(GenUtils.reconcile(output.getRingOutputIndices(), ringOutputIndices));
                continue;
            }
            if (key.equals("amount")) {
                output.setAmount(GenUtils.reconcile(output.getAmount(), (BigInteger)val));
                continue;
            }
            if (key.equals("target")) {
                Map valMap = (Map)val;
                String pubKey = valMap.containsKey("key") ? (String)valMap.get("key") : (String)((Map)valMap.get("tagged_key")).get("key");
                output.setStealthPublicKey(GenUtils.reconcile(output.getStealthPublicKey(), pubKey));
                continue;
            }
            LOGGER.warning("ignoring unexpected field output: " + key + ": " + val);
        }
        return output;
    }

    private static MoneroDaemonUpdateCheckResult convertRpcUpdateCheckResult(Map<String, Object> rpcResult) {
        MoneroDaemonUpdateCheckResult result = new MoneroDaemonUpdateCheckResult();
        for (String key : rpcResult.keySet()) {
            Object val = rpcResult.get(key);
            if (key.equals("auto_uri")) {
                result.setAutoUri((String)val);
                continue;
            }
            if (key.equals("hash")) {
                result.setHash((String)val);
                continue;
            }
            if (key.equals("path") || key.equals("status")) continue;
            if (key.equals("update")) {
                result.setIsUpdateAvailable((Boolean)val);
                continue;
            }
            if (key.equals("user_uri")) {
                result.setUserUri((String)val);
                continue;
            }
            if (key.equals("version")) {
                result.setVersion((String)val);
                continue;
            }
            if (key.equals("untrusted")) continue;
            LOGGER.warning("ignoring unexpected field in rpc check update result: " + key + ": " + val);
        }
        if ("".equals(result.getAutoUri())) {
            result.setAutoUri(null);
        }
        if ("".equals(result.getUserUri())) {
            result.setUserUri(null);
        }
        if ("".equals(result.getVersion())) {
            result.setVersion(null);
        }
        if ("".equals(result.getHash())) {
            result.setHash(null);
        }
        return result;
    }

    private MoneroTxPoolStats convertRpcTxPoolStats(Map<String, Object> rpcStats) {
        MoneroTxPoolStats stats = new MoneroTxPoolStats();
        for (String key : rpcStats.keySet()) {
            Object val = rpcStats.get(key);
            if (key.equals("bytes_max")) {
                stats.setBytesMax(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("bytes_med")) {
                stats.setBytesMed(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("bytes_min")) {
                stats.setBytesMin(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("bytes_total")) {
                stats.setBytesTotal(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("histo_98pc")) {
                stats.setHisto98pc(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("num_10m")) {
                stats.setNum10m(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("num_double_spends")) {
                stats.setNumDoubleSpends(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("num_failing")) {
                stats.setNumFailing(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("num_not_relayed")) {
                stats.setNumNotRelayed(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("oldest")) {
                stats.setOldestTimestamp(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("txs_total")) {
                stats.setNumTxs(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("fee_total")) {
                stats.setFeeTotal((BigInteger)val);
                continue;
            }
            if (key.equals("histo")) {
                stats.setHisto(new HashMap<Long, Integer>());
                for (Map elem : (List)val) {
                    stats.getHisto().put(((BigInteger)elem.get("bytes")).longValue(), ((BigInteger)elem.get("txs")).intValue());
                }
                continue;
            }
            LOGGER.warning("ignoring unexpected field in tx pool stats: '" + key + "': " + val);
        }
        if (stats.getHisto98pc() == 0L) {
            stats.setHisto98pc(null);
        }
        if (stats.getNumTxs() == 0) {
            stats.setBytesMin(null);
            stats.setBytesMed(null);
            stats.setBytesMax(null);
            stats.setHisto98pc(null);
            stats.setOldestTimestamp(null);
        }
        return stats;
    }

    private static MoneroDaemonUpdateDownloadResult convertRpcUpdateDownloadResult(Map<String, Object> rpcResult) {
        MoneroDaemonUpdateDownloadResult result = new MoneroDaemonUpdateDownloadResult(MoneroDaemonRpc.convertRpcUpdateCheckResult(rpcResult));
        result.setDownloadPath((String)rpcResult.get("path"));
        if ("".equals(result.getDownloadPath())) {
            result.setDownloadPath(null);
        }
        return result;
    }

    private static MoneroPeer convertRpcPeer(Map<String, Object> rpcPeer) {
        GenUtils.assertNotNull(rpcPeer);
        MoneroPeer peer = new MoneroPeer();
        for (String key : rpcPeer.keySet()) {
            Object val = rpcPeer.get(key);
            if (key.equals("host")) {
                peer.setHost((String)val);
                continue;
            }
            if (key.equals("id")) {
                peer.setId("" + val);
                continue;
            }
            if (key.equals("ip")) continue;
            if (key.equals("last_seen")) {
                peer.setLastSeenTimestamp(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("port")) {
                peer.setPort(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("rpc_port")) {
                peer.setRpcPort(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("pruning_seed")) {
                peer.setPruningSeed(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("rpc_credits_per_hash")) {
                peer.setRpcCreditsPerHash((BigInteger)val);
                continue;
            }
            LOGGER.warning("ignoring unexpected field in rpc peer: " + key + ": " + val);
        }
        return peer;
    }

    private static MoneroSubmitTxResult convertRpcSubmitTxResult(Map<String, Object> rpcResult) {
        GenUtils.assertNotNull(rpcResult);
        MoneroSubmitTxResult result = new MoneroSubmitTxResult();
        for (String key : rpcResult.keySet()) {
            Object val = rpcResult.get(key);
            if (key.equals("double_spend")) {
                result.setIsDoubleSpend((Boolean)val);
                continue;
            }
            if (key.equals("fee_too_low")) {
                result.setIsFeeTooLow((Boolean)val);
                continue;
            }
            if (key.equals("invalid_input")) {
                result.setHasInvalidInput((Boolean)val);
                continue;
            }
            if (key.equals("invalid_output")) {
                result.setHasInvalidOutput((Boolean)val);
                continue;
            }
            if (key.equals("too_few_outputs")) {
                result.setHasTooFewOutputs((Boolean)val);
                continue;
            }
            if (key.equals("low_mixin")) {
                result.setIsMixinTooLow((Boolean)val);
                continue;
            }
            if (key.equals("not_relayed")) {
                result.setIsRelayed(!Boolean.TRUE.equals(val));
                continue;
            }
            if (key.equals("overspend")) {
                result.setIsOverspend((Boolean)val);
                continue;
            }
            if (key.equals("reason")) {
                result.setReason("".equals(val) ? null : (String)val);
                continue;
            }
            if (key.equals("too_big")) {
                result.setIsTooBig((Boolean)val);
                continue;
            }
            if (key.equals("sanity_check_failed")) {
                result.setSanityCheckFailed((Boolean)val);
                continue;
            }
            if (key.equals("credits")) {
                result.setCredits((BigInteger)val);
                continue;
            }
            if (key.equals("status") || key.equals("untrusted")) continue;
            if (key.equals("top_hash")) {
                result.setTopBlockHash("".equals(val) ? null : (String)val);
                continue;
            }
            if (key.equals("tx_extra_too_big")) {
                result.setIsTxExtraTooBig((Boolean)val);
                continue;
            }
            if (key.equals("nonzero_unlock_time")) {
                result.setIsNonzeroUnlockTime((Boolean)val);
                continue;
            }
            LOGGER.warning("ignoring unexpected field in submit tx hex result: " + key + ": " + val);
        }
        return result;
    }

    private static MoneroPeer convertRpcConnection(Map<String, Object> rpcConnection) {
        MoneroPeer peer = new MoneroPeer();
        peer.setIsOnline(true);
        for (String key : rpcConnection.keySet()) {
            Object val = rpcConnection.get(key);
            if (key.equals("address")) {
                peer.setAddress((String)val);
                continue;
            }
            if (key.equals("avg_download")) {
                peer.setAvgDownload(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("avg_upload")) {
                peer.setAvgUpload(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("connection_id")) {
                peer.setHash((String)val);
                continue;
            }
            if (key.equals("current_download")) {
                peer.setCurrentDownload(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("current_upload")) {
                peer.setCurrentUpload(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("height")) {
                peer.setHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("host")) {
                peer.setHost((String)val);
                continue;
            }
            if (key.equals("ip")) continue;
            if (key.equals("incoming")) {
                peer.setIsIncoming((Boolean)val);
                continue;
            }
            if (key.equals("live_time")) {
                peer.setLiveTime(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("local_ip")) {
                peer.setIsLocalIp((Boolean)val);
                continue;
            }
            if (key.equals("localhost")) {
                peer.setIsLocalHost((Boolean)val);
                continue;
            }
            if (key.equals("peer_id")) {
                peer.setId((String)val);
                continue;
            }
            if (key.equals("port")) {
                peer.setPort(Integer.parseInt((String)val));
                continue;
            }
            if (key.equals("rpc_port")) {
                peer.setRpcPort(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("recv_count")) {
                peer.setNumReceives(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("recv_idle_time")) {
                peer.setReceiveIdleTime(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("send_count")) {
                peer.setNumSends(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("send_idle_time")) {
                peer.setSendIdleTime(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("state")) {
                peer.setState((String)val);
                continue;
            }
            if (key.equals("support_flags")) {
                peer.setNumSupportFlags(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("pruning_seed")) {
                peer.setPruningSeed(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("rpc_credits_per_hash")) {
                peer.setRpcCreditsPerHash((BigInteger)val);
                continue;
            }
            if (key.equals("address_type")) {
                int rpcType = ((BigInteger)val).intValue();
                if (rpcType == 0) {
                    peer.setType(ConnectionType.INVALID);
                    continue;
                }
                if (rpcType == 1) {
                    peer.setType(ConnectionType.IPV4);
                    continue;
                }
                if (rpcType == 2) {
                    peer.setType(ConnectionType.IPV6);
                    continue;
                }
                if (rpcType == 3) {
                    peer.setType(ConnectionType.TOR);
                    continue;
                }
                if (rpcType == 4) {
                    peer.setType(ConnectionType.I2P);
                    continue;
                }
                throw new MoneroError("Invalid RPC peer type, expected 0-4: " + rpcType);
            }
            LOGGER.warning("ignoring unexpected field in peer: " + key + ": " + val);
        }
        return peer;
    }

    private static MoneroOutputHistogramEntry convertRpcOutputHistogramEntry(Map<String, Object> rpcEntry) {
        MoneroOutputHistogramEntry entry = new MoneroOutputHistogramEntry();
        for (String key : rpcEntry.keySet()) {
            Object val = rpcEntry.get(key);
            if (key.equals("amount")) {
                entry.setAmount((BigInteger)val);
                continue;
            }
            if (key.equals("total_instances")) {
                entry.setNumInstances(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("unlocked_instances")) {
                entry.setNumUnlockedInstances(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("recent_instances")) {
                entry.setNumRecentInstances(((BigInteger)val).longValue());
                continue;
            }
            LOGGER.warning("ignoring unexpected field in output histogram: " + key + ": " + val);
        }
        return entry;
    }

    private static MoneroDaemonInfo convertRpcInfo(Map<String, Object> rpcInfo) {
        if (rpcInfo == null) {
            return null;
        }
        MoneroDaemonInfo info = new MoneroDaemonInfo();
        for (String key : rpcInfo.keySet()) {
            Object val = rpcInfo.get(key);
            if (key.equals("version")) {
                info.setVersion((String)val);
                continue;
            }
            if (key.equals("alt_blocks_count")) {
                info.setNumAltBlocks(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("block_size_limit")) {
                info.setBlockSizeLimit(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("block_size_median")) {
                info.setBlockSizeMedian(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("block_weight_limit")) {
                info.setBlockWeightLimit(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("block_weight_median")) {
                info.setBlockWeightMedian(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("bootstrap_daemon_address")) {
                if (((String)val).isEmpty()) continue;
                info.setBootstrapDaemonAddress((String)val);
                continue;
            }
            if (key.equals("difficulty") || key.equals("cumulative_difficulty") || key.equals("difficulty_top64") || key.equals("cumulative_difficulty_top64")) continue;
            if (key.equals("wide_difficulty")) {
                info.setDifficulty(GenUtils.reconcile(info.getDifficulty(), MoneroDaemonRpc.prefixedHexToBI((String)val)));
                continue;
            }
            if (key.equals("wide_cumulative_difficulty")) {
                info.setCumulativeDifficulty(GenUtils.reconcile(info.getCumulativeDifficulty(), MoneroDaemonRpc.prefixedHexToBI((String)val)));
                continue;
            }
            if (key.equals("free_space")) {
                info.setFreeSpace((BigInteger)val);
                continue;
            }
            if (key.equals("database_size")) {
                info.setDatabaseSize(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("grey_peerlist_size")) {
                info.setNumOfflinePeers(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("height")) {
                info.setHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("height_without_bootstrap")) {
                info.setHeightWithoutBootstrap(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("incoming_connections_count")) {
                info.setNumIncomingConnections(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("offline")) {
                info.setIsOffline((Boolean)val);
                continue;
            }
            if (key.equals("outgoing_connections_count")) {
                info.setNumOutgoingConnections(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("rpc_connections_count")) {
                info.setNumRpcConnections(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("start_time")) {
                info.setStartTimestamp(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("adjusted_time")) {
                info.setAdjustedTimestamp(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("status")) continue;
            if (key.equals("target")) {
                info.setTarget(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("target_height")) {
                info.setTargetHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("tx_count")) {
                info.setNumTxs(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("tx_pool_size")) {
                info.setNumTxsPool(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("untrusted")) continue;
            if (key.equals("was_bootstrap_ever_used")) {
                info.setWasBootstrapEverUsed((Boolean)val);
                continue;
            }
            if (key.equals("white_peerlist_size")) {
                info.setNumOnlinePeers(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("update_available")) {
                info.setUpdateAvailable((Boolean)val);
                continue;
            }
            if (key.equals("nettype")) {
                info.setNetworkType(GenUtils.reconcile(info.getNetworkType(), MoneroDaemon.parseNetworkType((String)val)));
                continue;
            }
            if (key.equals("mainnet")) {
                if (!((Boolean)val).booleanValue()) continue;
                info.setNetworkType(GenUtils.reconcile(info.getNetworkType(), MoneroNetworkType.MAINNET));
                continue;
            }
            if (key.equals("testnet")) {
                if (!((Boolean)val).booleanValue()) continue;
                info.setNetworkType(GenUtils.reconcile(info.getNetworkType(), MoneroNetworkType.TESTNET));
                continue;
            }
            if (key.equals("stagenet")) {
                if (!((Boolean)val).booleanValue()) continue;
                info.setNetworkType(GenUtils.reconcile(info.getNetworkType(), MoneroNetworkType.STAGENET));
                continue;
            }
            if (key.equals("credits")) {
                info.setCredits((BigInteger)val);
                continue;
            }
            if (key.equals("top_block_hash") || key.equals("top_hash")) {
                info.setTopBlockHash(GenUtils.reconcile(info.getTopBlockHash(), "".equals(val) ? null : (String)val));
                continue;
            }
            if (key.equals("busy_syncing")) {
                info.setIsBusySyncing((Boolean)val);
                continue;
            }
            if (key.equals("synchronized")) {
                info.setIsSynchronized((Boolean)val);
                continue;
            }
            if (key.equals("restricted")) {
                info.setIsRestricted((Boolean)val);
                continue;
            }
            LOGGER.warning("Ignoring unexpected info field: " + key + ": " + val);
        }
        return info;
    }

    private static MoneroDaemonSyncInfo convertRpcSyncInfo(Map<String, Object> rpcSyncInfo) {
        MoneroDaemonSyncInfo syncInfo = new MoneroDaemonSyncInfo();
        for (String key : rpcSyncInfo.keySet()) {
            Object val = rpcSyncInfo.get(key);
            if (key.equals("height")) {
                syncInfo.setHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("peers")) {
                syncInfo.setPeers(new ArrayList<MoneroPeer>());
                List rpcConnections = (List)val;
                for (Map rpcConnection : rpcConnections) {
                    syncInfo.getPeers().add(MoneroDaemonRpc.convertRpcConnection((Map)rpcConnection.get("info")));
                }
                continue;
            }
            if (key.equals("spans")) {
                syncInfo.setSpans(new ArrayList<MoneroConnectionSpan>());
                List rpcSpans = (List)val;
                for (Map rpcSpan : rpcSpans) {
                    syncInfo.getSpans().add(MoneroDaemonRpc.convertRpcConnectionSpan(rpcSpan));
                }
                continue;
            }
            if (key.equals("status")) continue;
            if (key.equals("target_height")) {
                syncInfo.setTargetHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("next_needed_pruning_seed")) {
                syncInfo.setNextNeededPruningSeed(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("overview")) {
                try {
                    List<Object> overview = JsonUtils.deserialize((String)val, new TypeReference<List<Object>>(){});
                    if (overview.isEmpty()) continue;
                    LOGGER.warning("ignoring non-empty 'overview' field (not implemented): " + overview);
                }
                catch (Exception e) {
                    LOGGER.warning("Failed to parse 'overview' field: " + val);
                }
                continue;
            }
            if (key.equals("credits")) {
                syncInfo.setCredits((BigInteger)val);
                continue;
            }
            if (key.equals("top_hash")) {
                syncInfo.setTopBlockHash("".equals(val) ? null : (String)val);
                continue;
            }
            if (key.equals("untrusted")) continue;
            LOGGER.warning("ignoring unexpected field in sync info: " + key + ": " + val);
        }
        return syncInfo;
    }

    private static MoneroHardForkInfo convertRpcHardForkInfo(Map<String, Object> rpcHardForkInfo) {
        MoneroHardForkInfo info = new MoneroHardForkInfo();
        for (String key : rpcHardForkInfo.keySet()) {
            Object val = rpcHardForkInfo.get(key);
            if (key.equals("earliest_height")) {
                info.setEarliestHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("enabled")) {
                info.setIsEnabled((Boolean)val);
                continue;
            }
            if (key.equals("state")) {
                info.setState(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("status") || key.equals("untrusted")) continue;
            if (key.equals("threshold")) {
                info.setThreshold(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("version")) {
                info.setVersion(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("votes")) {
                info.setNumVotes(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("voting")) {
                info.setVoting(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("window")) {
                info.setWindow(((BigInteger)val).intValue());
                continue;
            }
            if (key.equals("credits")) {
                info.setCredits((BigInteger)val);
                continue;
            }
            if (key.equals("top_hash")) {
                info.setTopBlockHash("".equals(val) ? null : (String)val);
                continue;
            }
            LOGGER.warning("ignoring unexpected field in hard fork info: " + key + ": " + val);
        }
        return info;
    }

    private static MoneroConnectionSpan convertRpcConnectionSpan(Map<String, Object> rpcConnectionSpan) {
        MoneroConnectionSpan span = new MoneroConnectionSpan();
        for (String key : rpcConnectionSpan.keySet()) {
            Object val = rpcConnectionSpan.get(key);
            if (key.equals("connection_id")) {
                span.setConnectionId((String)val);
                continue;
            }
            if (key.equals("nblocks")) {
                span.setNumBlocks(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("rate")) {
                span.setRate(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("remote_address")) {
                if ("".equals(val)) continue;
                span.setRemoteAddress((String)val);
                continue;
            }
            if (key.equals("size")) {
                span.setSize(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("speed")) {
                span.setSpeed(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("start_block_height")) {
                span.setStartHeight(((BigInteger)val).longValue());
                continue;
            }
            LOGGER.warning("ignoring unexpected field in daemon connection span: " + key + ": " + val);
        }
        return span;
    }

    private static Map<String, Object> convertToRpcBan(MoneroBan ban) {
        HashMap<String, Object> rpcBan = new HashMap<String, Object>();
        rpcBan.put("host", ban.getHost());
        rpcBan.put("ip", ban.getIp());
        rpcBan.put("ban", ban.isBanned());
        rpcBan.put("seconds", ban.getSeconds());
        return rpcBan;
    }

    private static MoneroMiningStatus convertRpcMiningStatus(Map<String, Object> rpcStatus) {
        MoneroMiningStatus status = new MoneroMiningStatus();
        status.setIsActive((Boolean)rpcStatus.get("active"));
        status.setSpeed(((BigInteger)rpcStatus.get("speed")).longValue());
        status.setNumThreads(((BigInteger)rpcStatus.get("threads_count")).intValue());
        if (status.isActive().booleanValue()) {
            status.setAddress((String)rpcStatus.get("address"));
            status.setIsBackground((Boolean)rpcStatus.get("is_background_mining_enabled"));
        }
        return status;
    }

    private static MoneroAltChain convertRpcAltChain(Map<String, Object> rpcChain) {
        MoneroAltChain chain = new MoneroAltChain();
        for (String key : rpcChain.keySet()) {
            Object val = rpcChain.get(key);
            if (key.equals("block_hash") || key.equals("difficulty") || key.equals("difficulty_top64")) continue;
            if (key.equals("wide_difficulty")) {
                chain.setDifficulty(GenUtils.reconcile(chain.getDifficulty(), MoneroDaemonRpc.prefixedHexToBI((String)val)));
                continue;
            }
            if (key.equals("height")) {
                chain.setHeight(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("length")) {
                chain.setLength(((BigInteger)val).longValue());
                continue;
            }
            if (key.equals("block_hashes")) {
                chain.setBlockHashes((List)val);
                continue;
            }
            if (key.equals("main_chain_parent_block")) {
                chain.setMainChainParentBlockHash((String)val);
                continue;
            }
            LOGGER.warning("ignoring unexpected field in alternative chain: " + key + ": " + val);
        }
        return chain;
    }

    private static BigInteger prefixedHexToBI(String hex) {
        GenUtils.assertTrue("Given hex does not start with \"0x\": " + hex, hex.startsWith("0x"));
        return new BigInteger(hex.substring(2), 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshListening() {
        List<MoneroDaemonListener> list = this.listeners;
        synchronized (list) {
            if (this.daemonPoller == null && this.listeners.size() > 0) {
                this.daemonPoller = new DaemonPoller(this);
            }
            if (this.daemonPoller != null) {
                this.daemonPoller.setIsPolling(this.listeners.size() > 0);
            }
        }
    }

    private class DaemonPoller {
        private static final long DEFAULT_POLL_PERIOD_IN_MS = 10000L;
        private MoneroDaemonRpc daemon;
        private TaskLooper looper;
        private MoneroBlockHeader lastHeader;

        public DaemonPoller(MoneroDaemonRpc daemon) {
            this.daemon = daemon;
            this.looper = new TaskLooper(new Runnable(){

                @Override
                public void run() {
                    DaemonPoller.this.poll();
                }
            });
        }

        public void setIsPolling(boolean isPolling) {
            if (isPolling) {
                this.looper.start(10000L);
            } else {
                this.looper.stop();
            }
        }

        private void poll() {
            try {
                if (this.lastHeader == null) {
                    this.lastHeader = this.daemon.getLastBlockHeader();
                    return;
                }
                MoneroBlockHeader header = this.daemon.getLastBlockHeader();
                if (!header.getHash().equals(this.lastHeader.getHash())) {
                    this.lastHeader = header;
                    this.announceBlockHeader(header);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void announceBlockHeader(MoneroBlockHeader header) {
            List<MoneroDaemonListener> list = this.daemon.getListeners();
            synchronized (list) {
                for (MoneroDaemonListener listener : this.daemon.getListeners()) {
                    try {
                        listener.onBlockHeader(header);
                    }
                    catch (Exception e) {
                        System.err.println("Error calling listener on new block header: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

