/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import monero.daemon.MoneroDaemon;
import monero.daemon.model.MoneroBan;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroBlockTemplate;
import monero.daemon.model.MoneroDaemonUpdateDownloadResult;
import monero.daemon.model.MoneroFeeEstimate;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import monero.daemon.model.MoneroOutputDistributionEntry;
import monero.daemon.model.MoneroSubmitTxResult;
import monero.daemon.model.MoneroTx;

public abstract class MoneroDaemonDefault
implements MoneroDaemon {
    @Override
    public MoneroBlockTemplate getBlockTemplate(String walletAddress) {
        return this.getBlockTemplate(walletAddress, null);
    }

    @Override
    public List<MoneroBlock> getBlocksByRangeChunked(Long startHeight, Long endHeight) {
        return this.getBlocksByRangeChunked(startHeight, endHeight, null);
    }

    @Override
    public MoneroTx getTx(String txHash) {
        return this.getTx(txHash, null);
    }

    @Override
    public MoneroTx getTx(String txHash, Boolean prune) {
        List<MoneroTx> txs = this.getTxs(Arrays.asList(txHash), prune);
        return txs.size() == 0 ? null : txs.get(0);
    }

    @Override
    public List<MoneroTx> getTxs(Collection<String> txHashes) {
        return this.getTxs(txHashes, null);
    }

    @Override
    public String getTxHex(String txHash) {
        return this.getTxHex(txHash, false);
    }

    @Override
    public String getTxHex(String txHash, Boolean prune) {
        return this.getTxHexes(Arrays.asList(txHash), prune).get(0);
    }

    @Override
    public List<String> getTxHexes(Collection<String> txHashes) {
        return this.getTxHexes(txHashes, null);
    }

    @Override
    public MoneroFeeEstimate getFeeEstimate() {
        return this.getFeeEstimate(null);
    }

    @Override
    public MoneroSubmitTxResult submitTxHex(String txHex) {
        return this.submitTxHex(txHex, false);
    }

    @Override
    public void relayTxByHash(String txHash) {
        this.relayTxsByHash(Arrays.asList(txHash));
    }

    @Override
    public MoneroKeyImageSpentStatus getKeyImageSpentStatus(String keyImage) {
        return this.getKeyImageSpentStatuses(Arrays.asList(keyImage)).get(0);
    }

    @Override
    public List<MoneroOutputDistributionEntry> getOutputDistribution(Collection<BigInteger> amounts) {
        return this.getOutputDistribution(amounts, null, null, null);
    }

    @Override
    public void setPeerBan(MoneroBan ban) {
        this.setPeerBans(Arrays.asList(ban));
    }

    @Override
    public void submitBlock(String blockBlob) {
        this.submitBlocks(Arrays.asList(blockBlob));
    }

    @Override
    public MoneroDaemonUpdateDownloadResult downloadUpdate() {
        return this.downloadUpdate(null);
    }
}

