/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import monero.daemon.model.MoneroAltChain;
import monero.daemon.model.MoneroBan;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroBlockHeader;
import monero.daemon.model.MoneroBlockTemplate;
import monero.daemon.model.MoneroDaemonInfo;
import monero.daemon.model.MoneroDaemonListener;
import monero.daemon.model.MoneroDaemonSyncInfo;
import monero.daemon.model.MoneroDaemonUpdateCheckResult;
import monero.daemon.model.MoneroDaemonUpdateDownloadResult;
import monero.daemon.model.MoneroFeeEstimate;
import monero.daemon.model.MoneroHardForkInfo;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import monero.daemon.model.MoneroMinerTxSum;
import monero.daemon.model.MoneroMiningStatus;
import monero.daemon.model.MoneroNetworkType;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroOutputDistributionEntry;
import monero.daemon.model.MoneroOutputHistogramEntry;
import monero.daemon.model.MoneroPeer;
import monero.daemon.model.MoneroPruneResult;
import monero.daemon.model.MoneroSubmitTxResult;
import monero.daemon.model.MoneroTx;
import monero.daemon.model.MoneroTxBacklogEntry;
import monero.daemon.model.MoneroTxPoolStats;
import monero.daemon.model.MoneroVersion;

public interface MoneroDaemon {
    public void addListener(MoneroDaemonListener var1);

    public void removeListener(MoneroDaemonListener var1);

    public List<MoneroDaemonListener> getListeners();

    public MoneroVersion getVersion();

    public boolean isTrusted();

    public long getHeight();

    public String getBlockHash(long var1);

    public MoneroBlockTemplate getBlockTemplate(String var1);

    public MoneroBlockTemplate getBlockTemplate(String var1, Integer var2);

    public MoneroBlockHeader getLastBlockHeader();

    public MoneroBlockHeader getBlockHeaderByHash(String var1);

    public MoneroBlockHeader getBlockHeaderByHeight(long var1);

    public List<MoneroBlockHeader> getBlockHeadersByRange(Long var1, Long var2);

    public MoneroBlock getBlockByHash(String var1);

    public List<MoneroBlock> getBlocksByHash(List<String> var1, Long var2, Boolean var3);

    public MoneroBlock getBlockByHeight(long var1);

    public List<MoneroBlock> getBlocksByHeight(List<Long> var1);

    public List<MoneroBlock> getBlocksByRange(Long var1, Long var2);

    public List<MoneroBlock> getBlocksByRangeChunked(Long var1, Long var2);

    public List<MoneroBlock> getBlocksByRangeChunked(Long var1, Long var2, Long var3);

    public List<String> getBlockHashes(List<String> var1, Long var2);

    public MoneroTx getTx(String var1);

    public MoneroTx getTx(String var1, Boolean var2);

    public List<MoneroTx> getTxs(Collection<String> var1);

    public List<MoneroTx> getTxs(Collection<String> var1, Boolean var2);

    public String getTxHex(String var1);

    public String getTxHex(String var1, Boolean var2);

    public List<String> getTxHexes(Collection<String> var1);

    public List<String> getTxHexes(Collection<String> var1, Boolean var2);

    public MoneroMinerTxSum getMinerTxSum(long var1, Long var3);

    public MoneroFeeEstimate getFeeEstimate();

    public MoneroFeeEstimate getFeeEstimate(Integer var1);

    public MoneroSubmitTxResult submitTxHex(String var1);

    public MoneroSubmitTxResult submitTxHex(String var1, Boolean var2);

    public void relayTxByHash(String var1);

    public void relayTxsByHash(Collection<String> var1);

    public List<MoneroTx> getTxPool();

    public List<String> getTxPoolHashes();

    public List<MoneroTxBacklogEntry> getTxPoolBacklog();

    public MoneroTxPoolStats getTxPoolStats();

    public void flushTxPool();

    public void flushTxPool(String ... var1);

    public void flushTxPool(Collection<String> var1);

    public MoneroKeyImageSpentStatus getKeyImageSpentStatus(String var1);

    public List<MoneroKeyImageSpentStatus> getKeyImageSpentStatuses(List<String> var1);

    public List<MoneroOutput> getOutputs(Collection<MoneroOutput> var1);

    public List<MoneroOutputHistogramEntry> getOutputHistogram(Collection<BigInteger> var1, Integer var2, Integer var3, Boolean var4, Integer var5);

    public List<MoneroOutputDistributionEntry> getOutputDistribution(Collection<BigInteger> var1);

    public List<MoneroOutputDistributionEntry> getOutputDistribution(Collection<BigInteger> var1, Boolean var2, Long var3, Long var4);

    public MoneroDaemonInfo getInfo();

    public MoneroDaemonSyncInfo getSyncInfo();

    public MoneroHardForkInfo getHardForkInfo();

    public List<MoneroAltChain> getAltChains();

    public List<String> getAltBlockHashes();

    public int getDownloadLimit();

    public int setDownloadLimit(int var1);

    public int resetDownloadLimit();

    public int getUploadLimit();

    public int setUploadLimit(int var1);

    public int resetUploadLimit();

    public List<MoneroPeer> getPeers();

    public List<MoneroPeer> getKnownPeers();

    public void setOutgoingPeerLimit(int var1);

    public void setIncomingPeerLimit(int var1);

    public List<MoneroBan> getPeerBans();

    public void setPeerBan(MoneroBan var1);

    public void setPeerBans(List<MoneroBan> var1);

    public void startMining(String var1, Long var2, Boolean var3, Boolean var4);

    public void stopMining();

    public MoneroMiningStatus getMiningStatus();

    public void submitBlock(String var1);

    public void submitBlocks(Collection<String> var1);

    public MoneroPruneResult pruneBlockchain(boolean var1);

    public MoneroDaemonUpdateCheckResult checkForUpdate();

    public MoneroDaemonUpdateDownloadResult downloadUpdate();

    public MoneroDaemonUpdateDownloadResult downloadUpdate(String var1);

    public void stop();

    public MoneroBlockHeader waitForNextBlockHeader();

    public static MoneroNetworkType parseNetworkType(String network) {
        if ("mainnet".equals(network)) {
            return MoneroNetworkType.MAINNET;
        }
        if ("testnet".equals(network)) {
            return MoneroNetworkType.TESTNET;
        }
        if ("stagenet".equals(network)) {
            return MoneroNetworkType.STAGENET;
        }
        throw new Error("Invalid network type to parse: " + network);
    }
}

