/*
 * Decompiled with CFR 0.152.
 */
package monero.common;

import java.util.concurrent.TimeUnit;

public class TaskLooper {
    private Runnable task;
    private long periodInMs;
    private boolean isStarted;
    private boolean isLooping;

    public TaskLooper(Runnable task) {
        this.task = task;
    }

    public Runnable getTask() {
        return this.task;
    }

    public synchronized TaskLooper start(long periodInMs) {
        this.start(periodInMs, false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskLooper start(long periodInMs, final boolean targetFixedPeriod) {
        TaskLooper taskLooper = this;
        synchronized (taskLooper) {
            this.setPeriodInMs(periodInMs);
            if (this.isStarted) {
                return this;
            }
            this.isStarted = true;
            if (this.isLooping) {
                return this;
            }
            this.isLooping = true;
            final TaskLooper that = this;
            Thread loop = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (TaskLooper.this.isStarted && !Thread.currentThread().isInterrupted()) {
                        long startTime = System.currentTimeMillis();
                        TaskLooper.this.task.run();
                        if (!TaskLooper.this.isStarted) continue;
                        try {
                            TimeUnit.MILLISECONDS.sleep(that.periodInMs - (targetFixedPeriod ? System.currentTimeMillis() - startTime : 0L));
                        }
                        catch (Exception e) {
                            TaskLooper.this.isLooping = false;
                            if (!TaskLooper.this.isStarted) continue;
                            throw new RuntimeException(e);
                        }
                    }
                    TaskLooper.this.isLooping = false;
                }
            });
            loop.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        TaskLooper taskLooper = this;
        synchronized (taskLooper) {
            return this.isStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TaskLooper taskLooper = this;
        synchronized (taskLooper) {
            this.isStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeriodInMs(long periodInMs) {
        if (periodInMs <= 0L) {
            throw new RuntimeException("Looper period must be greater than 0 ms");
        }
        TaskLooper taskLooper = this;
        synchronized (taskLooper) {
            this.periodInMs = periodInMs;
        }
    }
}

