/*
 * Decompiled with CFR 0.152.
 */
package monero.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import common.utils.JsonUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import monero.common.MoneroError;
import monero.common.MoneroRpcError;
import monero.common.MoneroUtils;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class MoneroRpcConnection {
    public static ObjectMapper MAPPER = new ObjectMapper();
    private CloseableHttpClient client;
    private String uri;
    private String username;
    private String password;
    private String zmqUri;
    private int priority = 0;
    private Long timeoutMs;
    private Boolean isOnline;
    private Boolean isAuthenticated;
    private Long responseTime;
    private String proxyUri;
    private boolean printStackTrace;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public MoneroRpcConnection(URI uri) {
        this(uri, null, null, null);
    }

    public MoneroRpcConnection(String uri) {
        this(uri, null, null);
    }

    public MoneroRpcConnection(String uri, String username, String password) {
        this(uri == null ? null : MoneroUtils.parseUri(uri), username, password, null);
    }

    public MoneroRpcConnection(String uri, String username, String password, String zmqUri) {
        this(uri == null ? null : MoneroUtils.parseUri(uri), username, password, zmqUri == null ? null : MoneroUtils.parseUri(zmqUri));
    }

    public MoneroRpcConnection(URI uri, String username, String password) {
        this(uri, username, password, null);
    }

    public MoneroRpcConnection(URI uri, String username, String password, URI zmqUri) {
        this.uri = uri == null ? null : MoneroUtils.parseUri(uri.toString()).toString();
        this.setCredentials(username, password);
    }

    public MoneroRpcConnection(MoneroRpcConnection connection) {
        this(connection.uri, connection.username, connection.password, connection.zmqUri);
        this.priority = connection.priority;
        this.isOnline = connection.isOnline;
        this.isAuthenticated = connection.isAuthenticated;
        this.responseTime = connection.responseTime;
        this.proxyUri = connection.proxyUri;
        this.printStackTrace = connection.printStackTrace;
    }

    public String getUri() {
        return this.uri;
    }

    public MoneroRpcConnection setUri(String uri) {
        return this.setUri(MoneroUtils.parseUri(uri));
    }

    public MoneroRpcConnection setUri(URI uri) {
        this.uri = MoneroUtils.parseUri(uri.toString()).toString();
        this.setCredentials(this.username, this.password);
        return this;
    }

    public boolean isOnion() {
        try {
            return new URI(this.uri).getHost().endsWith(".onion");
        }
        catch (Exception e) {
            return false;
        }
    }

    public MoneroRpcConnection setCredentials(String username, String password) {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            throw new MoneroError(e);
        }
        if ("".equals(username)) {
            username = null;
        }
        if ("".equals(password)) {
            password = null;
        }
        if (username != null || password != null) {
            if (username == null) {
                throw new MoneroError("username cannot be empty because password is not empty");
            }
            if (password == null) {
                throw new MoneroError("password cannot be empty because username is not empty");
            }
            URI uriObj = MoneroUtils.parseUri(this.uri);
            BasicCredentialsProvider creds = new BasicCredentialsProvider();
            creds.setCredentials(new AuthScope(uriObj.getHost(), uriObj.getPort()), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
            this.client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)creds).build();
        } else {
            this.client = HttpClients.createDefault();
        }
        if (!Objects.equals(this.username, username) || !Objects.equals(this.password, password)) {
            this.isOnline = null;
            this.isAuthenticated = null;
        }
        this.username = username;
        this.password = password;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getZmqUri() {
        return this.zmqUri;
    }

    public MoneroRpcConnection setZmqUri(String zmqUri) {
        this.zmqUri = zmqUri;
        return this;
    }

    public MoneroRpcConnection setProxyUri(String proxyUri) {
        this.proxyUri = proxyUri;
        return this;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public MoneroRpcConnection setPriority(int priority) {
        if (priority < 0) {
            throw new MoneroError("Priority must be >= 0");
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public MoneroRpcConnection setTimeout(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public Long getTimeout() {
        return this.timeoutMs;
    }

    public MoneroRpcConnection setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection(long timeoutMs) {
        MoneroRpcConnection moneroRpcConnection = this;
        synchronized (moneroRpcConnection) {
            long startTime;
            Boolean isAuthenticatedBefore;
            Boolean isOnlineBefore;
            block10: {
                isOnlineBefore = this.isOnline;
                isAuthenticatedBefore = this.isAuthenticated;
                startTime = System.currentTimeMillis();
                try {
                    if (MoneroUtils.isNativeLibraryLoaded()) {
                        ArrayList<Long> heights = new ArrayList<Long>();
                        for (long i = 0L; i < 100L; ++i) {
                            heights.add(i);
                        }
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("heights", heights);
                        this.sendBinaryRequest("get_blocks_by_height.bin", params, timeoutMs);
                    } else {
                        this.sendJsonRequest("get_version", null, timeoutMs);
                    }
                    this.isOnline = true;
                    this.isAuthenticated = true;
                }
                catch (Exception e) {
                    this.isOnline = false;
                    this.isAuthenticated = null;
                    this.responseTime = null;
                    if (!(e instanceof MoneroRpcError)) break block10;
                    if (((MoneroRpcError)e).getCode() == 401) {
                        this.isOnline = true;
                        this.isAuthenticated = false;
                    }
                    if (((MoneroRpcError)e).getCode() != 404) break block10;
                    this.isOnline = true;
                    this.isAuthenticated = true;
                }
            }
            if (this.isOnline.booleanValue()) {
                this.responseTime = System.currentTimeMillis() - startTime;
            }
            return isOnlineBefore != this.isOnline || isAuthenticatedBefore != this.isAuthenticated;
        }
    }

    public Boolean isConnected() {
        return this.isOnline == null ? null : Boolean.valueOf(this.isOnline != false && !Boolean.FALSE.equals(this.isAuthenticated));
    }

    public Boolean isOnline() {
        return this.isOnline;
    }

    public Boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public Map<String, Object> sendJsonRequest(String method) {
        return this.sendJsonRequest(method, null);
    }

    public Map<String, Object> sendJsonRequest(String method, Object params) {
        return this.sendJsonRequest(method, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sendJsonRequest(String method, Object params, Long timeoutMs) {
        CloseableHttpResponse resp = null;
        try {
            Map<String, Object> respMap;
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("jsonrpc", "2.0");
            body.put("id", "0");
            body.put("method", method);
            if (params != null) {
                body.put("params", params);
            }
            HttpPost post = new HttpPost(this.uri.toString() + "/json_rpc");
            post.setConfig(this.getRequestConfig(timeoutMs == null ? this.timeoutMs : timeoutMs));
            StringEntity entity = new StringEntity(JsonUtils.serialize(body));
            post.setEntity((HttpEntity)entity);
            Object object = this;
            synchronized (object) {
                if (MoneroUtils.getLogLevel() >= 2) {
                    MoneroUtils.log(2, "Sending json request with method='" + method + "', body=" + JsonUtils.serialize(body) + ", uri=" + this.uri);
                }
                if (this.printStackTrace) {
                    try {
                        throw new RuntimeException("Debug stack trace for json request with method '" + method + "' and body " + JsonUtils.serialize(body));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                long startTime = System.currentTimeMillis();
                resp = this.request((HttpUriRequest)post);
                MoneroRpcConnection.validateHttpResponse(resp);
                respMap = JsonUtils.toMap(MAPPER, EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8"));
                EntityUtils.consume((HttpEntity)resp.getEntity());
                if (MoneroUtils.getLogLevel() >= 3) {
                    String respStr = JsonUtils.serialize(respMap);
                    respStr = respStr.substring(0, Math.min(10000, respStr.length()));
                    MoneroUtils.log(3, "Received json response from method='" + method + "', response=" + respStr + ", uri=" + this.uri + " (" + (System.currentTimeMillis() - startTime) + " ms)");
                }
            }
            this.validateRpcResponse(respMap, method, params);
            object = respMap;
            return object;
        }
        catch (MoneroRpcError e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new MoneroError(e2);
        }
        finally {
            try {
                resp.close();
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, Object> sendPathRequest(String path) {
        return this.sendPathRequest(path, null, null);
    }

    public Map<String, Object> sendPathRequest(String path, Map<String, Object> params) {
        return this.sendPathRequest(path, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sendPathRequest(String path, Map<String, Object> params, Long timeoutMs) {
        CloseableHttpResponse resp = null;
        try {
            Map<String, Object> respMap;
            HttpPost post = new HttpPost(this.uri.toString() + "/" + path);
            if (params != null) {
                StringEntity entity = new StringEntity(JsonUtils.serialize(params));
                post.setEntity((HttpEntity)entity);
            }
            post.setConfig(this.getRequestConfig(timeoutMs == null ? this.timeoutMs : timeoutMs));
            Object object = this;
            synchronized (object) {
                if (MoneroUtils.getLogLevel() >= 2) {
                    MoneroUtils.log(2, "Sending path request with path='" + path + "', params=" + JsonUtils.serialize(params) + ", uri=" + this.uri);
                }
                if (this.printStackTrace) {
                    try {
                        throw new RuntimeException("Debug stack trace for path request with path '" + path + "' and params " + JsonUtils.serialize(params));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                long startTime = System.currentTimeMillis();
                resp = this.request((HttpUriRequest)post);
                MoneroRpcConnection.validateHttpResponse(resp);
                respMap = JsonUtils.toMap(MAPPER, EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8"));
                EntityUtils.consume((HttpEntity)resp.getEntity());
                if (MoneroUtils.getLogLevel() >= 3) {
                    String respStr = JsonUtils.serialize(respMap);
                    respStr = respStr.substring(0, Math.min(10000, respStr.length()));
                    MoneroUtils.log(3, "Received path response from path='" + path + "', response=" + respStr + ", uri=" + this.uri + " (" + (System.currentTimeMillis() - startTime) + " ms)");
                }
            }
            this.validateRpcResponse(respMap, path, params);
            object = respMap;
            return object;
        }
        catch (MoneroRpcError e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new MoneroError(e2);
        }
        finally {
            try {
                resp.close();
            }
            catch (Exception exception) {}
        }
    }

    public byte[] sendBinaryRequest(String path, Map<String, Object> params) {
        return this.sendBinaryRequest(path, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendBinaryRequest(String path, Map<String, Object> params, Long timeoutMs) {
        byte[] paramsBin = MoneroUtils.mapToBinary(params);
        CloseableHttpResponse resp = null;
        try {
            HttpPost post = new HttpPost(this.uri.toString() + "/" + path);
            post.setConfig(this.getRequestConfig(timeoutMs == null ? this.timeoutMs : timeoutMs));
            if (paramsBin != null) {
                ByteArrayEntity entity = new ByteArrayEntity(paramsBin, ContentType.DEFAULT_BINARY);
                post.setEntity((HttpEntity)entity);
            }
            MoneroRpcConnection moneroRpcConnection = this;
            synchronized (moneroRpcConnection) {
                try {
                    if (MoneroUtils.getLogLevel() >= 2) {
                        MoneroUtils.log(2, "Sending binary request with path='" + path + "', params=" + JsonUtils.serialize(params) + ", uri=" + this.uri);
                    }
                    if (this.printStackTrace) {
                        try {
                            throw new RuntimeException("Debug stack trace for binary request with path '" + path);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    resp = this.request((HttpUriRequest)post);
                    MoneroRpcConnection.validateHttpResponse(resp);
                    byte[] entity = EntityUtils.toByteArray((HttpEntity)resp.getEntity());
                    EntityUtils.consume((HttpEntity)resp.getEntity());
                    byte[] byArray = entity;
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (MoneroRpcError e1) {
                        throw e1;
                    }
                    catch (Exception e2) {
                        throw new MoneroError(e2);
                    }
                }
            }
        }
        finally {
            try {
                resp.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
    }

    public String toString() {
        return this.uri + " (uri=" + this.uri + ", username=" + this.username + ", password=" + (this.password == null ? "null" : "***") + ", priority=" + this.priority + ", timeoutMs=" + this.timeoutMs + ", isOnline=" + this.isOnline + ", isAuthenticated=" + this.isAuthenticated + ", zmqUri=" + this.zmqUri + ", proxyUri=" + this.proxyUri + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.proxyUri == null ? 0 : this.proxyUri.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.zmqUri == null ? 0 : this.zmqUri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroRpcConnection other = (MoneroRpcConnection)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.proxyUri == null ? other.proxyUri != null : !this.proxyUri.equals(other.proxyUri)) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.zmqUri == null ? other.zmqUri != null : !this.zmqUri.equals(other.zmqUri));
    }

    private static void validateHttpResponse(CloseableHttpResponse resp) {
        int code = resp.getCode();
        if (code < 200 || code > 299) {
            String content = null;
            try {
                content = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MoneroRpcError(code + " " + resp.getReasonPhrase() + (content == null || content.isEmpty() ? "" : ": " + content), code, null, null);
        }
    }

    private void validateRpcResponse(Map<String, Object> respMap, String method, Object params) {
        Map error = (Map)respMap.get("error");
        if (error == null) {
            return;
        }
        String errorMsg = (String)error.get("message");
        int code = ((BigInteger)error.get("code")).intValue();
        if ("".equals(errorMsg)) {
            errorMsg = "Received error response from RPC request with method '" + method + "' to " + this.uri;
        }
        throw new MoneroRpcError(errorMsg, code, method, params);
    }

    private RequestConfig getRequestConfig(Long timeoutMs) {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (timeoutMs != null) {
            builder.setConnectTimeout(Timeout.ofMilliseconds((long)timeoutMs));
            builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeoutMs));
            builder.setResponseTimeout(Timeout.ofMilliseconds((long)timeoutMs));
        }
        return builder.build();
    }

    private CloseableHttpResponse request(HttpUriRequest request) throws IOException, URISyntaxException {
        return this.proxyUri == null ? this.client.execute((ClassicHttpRequest)request) : this.requestWithProxy(request);
    }

    private CloseableHttpResponse requestWithProxy(HttpUriRequest request) throws IOException {
        Registry reg = RegistryBuilder.create().register("http", (Object)new SocksConnectionSocketFactory()).register("https", (Object)new SocksSSLConnectionSocketFactory(SSLContexts.createSystemDefault())).build();
        boolean isLocal = false;
        BasicHttpClientConnectionManager cm = isLocal ? new BasicHttpClientConnectionManager((Lookup)reg) : new BasicHttpClientConnectionManager((Lookup)reg, null, null, (DnsResolver)new FakeDnsResolver());
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        URI proxyParsed = MoneroUtils.parseUri(this.proxyUri);
        InetSocketAddress socksAddress = new InetSocketAddress(proxyParsed.getHost(), proxyParsed.getPort());
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("socks.address", (Object)socksAddress);
        CloseableHttpResponse httpResponse = closeableHttpClient.execute((ClassicHttpRequest)request, (HttpContext)context);
        return httpResponse;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true);
    }

    class SocksConnectionSocketFactory
    extends PlainConnectionSocketFactory {
        SocksConnectionSocketFactory() {
        }

        public Socket createSocket(HttpContext context) throws IOException {
            InetSocketAddress socksaddr = (InetSocketAddress)context.getAttribute("socks.address");
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }

        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            InetSocketAddress unresolvedRemote = InetSocketAddress.createUnresolved(host.getHostName(), remoteAddress.getPort());
            return super.connectSocket(connectTimeout, socket, host, unresolvedRemote, localAddress, context);
        }
    }

    private class SocksSSLConnectionSocketFactory
    extends SSLConnectionSocketFactory {
        public SocksSSLConnectionSocketFactory(SSLContext sslContext) {
            super(sslContext);
        }

        public Socket createSocket(HttpContext context) throws IOException {
            InetSocketAddress socksaddr = (InetSocketAddress)context.getAttribute("socks.address");
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }

        public Socket connectSocket(TimeValue connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            InetSocketAddress unresolvedRemote = InetSocketAddress.createUnresolved(host.getHostName(), remoteAddress.getPort());
            return super.connectSocket(connectTimeout, socket, host, unresolvedRemote, localAddress, context);
        }
    }

    class FakeDnsResolver
    implements DnsResolver {
        FakeDnsResolver() {
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            return new InetAddress[]{InetAddress.getByAddress(new byte[]{1, 1, 1, 1})};
        }

        public String resolveCanonicalHostname(String host) throws UnknownHostException {
            throw new UnsupportedOperationException("Unimplemented method 'resolveCanonicalHostname'");
        }
    }
}

