/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import common.types.JsonException;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    public static String serialize(Object obj) {
        return JsonUtils.serialize(DEFAULT_MAPPER, obj);
    }

    public static String serialize(ObjectMapper mapper, Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new JsonException("Error serializing object", e);
        }
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        return JsonUtils.deserialize(DEFAULT_MAPPER, json, clazz);
    }

    public static <T> T deserialize(ObjectMapper mapper, String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new JsonException("Error deserializing json to class", e);
        }
    }

    public static <T> T deserialize(String json, TypeReference<T> type) {
        return JsonUtils.deserialize(DEFAULT_MAPPER, json, type);
    }

    public static <T> T deserialize(ObjectMapper mapper, String json, TypeReference<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new JsonException("Error deserializing json to type " + type.getType(), e);
        }
    }

    public static Map<String, Object> toMap(String json) {
        return JsonUtils.deserialize(DEFAULT_MAPPER, json, new TypeReference<Map<String, Object>>(){});
    }

    public static Map<String, Object> toMap(ObjectMapper mapper, String json) {
        return JsonUtils.deserialize(mapper, json, new TypeReference<Map<String, Object>>(){});
    }

    public static Map<String, Object> toMap(Object obj) {
        return JsonUtils.toMap(DEFAULT_MAPPER, JsonUtils.serialize(obj));
    }

    public static Map<String, Object> toMap(ObjectMapper mapper, Object obj) {
        return JsonUtils.toMap(mapper, JsonUtils.serialize(obj));
    }

    static {
        DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

