/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class GenUtils {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static void assertTrue(boolean val) {
        if (!val) {
            throw new AssertionError((Object)"value asserted as true but was false");
        }
    }

    public static void assertTrue(String failMsg, boolean val) {
        if (!val) {
            throw new AssertionError((Object)failMsg);
        }
    }

    public static void assertFalse(boolean val) {
        if (val) {
            throw new AssertionError((Object)"value asserted as false but was true");
        }
    }

    public static void assertFalse(String failMsg, boolean val) {
        if (val) {
            throw new AssertionError((Object)failMsg);
        }
    }

    public static void assertNull(Object val) {
        if (val != null) {
            throw new AssertionError((Object)"value asserted as null but was not null");
        }
    }

    public static void assertNull(String failMsg, Object val) {
        if (val != null) {
            throw new AssertionError((Object)failMsg);
        }
    }

    public static void assertNotNull(Object val) {
        if (val == null) {
            throw new AssertionError((Object)"value asserted as not null but was null");
        }
    }

    public static void assertNotNull(String failMsg, Object val) {
        if (val == null) {
            throw new AssertionError((Object)failMsg);
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        GenUtils.assertFalse(expected + " != " + actual, expected == null || actual == null);
        GenUtils.assertTrue(expected + " != " + actual, expected.equals(actual));
    }

    public static void assertEquals(String failMsg, Object expected, Object actual) {
        try {
            GenUtils.assertEquals(expected, actual);
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)failMsg);
        }
    }

    public static void assertNotEquals(Object val1, Object val2) {
        GenUtils.assertFalse(val1 == null && val2 == null);
        GenUtils.assertTrue(val1 + " equals " + val2, val1 == null || val2 == null || !val1.equals(val2));
    }

    public static void assertNotEquals(String failMsg, Object val1, Object val2) {
        try {
            GenUtils.assertNotEquals(val1, val2);
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)failMsg);
        }
    }

    public static boolean isHex(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("-?[0-9a-fA-F]+");
    }

    public static <T> List<T> arrayToList(T[] arr) {
        ArrayList<T> list = new ArrayList<T>(arr.length);
        for (T elem : arr) {
            list.add(elem);
        }
        return list;
    }

    public static int[] listToIntArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int[] ints = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ints[i] = list.get(i);
        }
        return ints;
    }

    public static byte[] listToByteArray(List<Byte> list) {
        if (list == null) {
            return null;
        }
        byte[] bytes = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            bytes[i] = list.get(i);
        }
        return bytes;
    }

    public static String getIndent(int length) {
        String str = "";
        for (int i = 0; i < length; ++i) {
            str = str + "  ";
        }
        return str;
    }

    public static int[] subarray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] subarray = new int[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static <T> T reconcile(T val1, T val2) {
        return GenUtils.reconcile(val1, val2, null, null, null);
    }

    public static <T> T reconcile(T val1, T val2, Boolean resolveDefined, Boolean resolveTrue, Boolean resolveMax) {
        if (val1 == val2) {
            return val1;
        }
        Integer comparison = null;
        if (val1 instanceof BigInteger && val2 instanceof BigInteger && (comparison = Integer.valueOf(((BigInteger)val1).compareTo((BigInteger)val2))) == 0) {
            return val1;
        }
        if (val1 == null || val2 == null) {
            if (Boolean.FALSE.equals(resolveDefined)) {
                return null;
            }
            return val1 == null ? val2 : val1;
        }
        if (resolveTrue != null && Boolean.class.isInstance(val1) && Boolean.class.isInstance(val2)) {
            return (T)resolveTrue;
        }
        if (resolveMax != null) {
            if (val1 instanceof BigInteger && val2 instanceof BigInteger) {
                return resolveMax.booleanValue() ? (comparison < 0 ? val2 : val1) : (comparison < 0 ? val1 : val2);
            }
            if (val1 instanceof Integer && val2 instanceof Integer) {
                return (T)Integer.valueOf(resolveMax != false ? Math.max((Integer)val1, (Integer)val2) : Math.min((Integer)val1, (Integer)val2));
            }
            if (val1 instanceof Long && val2 instanceof Long) {
                return (T)Long.valueOf(resolveMax != false ? Math.max((Long)val1, (Long)val2) : Math.min((Long)val1, (Long)val2));
            }
            throw new RuntimeException("Need to resolve primitives and object versions");
        }
        GenUtils.assertEquals("Cannot reconcile values " + val1 + " and " + val2 + " with config: [" + resolveDefined + ", " + resolveTrue + ", " + resolveMax + "]", val1, val2);
        return val1;
    }

    public static int[] reconcileIntArrays(int[] arr1, int[] arr2) {
        if (arr1 == arr2) {
            return arr1;
        }
        if (arr1 == null || arr2 == null) {
            return arr1 == null ? arr2 : arr1;
        }
        GenUtils.assertTrue("Cannot reconcile arrays", Arrays.equals(arr1, arr2));
        return arr1;
    }

    public static byte[] reconcileByteArrays(byte[] arr1, byte[] arr2) {
        if (arr1 == arr2) {
            return arr1;
        }
        if (arr1 == null || arr2 == null) {
            return arr1 == null ? arr2 : arr1;
        }
        GenUtils.assertTrue("Cannot reconcile arrays", Arrays.equals(arr1, arr2));
        return arr1;
    }

    public static String kvLine(Object key, Object value, int indent) {
        return GenUtils.kvLine(key, value, indent, true, true);
    }

    public static String kvLine(Object key, Object value, int indent, boolean newline, boolean ignoreUndefined) {
        if (value == null && ignoreUndefined) {
            return "";
        }
        return GenUtils.getIndent(indent) + key + ": " + value + (newline ? Character.valueOf('\n') : "");
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static void waitFor(long durationMs) {
        try {
            TimeUnit.MILLISECONDS.sleep(durationMs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeTasks(Collection<Runnable> tasks) {
        GenUtils.executeTasks(tasks, tasks.size());
    }

    public static void executeTasks(Collection<Runnable> tasks, int maxConcurrency) {
        if (tasks.isEmpty()) {
            return;
        }
        ExecutorService pool = Executors.newFixedThreadPool(maxConcurrency);
        ArrayList futures = new ArrayList();
        for (Runnable runnable : tasks) {
            futures.add(pool.submit(runnable));
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            throw new RuntimeException(e);
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> executeTasks(List<Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executeTasks(tasks, tasks.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeTasks(List<Callable<T>> tasks, int maxConcurrency) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(maxConcurrency);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        ArrayList results = new ArrayList();
        try {
            for (Callable<T> callable : tasks) {
                futures.add(executor.submit(callable));
            }
            for (Future future : futures) {
                results.add(future.get());
            }
        }
        finally {
            executor.shutdown();
        }
        return results;
    }
}

