/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.column;

import haveno.cli.table.column.Column;
import haveno.cli.table.column.StringColumn;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class ZippedStringColumns {
    private final String name;
    private final Column.JUSTIFICATION justification;
    private final String delimiter;
    private final StringColumn[] columns;

    public ZippedStringColumns(String name, Column.JUSTIFICATION justification, String delimiter, StringColumn ... columns) {
        this.name = name;
        this.justification = justification;
        this.delimiter = delimiter;
        this.columns = columns;
        this.validateColumnData();
    }

    public StringColumn asStringColumn(DUPLICATION_MODE duplicationMode) {
        StringColumn stringColumn = new StringColumn(this.name, this.justification);
        this.buildRows(stringColumn, duplicationMode);
        stringColumn.setName(stringColumn.toJustifiedString(this.name));
        return stringColumn;
    }

    private void buildRows(StringColumn stringColumn, DUPLICATION_MODE duplicationMode) {
        IntStream.range(0, this.columns[0].getRows().size()).forEach(rowIndex -> {
            String row = this.buildRow(rowIndex, duplicationMode);
            stringColumn.addRow(row);
        });
        this.formatRows(stringColumn);
    }

    private String buildRow(int rowIndex, DUPLICATION_MODE duplicationMode) {
        StringBuilder rowBuilder = new StringBuilder();
        ArrayList processedValues = duplicationMode.equals((Object)DUPLICATION_MODE.EXCLUDE_DUPLICATES) ? new ArrayList() : null;
        IntStream.range(0, this.columns.length).forEachOrdered(colIndex -> {
            String value = this.columns[colIndex].getRows().get(rowIndex);
            if (duplicationMode.equals((Object)DUPLICATION_MODE.INCLUDE_DUPLICATES)) {
                if (rowBuilder.length() > 0) {
                    rowBuilder.append(this.delimiter);
                }
                rowBuilder.append(value);
            } else if (!processedValues.contains(value)) {
                if (rowBuilder.length() > 0) {
                    rowBuilder.append(this.delimiter);
                }
                rowBuilder.append(value);
                processedValues.add(value);
            }
        });
        return rowBuilder.toString();
    }

    private void formatRows(StringColumn stringColumn) {
        IntStream.range(0, stringColumn.getRows().size()).forEach(rowIndex -> {
            String unjustified = stringColumn.getRow(rowIndex);
            String justified = stringColumn.toJustifiedString(unjustified);
            stringColumn.updateRow(rowIndex, justified);
        });
    }

    private void validateColumnData() {
        if (this.columns.length == 0) {
            throw new IllegalStateException("cannot zip columns because they do not have any data");
        }
        StringColumn firstColumn = this.columns[0];
        if (firstColumn.getRows().isEmpty()) {
            throw new IllegalStateException("1st column has no data");
        }
        IntStream.range(1, this.columns.length).forEach(colIndex -> {
            if (this.columns[colIndex].getRows().size() != firstColumn.getRows().size()) {
                throw new IllegalStateException("columns do not have same number of rows");
            }
        });
    }

    public static enum DUPLICATION_MODE {
        EXCLUDE_DUPLICATES,
        INCLUDE_DUPLICATES;

    }
}

