/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.column;

import haveno.cli.table.column.AbstractColumn;
import haveno.cli.table.column.Column;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class StringColumn
extends AbstractColumn<StringColumn, String> {
    private final List<String> rows = new ArrayList<String>();
    private final Predicate<String> isNewMaxWidth = s -> s != null && !s.isEmpty() && s.length() > this.maxWidth;

    public StringColumn(String name) {
        this(name, Column.JUSTIFICATION.LEFT);
    }

    public StringColumn(String name, Column.JUSTIFICATION justification) {
        super(name, justification);
        this.maxWidth = name.length();
    }

    @Override
    public void addRow(String value) {
        this.rows.add(value);
        if (this.isNewMaxWidth.test(value)) {
            this.maxWidth = value.length();
        }
    }

    @Override
    public List<String> getRows() {
        return this.rows;
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public String getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public void updateRow(int rowIndex, String newValue) {
        this.rows.set(rowIndex, newValue);
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return this.getRow(rowIndex);
    }

    @Override
    public StringColumn asStringColumn() {
        return this;
    }

    public StringColumn justify() {
        if (this.justification.equals((Object)Column.JUSTIFICATION.RIGHT)) {
            IntStream.range(0, this.getRows().size()).forEach(rowIndex -> {
                String unjustified = this.getRow(rowIndex);
                String justified = this.toJustifiedString(unjustified);
                this.updateRow(rowIndex, justified);
            });
        }
        return this;
    }
}

