/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.column;

import haveno.cli.table.column.Column;
import haveno.cli.table.column.LongColumn;
import haveno.cli.table.column.StringColumn;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.stream.IntStream;

public class CryptoVolumeColumn
extends LongColumn {
    private final DISPLAY_MODE displayMode;
    private final BiFunction<Long, DISPLAY_MODE, String> toFormattedString = (value, displayMode) -> {
        switch (displayMode.ordinal()) {
            case 0: {
                return value > 0L ? new BigDecimal((long)value).movePointLeft(8).toString() : "";
            }
            case 1: {
                return value > 0L ? new BigDecimal((long)value).movePointLeft(2).toString() : "";
            }
        }
        throw new IllegalStateException("invalid display mode: " + String.valueOf(displayMode));
    };

    public CryptoVolumeColumn(String name, DISPLAY_MODE displayMode) {
        this(name, Column.JUSTIFICATION.RIGHT, displayMode);
    }

    public CryptoVolumeColumn(String name, Column.JUSTIFICATION justification, DISPLAY_MODE displayMode2) {
        super(name, justification);
        this.displayMode = displayMode2;
    }

    @Override
    public void addRow(Long value) {
        this.rows.add(value);
        String s = this.toFormattedString.apply(value, this.displayMode);
        this.stringColumn.addRow(s);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return this.toFormattedString.apply(this.getRow(rowIndex), this.displayMode);
    }

    @Override
    public StringColumn asStringColumn() {
        IntStream.range(0, this.stringColumn.getRows().size()).forEach(rowIndex -> {
            String unjustified = this.stringColumn.getRow(rowIndex);
            String justified = this.stringColumn.toJustifiedString(unjustified);
            this.stringColumn.updateRow(rowIndex, justified);
        });
        return this.stringColumn;
    }

    public static enum DISPLAY_MODE {
        CRYPTO_VOLUME,
        BSQ_VOLUME;

    }
}

