/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.column;

import com.google.common.base.Strings;
import haveno.cli.CurrencyFormat;
import haveno.cli.table.column.SatoshiColumn;
import haveno.cli.table.column.StringColumn;
import java.util.Comparator;
import java.util.stream.IntStream;

public class BtcColumn
extends SatoshiColumn {
    public BtcColumn(String name) {
        super(name);
    }

    @Override
    public void addRow(Long value) {
        this.rows.add(value);
        String s = CurrencyFormat.formatBtc(value);
        this.stringColumn.addRow(s);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return CurrencyFormat.formatBtc(this.getRow(rowIndex));
    }

    @Override
    public StringColumn asStringColumn() {
        int maxColumnValueWidth = this.stringColumn.getRows().stream().max(Comparator.comparingInt(String::length)).get().length();
        IntStream.range(0, this.stringColumn.getRows().size()).forEach(rowIndex -> {
            String btcString = this.stringColumn.getRow(rowIndex);
            if (btcString.length() < maxColumnValueWidth) {
                String paddedBtcString = Strings.padEnd((String)btcString, (int)maxColumnValueWidth, (char)'0');
                this.stringColumn.updateRow(rowIndex, paddedBtcString);
            }
        });
        return this.stringColumn.justify();
    }
}

