/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.column;

import haveno.cli.table.column.AbstractColumn;
import haveno.cli.table.column.Column;
import haveno.cli.table.column.StringColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class BooleanColumn
extends AbstractColumn<BooleanColumn, Boolean> {
    private static final String DEFAULT_TRUE_AS_STRING = "YES";
    private static final String DEFAULT_FALSE_AS_STRING = "NO";
    private final List<Boolean> rows = new ArrayList<Boolean>();
    private final Predicate<String> isNewMaxWidth = s -> s != null && !s.isEmpty() && s.length() > this.maxWidth;
    private final String trueAsString;
    private final String falseAsString;

    public BooleanColumn(String name) {
        this(name, Column.JUSTIFICATION.LEFT, DEFAULT_TRUE_AS_STRING, DEFAULT_FALSE_AS_STRING);
    }

    public BooleanColumn(String name, Column.JUSTIFICATION justification) {
        this(name, justification, DEFAULT_TRUE_AS_STRING, DEFAULT_FALSE_AS_STRING);
    }

    public BooleanColumn(String name, String trueAsString, String falseAsString) {
        this(name, Column.JUSTIFICATION.LEFT, trueAsString, falseAsString);
    }

    public BooleanColumn(String name, Column.JUSTIFICATION justification, String trueAsString, String falseAsString) {
        super(name, justification);
        this.trueAsString = trueAsString;
        this.falseAsString = falseAsString;
        this.maxWidth = name.length();
    }

    @Override
    public void addRow(Boolean value) {
        this.rows.add(value);
        String s = this.asString(value);
        this.stringColumn.addRow(s);
        if (this.isNewMaxWidth.test(s)) {
            this.maxWidth = s.length();
        }
    }

    @Override
    public List<Boolean> getRows() {
        return this.rows;
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public Boolean getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public void updateRow(int rowIndex, Boolean newValue) {
        this.rows.set(rowIndex, newValue);
    }

    @Override
    public String getRowAsFormattedString(int rowIndex) {
        return this.getRow(rowIndex) != false ? this.trueAsString : this.falseAsString;
    }

    @Override
    public StringColumn asStringColumn() {
        IntStream.range(0, this.stringColumn.getRows().size()).forEach(rowIndex -> {
            String unjustified = this.stringColumn.getRow(rowIndex);
            String justified = this.stringColumn.toJustifiedString(unjustified);
            this.stringColumn.updateRow(rowIndex, justified);
        });
        return this.stringColumn;
    }

    private String asString(boolean value) {
        return value ? this.trueAsString : this.falseAsString;
    }
}

