/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.column;

import com.google.common.base.Strings;
import haveno.cli.table.column.Column;
import haveno.cli.table.column.StringColumn;

abstract class AbstractColumn<C extends Column<T>, T>
implements Column<T> {
    protected final StringColumn stringColumn;
    protected String name;
    protected final Column.JUSTIFICATION justification;
    protected int maxWidth;

    public AbstractColumn(String name, Column.JUSTIFICATION justification) {
        this.name = name;
        this.justification = justification;
        this.stringColumn = this instanceof StringColumn ? null : new StringColumn(name, justification);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getWidth() {
        return this.maxWidth;
    }

    @Override
    public Column.JUSTIFICATION getJustification() {
        return this.justification;
    }

    @Override
    public Column<T> justify() {
        if (this instanceof StringColumn && this.justification.equals((Object)Column.JUSTIFICATION.RIGHT)) {
            return this.justify();
        }
        return this;
    }

    protected final String toJustifiedString(String s) {
        switch (this.justification) {
            case LEFT: {
                return Strings.padEnd((String)s, (int)this.maxWidth, (char)' ');
            }
            case RIGHT: {
                return Strings.padStart((String)s, (int)this.maxWidth, (char)' ');
            }
        }
        return s;
    }
}

