/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.builder.TableType;
import haveno.cli.table.column.BooleanColumn;
import haveno.cli.table.column.BtcColumn;
import haveno.cli.table.column.Column;
import haveno.cli.table.column.CryptoVolumeColumn;
import haveno.cli.table.column.DoubleColumn;
import haveno.cli.table.column.Iso8601DateTimeColumn;
import haveno.cli.table.column.MixedTradeFeeColumn;
import haveno.cli.table.column.SatoshiColumn;
import haveno.cli.table.column.StringColumn;
import haveno.proto.grpc.ContractInfo;
import haveno.proto.grpc.OfferInfo;
import haveno.proto.grpc.TradeInfo;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TradeTableColumnSupplier {
    private static final Logger log = LoggerFactory.getLogger(TradeTableColumnSupplier.class);
    private final TableType tableType;
    private final List<TradeInfo> trades;
    private final Supplier<Boolean> isTradeDetailTblBuilder = () -> this.getTableType().equals((Object)TableType.TRADE_DETAIL_TBL);
    private final Supplier<Boolean> isOpenTradeTblBuilder = () -> this.getTableType().equals((Object)TableType.OPEN_TRADES_TBL);
    private final Supplier<Boolean> isClosedTradeTblBuilder = () -> this.getTableType().equals((Object)TableType.CLOSED_TRADES_TBL);
    private final Supplier<Boolean> isFailedTradeTblBuilder = () -> this.getTableType().equals((Object)TableType.FAILED_TRADES_TBL);
    private final Supplier<TradeInfo> firstRow = () -> this.getTrades().get(0);
    private final Predicate<OfferInfo> isTraditionalOffer = o -> o.getBaseCurrencyCode().equals("XMR");
    private final Predicate<TradeInfo> isTraditionalTrade = t -> this.isTraditionalOffer.test(t.getOffer());
    private final Predicate<TradeInfo> isTaker = t -> t.getRole().toLowerCase().contains("taker");
    final Supplier<StringColumn> tradeIdColumn = () -> this.isTradeDetailTblBuilder.get() != false ? new StringColumn("ID") : new StringColumn("Trade ID");
    final Supplier<Iso8601DateTimeColumn> createDateColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new Iso8601DateTimeColumn("Date/Time (UTC)");
    final Supplier<StringColumn> marketColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Market");
    private final Function<TradeInfo, Column<String>> toDetailedPriceColumn = t -> {
        String colHeader = this.isTraditionalTrade.test((TradeInfo)t) ? String.format("Price in %-3s for 1 BTC", t.getOffer().getCounterCurrencyCode()) : String.format("Price in BTC for 1 %-3s", t.getOffer().getBaseCurrencyCode());
        return new StringColumn(colHeader, Column.JUSTIFICATION.RIGHT);
    };
    final Supplier<Column<String>> priceColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toDetailedPriceColumn.apply(this.firstRow.get()) : new StringColumn("Price", Column.JUSTIFICATION.RIGHT);
    final Supplier<Column<String>> priceDeviationColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Deviation", Column.JUSTIFICATION.RIGHT);
    final Supplier<StringColumn> currencyColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Currency");
    private final Function<TradeInfo, Column<Long>> toDetailedAmountColumn = t -> {
        String headerCurrencyCode = t.getOffer().getBaseCurrencyCode();
        String colHeader = String.format("Amount(%-3s)", headerCurrencyCode);
        CryptoVolumeColumn.DISPLAY_MODE displayMode = headerCurrencyCode.equals("BSQ") ? CryptoVolumeColumn.DISPLAY_MODE.BSQ_VOLUME : CryptoVolumeColumn.DISPLAY_MODE.CRYPTO_VOLUME;
        return this.isTraditionalTrade.test((TradeInfo)t) ? new SatoshiColumn(colHeader) : new CryptoVolumeColumn(colHeader, displayMode);
    };
    final Supplier<Column<Long>> amountColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toDetailedAmountColumn.apply(this.firstRow.get()) : new BtcColumn("Amount in BTC");
    final Supplier<StringColumn> mixedAmountColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Amount", Column.JUSTIFICATION.RIGHT);
    final Supplier<Column<Long>> minerTxFeeColumn = () -> this.isTradeDetailTblBuilder.get() != false || this.isClosedTradeTblBuilder.get() != false ? new SatoshiColumn("Tx Fee (BTC)") : null;
    final Supplier<MixedTradeFeeColumn> mixedTradeFeeColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new MixedTradeFeeColumn("Trade Fee");
    final Supplier<StringColumn> paymentMethodColumn = () -> this.isTradeDetailTblBuilder.get() != false || this.isClosedTradeTblBuilder.get() != false ? null : new StringColumn("Payment Method", Column.JUSTIFICATION.LEFT);
    final Supplier<StringColumn> roleColumn = () -> this.isTradeDetailTblBuilder.get() != false || this.isOpenTradeTblBuilder.get() != false || this.isFailedTradeTblBuilder.get() != false ? new StringColumn("My Role") : null;
    final Function<String, Column<Double>> toSecurityDepositColumn = name -> this.isClosedTradeTblBuilder.get() != false ? new DoubleColumn((String)name) : null;
    final Supplier<StringColumn> offerTypeColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Offer Type");
    final Supplier<StringColumn> statusDescriptionColumn = () -> this.isTradeDetailTblBuilder.get() != false ? null : new StringColumn("Status");
    private final Function<String, Column<Boolean>> toBooleanColumn = BooleanColumn::new;
    final Supplier<Column<Boolean>> depositPublishedColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Deposit Published") : null;
    final Supplier<Column<Boolean>> depositConfirmedColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Deposit Confirmed") : null;
    final Supplier<Column<Boolean>> payoutPublishedColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Payout Published") : null;
    final Supplier<Column<Boolean>> fundsWithdrawnColumn = () -> this.isTradeDetailTblBuilder.get() != false ? this.toBooleanColumn.apply("Withdrawn") : null;
    final Supplier<Column<Long>> havenoTradeDetailFeeColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            TradeInfo t = this.firstRow.get();
            String headerCurrencyCode = "XMR";
            String colHeader = this.isTaker.test(t) ? String.format("Taker Fee(%-3s)", headerCurrencyCode) : String.format("Maker Fee(%-3s)", headerCurrencyCode);
            return new SatoshiColumn(colHeader, false);
        }
        return null;
    };
    final Function<TradeInfo, String> toPaymentCurrencyCode = t -> this.isTraditionalTrade.test((TradeInfo)t) ? t.getOffer().getCounterCurrencyCode() : t.getOffer().getBaseCurrencyCode();
    final Supplier<Column<Boolean>> paymentSentMessageSentColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            String headerCurrencyCode = this.toPaymentCurrencyCode.apply(this.firstRow.get());
            String colHeader = String.format("%-3s Sent", headerCurrencyCode);
            return new BooleanColumn(colHeader);
        }
        return null;
    };
    final Supplier<Column<Boolean>> paymentReceivedMessageSentColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            String headerCurrencyCode = this.toPaymentCurrencyCode.apply(this.firstRow.get());
            String colHeader = String.format("%-3s Received", headerCurrencyCode);
            return new BooleanColumn(colHeader);
        }
        return null;
    };
    final Supplier<Column<String>> tradeCostColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            TradeInfo t = this.firstRow.get();
            String headerCurrencyCode = t.getOffer().getCounterCurrencyCode();
            String colHeader = String.format("Buyer Cost(%-3s)", headerCurrencyCode);
            return new StringColumn(colHeader, Column.JUSTIFICATION.RIGHT);
        }
        return null;
    };
    final Predicate<TradeInfo> showCryptoBuyerAddress = t -> {
        if (this.isTraditionalTrade.test((TradeInfo)t)) {
            return false;
        }
        ContractInfo contract = t.getContract();
        boolean isBuyerMakerAndSellerTaker = contract.getIsBuyerMakerAndSellerTaker();
        if (this.isTaker.test((TradeInfo)t)) {
            return !isBuyerMakerAndSellerTaker;
        }
        return isBuyerMakerAndSellerTaker;
    };
    @Nullable
    final Supplier<Column<String>> cryptoReceiveAddressColumn = () -> {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            TradeInfo t = this.firstRow.get();
            if (this.showCryptoBuyerAddress.test(t)) {
                String headerCurrencyCode = this.toPaymentCurrencyCode.apply(t);
                String colHeader = String.format("%-3s Buyer Address", headerCurrencyCode);
                return new StringColumn(colHeader);
            }
            return null;
        }
        return null;
    };

    public TradeTableColumnSupplier(TableType tableType, List<TradeInfo> trades) {
        this.tableType = tableType;
        this.trades = trades;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public List<TradeInfo> getTrades() {
        return this.trades;
    }
}

