/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.Table;
import haveno.cli.table.builder.AbstractTradeListBuilder;
import haveno.cli.table.builder.TableType;
import haveno.cli.table.column.Column;
import haveno.proto.grpc.TradeInfo;
import java.util.ArrayList;
import java.util.List;

class TradeDetailTableBuilder
extends AbstractTradeListBuilder {
    TradeDetailTableBuilder(List<?> protos) {
        super(TableType.TRADE_DETAIL_TBL, protos);
    }

    @Override
    public Table build() {
        TradeInfo trade = (TradeInfo)this.trades.get(0);
        this.populateColumns(trade);
        List<Column<?>> columns = this.defineColumnList(trade);
        return new Table(columns.toArray(new Column[0]));
    }

    private void populateColumns(TradeInfo trade) {
        this.populateHavenoV1TradeColumns(trade);
    }

    private void populateHavenoV1TradeColumns(TradeInfo trade) {
        this.colTradeId.addRow(trade.getShortId());
        this.colRole.addRow(trade.getRole());
        this.colPrice.addRow(trade.getPrice());
        this.colAmount.addRow((Long)this.toTradeAmount.apply(trade));
        this.colHavenoTradeFee.addRow((Long)this.toMyMakerOrTakerFee.apply(trade));
        this.colIsDepositPublished.addRow(trade.getIsDepositsPublished());
        this.colIsDepositConfirmed.addRow(trade.getIsDepositsUnlocked());
        this.colTradeCost.addRow((String)this.toTradeVolumeAsString.apply(trade));
        this.colIsPaymentSentMessageSent.addRow(trade.getIsPaymentSent());
        this.colIsPaymentReceivedMessageSent.addRow(trade.getIsPaymentReceived());
        this.colIsPayoutPublished.addRow(trade.getIsPayoutPublished());
        this.colIsCompleted.addRow(trade.getIsCompleted());
        if (this.colCryptoReceiveAddressColumn != null) {
            this.colCryptoReceiveAddressColumn.addRow((String)this.toCryptoReceiveAddress.apply(trade));
        }
    }

    private List<Column<?>> defineColumnList(TradeInfo trade) {
        return this.getHavenoV1TradeColumnList();
    }

    private List<Column<?>> getHavenoV1TradeColumnList() {
        ArrayList columns = new ArrayList<Column<?>>(){
            {
                this.add(TradeDetailTableBuilder.this.colTradeId);
                this.add(TradeDetailTableBuilder.this.colRole);
                this.add(TradeDetailTableBuilder.this.colPrice.justify());
                this.add(TradeDetailTableBuilder.this.colAmount.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colHavenoTradeFee.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsDepositPublished.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsDepositConfirmed.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colTradeCost.justify());
                this.add(TradeDetailTableBuilder.this.colIsPaymentSentMessageSent.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsPaymentReceivedMessageSent.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsPayoutPublished.asStringColumn());
                this.add(TradeDetailTableBuilder.this.colIsCompleted.asStringColumn());
            }
        };
        if (this.colCryptoReceiveAddressColumn != null) {
            columns.add(this.colCryptoReceiveAddressColumn);
        }
        return columns;
    }
}

