/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.Table;
import haveno.cli.table.builder.AbstractTableBuilder;
import haveno.cli.table.builder.AddressBalanceTableBuilder;
import haveno.cli.table.builder.BtcBalanceTableBuilder;
import haveno.cli.table.builder.ClosedTradeTableBuilder;
import haveno.cli.table.builder.FailedTradeTableBuilder;
import haveno.cli.table.builder.OfferTableBuilder;
import haveno.cli.table.builder.OpenTradeTableBuilder;
import haveno.cli.table.builder.PaymentAccountTableBuilder;
import haveno.cli.table.builder.TableType;
import haveno.cli.table.builder.TradeDetailTableBuilder;
import haveno.cli.table.builder.TransactionTableBuilder;
import java.util.Collections;
import java.util.List;

public class TableBuilder
extends AbstractTableBuilder {
    public TableBuilder(TableType tableType, Object proto) {
        this(tableType, Collections.singletonList(proto));
    }

    public TableBuilder(TableType tableType, List<?> protos) {
        super(tableType, protos);
    }

    @Override
    public Table build() {
        switch (this.tableType) {
            case ADDRESS_BALANCE_TBL: {
                return new AddressBalanceTableBuilder(this.protos).build();
            }
            case BTC_BALANCE_TBL: {
                return new BtcBalanceTableBuilder(this.protos).build();
            }
            case CLOSED_TRADES_TBL: {
                return new ClosedTradeTableBuilder(this.protos).build();
            }
            case FAILED_TRADES_TBL: {
                return new FailedTradeTableBuilder(this.protos).build();
            }
            case OFFER_TBL: {
                return new OfferTableBuilder(this.protos).build();
            }
            case OPEN_TRADES_TBL: {
                return new OpenTradeTableBuilder(this.protos).build();
            }
            case PAYMENT_ACCOUNT_TBL: {
                return new PaymentAccountTableBuilder(this.protos).build();
            }
            case TRADE_DETAIL_TBL: {
                return new TradeDetailTableBuilder(this.protos).build();
            }
            case TRANSACTION_TBL: {
                return new TransactionTableBuilder(this.protos).build();
            }
        }
        throw new IllegalArgumentException("invalid cli table type " + this.tableType.name());
    }
}

