/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.Table;
import haveno.cli.table.builder.AbstractTableBuilder;
import haveno.cli.table.builder.TableType;
import haveno.cli.table.column.Column;
import haveno.cli.table.column.StringColumn;
import java.util.List;
import java.util.stream.Collectors;
import protobuf.PaymentAccount;

class PaymentAccountTableBuilder
extends AbstractTableBuilder {
    private final Column<String> colName = new StringColumn("Name");
    private final Column<String> colCurrency = new StringColumn("Currency");
    private final Column<String> colPaymentMethod = new StringColumn("Payment Method");
    private final Column<String> colId = new StringColumn("ID");

    PaymentAccountTableBuilder(List<?> protos) {
        super(TableType.PAYMENT_ACCOUNT_TBL, protos);
    }

    @Override
    public Table build() {
        List paymentAccounts = this.protos.stream().map(a -> (PaymentAccount)a).collect(Collectors.toList());
        paymentAccounts.stream().forEachOrdered(a -> {
            this.colName.addRow(a.getAccountName());
            this.colCurrency.addRow(a.getSelectedTradeCurrency().getCode());
            this.colPaymentMethod.addRow(a.getPaymentMethod().getId());
            this.colId.addRow(a.getId());
        });
        return new Table(this.colName, this.colCurrency, this.colPaymentMethod, this.colId);
    }
}

