/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.Table;
import haveno.cli.table.builder.AbstractTradeListBuilder;
import haveno.cli.table.builder.TableType;
import java.util.List;

class FailedTradeTableBuilder
extends AbstractTradeListBuilder {
    FailedTradeTableBuilder(List<?> protos) {
        super(TableType.FAILED_TRADES_TBL, protos);
    }

    @Override
    public Table build() {
        this.populateColumns();
        return new Table(this.colTradeId, this.colCreateDate.asStringColumn(), this.colMarket, this.colPrice.justify(), this.colAmount.asStringColumn(), this.colMixedAmount.justify(), this.colCurrency, this.colOfferType, this.colRole, this.colClosingStatus);
    }

    private void populateColumns() {
        this.trades.forEach(t -> {
            this.colTradeId.addRow(t.getTradeId());
            this.colCreateDate.addRow(t.getDate());
            this.colMarket.addRow((String)this.toMarket.apply(t));
            this.colPrice.addRow(t.getPrice());
            this.colAmount.addRow(t.getAmount());
            this.colMixedAmount.addRow(t.getTradeVolume());
            this.colCurrency.addRow((String)this.toPaymentCurrencyCode.apply(t));
            this.colOfferType.addRow((String)this.toOfferType.apply(t));
            this.colRole.addRow(t.getRole());
            this.colClosingStatus.addRow("Failed");
        });
    }
}

