/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.Table;
import haveno.cli.table.builder.AbstractTradeListBuilder;
import haveno.cli.table.builder.TableType;
import java.util.List;

class ClosedTradeTableBuilder
extends AbstractTradeListBuilder {
    ClosedTradeTableBuilder(List<?> protos) {
        super(TableType.CLOSED_TRADES_TBL, protos);
    }

    @Override
    public Table build() {
        this.populateColumns();
        return new Table(this.colTradeId, this.colCreateDate.asStringColumn(), this.colMarket, this.colPrice.justify(), this.colPriceDeviation.justify(), this.colAmount.asStringColumn(), this.colMixedAmount.justify(), this.colCurrency, this.colMixedTradeFee.asStringColumn(), this.colBuyerDeposit.asStringColumn(), this.colSellerDeposit.asStringColumn(), this.colOfferType, this.colClosingStatus);
    }

    private void populateColumns() {
        this.trades.forEach(t -> {
            this.colTradeId.addRow(t.getTradeId());
            this.colCreateDate.addRow(t.getDate());
            this.colMarket.addRow((String)this.toMarket.apply(t));
            this.colPrice.addRow(t.getPrice());
            this.colPriceDeviation.addRow((String)this.toPriceDeviation.apply(t));
            this.colAmount.addRow(t.getAmount());
            this.colMixedAmount.addRow(t.getTradeVolume());
            this.colCurrency.addRow((String)this.toPaymentCurrencyCode.apply(t));
            this.colMixedTradeFee.addRow((Long)this.toTradeFeeBtc.apply(t), false);
            this.colBuyerDeposit.addRow(t.getOffer().getBuyerSecurityDepositPct());
            this.colSellerDeposit.addRow(t.getOffer().getSellerSecurityDepositPct());
            this.colOfferType.addRow((String)this.toOfferType.apply(t));
        });
    }
}

