/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.table.Table;
import haveno.cli.table.builder.AbstractTableBuilder;
import haveno.cli.table.builder.TableType;
import haveno.cli.table.column.BooleanColumn;
import haveno.cli.table.column.Column;
import haveno.cli.table.column.LongColumn;
import haveno.cli.table.column.SatoshiColumn;
import haveno.cli.table.column.StringColumn;
import haveno.proto.grpc.AddressBalanceInfo;
import java.util.List;
import java.util.stream.Collectors;

class AddressBalanceTableBuilder
extends AbstractTableBuilder {
    private final Column<String> colAddress = new StringColumn(String.format("%-3s Address", "BTC"));
    private final Column<Long> colAvailableBalance = new SatoshiColumn("Available Balance");
    private final Column<Long> colConfirmations = new LongColumn("Confirmations");
    private final Column<Boolean> colIsUsed = new BooleanColumn("Is Used");

    AddressBalanceTableBuilder(List<?> protos) {
        super(TableType.ADDRESS_BALANCE_TBL, protos);
    }

    @Override
    public Table build() {
        List addresses = this.protos.stream().map(a -> (AddressBalanceInfo)a).collect(Collectors.toList());
        addresses.stream().forEachOrdered(a -> {
            this.colAddress.addRow(a.getAddress());
            this.colAvailableBalance.addRow(a.getBalance());
            this.colConfirmations.addRow(a.getNumConfirmations());
            this.colIsUsed.addRow(!a.getIsAddressUnused());
        });
        return new Table(this.colAddress, this.colAvailableBalance.asStringColumn(), this.colConfirmations.asStringColumn(), this.colIsUsed.asStringColumn());
    }
}

