/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table.builder;

import haveno.cli.CurrencyFormat;
import haveno.cli.table.builder.AbstractTableBuilder;
import haveno.cli.table.builder.TableType;
import haveno.cli.table.builder.TradeTableColumnSupplier;
import haveno.cli.table.column.Column;
import haveno.cli.table.column.MixedTradeFeeColumn;
import haveno.proto.grpc.ContractInfo;
import haveno.proto.grpc.TradeInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import protobuf.OfferDirection;

abstract class AbstractTradeListBuilder
extends AbstractTableBuilder {
    protected final List<TradeInfo> trades;
    protected final TradeTableColumnSupplier colSupplier;
    protected final Column<String> colTradeId;
    @Nullable
    protected final Column<Long> colCreateDate;
    @Nullable
    protected final Column<String> colMarket;
    protected final Column<String> colPrice;
    @Nullable
    protected final Column<String> colPriceDeviation;
    @Nullable
    protected final Column<String> colCurrency;
    @Nullable
    protected final Column<Long> colAmount;
    @Nullable
    protected final Column<String> colMixedAmount;
    @Nullable
    protected final MixedTradeFeeColumn colMixedTradeFee;
    @Nullable
    protected final Column<Double> colBuyerDeposit;
    @Nullable
    protected final Column<Double> colSellerDeposit;
    @Nullable
    protected final Column<String> colPaymentMethod;
    @Nullable
    protected final Column<String> colRole;
    @Nullable
    protected final Column<String> colOfferType;
    @Nullable
    protected final Column<String> colClosingStatus;
    @Nullable
    protected final Column<Boolean> colIsDepositPublished;
    @Nullable
    protected final Column<Boolean> colIsDepositConfirmed;
    @Nullable
    protected final Column<Boolean> colIsPayoutPublished;
    @Nullable
    protected final Column<Boolean> colIsCompleted;
    @Nullable
    protected final Column<Long> colHavenoTradeFee;
    @Nullable
    protected final Column<String> colTradeCost;
    @Nullable
    protected final Column<Boolean> colIsPaymentSentMessageSent;
    @Nullable
    protected final Column<Boolean> colIsPaymentReceivedMessageSent;
    @Nullable
    protected final Column<String> colCryptoReceiveAddressColumn;
    private final Supplier<Boolean> isTradeDetailTblBuilder = () -> this.tableType.equals((Object)TableType.TRADE_DETAIL_TBL);
    protected final Predicate<TradeInfo> isTraditionalTrade = t -> this.isTraditionalOffer.test(t.getOffer());
    protected final Predicate<TradeInfo> isMyOffer = t -> t.getOffer().getIsMyOffer();
    protected final Predicate<TradeInfo> isTaker = t -> t.getRole().toLowerCase().contains("taker");
    protected final Predicate<TradeInfo> isSellOffer = t -> t.getOffer().getDirection().equals(OfferDirection.SELL.name());
    protected final Predicate<TradeInfo> isBtcSeller = t -> this.isMyOffer.test((TradeInfo)t) && this.isSellOffer.test((TradeInfo)t) || !this.isMyOffer.test((TradeInfo)t) && !this.isSellOffer.test((TradeInfo)t);
    protected final Function<TradeInfo, Long> toCryptoTradeVolumeAsLong = t -> new BigDecimal(t.getTradeVolume()).movePointRight(8).longValue();
    protected final Function<TradeInfo, String> toTradeVolumeAsString = t -> this.isTraditionalTrade.test((TradeInfo)t) ? t.getTradeVolume() : CurrencyFormat.formatSatoshis(t.getAmount());
    protected final Function<TradeInfo, Long> toTradeVolumeAsLong = t -> this.isTraditionalTrade.test((TradeInfo)t) ? Long.parseLong(t.getTradeVolume()) : this.toCryptoTradeVolumeAsLong.apply((TradeInfo)t);
    protected final Function<TradeInfo, Long> toTradeAmount = t -> this.isTraditionalTrade.test((TradeInfo)t) ? t.getAmount() : this.toTradeVolumeAsLong.apply((TradeInfo)t).longValue();
    protected final Function<TradeInfo, String> toMarket = t -> t.getOffer().getBaseCurrencyCode() + "/" + t.getOffer().getCounterCurrencyCode();
    protected final Function<TradeInfo, String> toPaymentCurrencyCode = t -> this.isTraditionalTrade.test((TradeInfo)t) ? t.getOffer().getCounterCurrencyCode() : t.getOffer().getBaseCurrencyCode();
    protected final Function<TradeInfo, String> toPriceDeviation = t -> t.getOffer().getUseMarketBasedPrice() ? String.format("%.2f%s", t.getOffer().getMarketPriceMarginPct(), "%") : "N/A";
    protected final Function<TradeInfo, Long> toTradeFeeBtc = t -> {
        boolean isMyOffer = t.getOffer().getIsMyOffer();
        if (isMyOffer) {
            return t.getMakerFee();
        }
        return t.getTakerFee();
    };
    protected final Function<TradeInfo, Long> toMyMakerOrTakerFee = t -> this.isTaker.test((TradeInfo)t) ? t.getTakerFee() : t.getMakerFee();
    protected final Function<TradeInfo, String> toOfferType = t -> {
        if (this.isTraditionalTrade.test((TradeInfo)t)) {
            return t.getOffer().getDirection() + " " + t.getOffer().getBaseCurrencyCode();
        }
        if (t.getOffer().getDirection().equals("BUY")) {
            return "SELL " + t.getOffer().getBaseCurrencyCode();
        }
        return "BUY " + t.getOffer().getBaseCurrencyCode();
    };
    protected final Predicate<TradeInfo> showCryptoBuyerAddress = t -> {
        if (this.isTraditionalTrade.test((TradeInfo)t)) {
            return false;
        }
        ContractInfo contract = t.getContract();
        boolean isBuyerMakerAndSellerTaker = contract.getIsBuyerMakerAndSellerTaker();
        if (this.isTaker.test((TradeInfo)t)) {
            return !isBuyerMakerAndSellerTaker;
        }
        return isBuyerMakerAndSellerTaker;
    };
    protected final Function<TradeInfo, String> toCryptoReceiveAddress = t -> {
        if (this.showCryptoBuyerAddress.test((TradeInfo)t)) {
            ContractInfo contract = t.getContract();
            boolean isBuyerMakerAndSellerTaker = contract.getIsBuyerMakerAndSellerTaker();
            return isBuyerMakerAndSellerTaker ? contract.getTakerPaymentAccountPayload().getCryptoCurrencyAccountPayload().getAddress() : contract.getMakerPaymentAccountPayload().getCryptoCurrencyAccountPayload().getAddress();
        }
        return "";
    };

    AbstractTradeListBuilder(TableType tableType, List<?> protos) {
        super(tableType, protos);
        this.validate();
        this.trades = protos.stream().map(p -> (TradeInfo)p).collect(Collectors.toList());
        this.colSupplier = new TradeTableColumnSupplier(tableType, this.trades);
        this.colTradeId = this.colSupplier.tradeIdColumn.get();
        this.colCreateDate = this.colSupplier.createDateColumn.get();
        this.colMarket = this.colSupplier.marketColumn.get();
        this.colPrice = this.colSupplier.priceColumn.get();
        this.colPriceDeviation = this.colSupplier.priceDeviationColumn.get();
        this.colCurrency = this.colSupplier.currencyColumn.get();
        this.colAmount = this.colSupplier.amountColumn.get();
        this.colMixedAmount = this.colSupplier.mixedAmountColumn.get();
        this.colMixedTradeFee = this.colSupplier.mixedTradeFeeColumn.get();
        this.colBuyerDeposit = this.colSupplier.toSecurityDepositColumn.apply("Buyer Deposit (BTC)");
        this.colSellerDeposit = this.colSupplier.toSecurityDepositColumn.apply("Seller Deposit (BTC)");
        this.colPaymentMethod = this.colSupplier.paymentMethodColumn.get();
        this.colRole = this.colSupplier.roleColumn.get();
        this.colOfferType = this.colSupplier.offerTypeColumn.get();
        this.colClosingStatus = this.colSupplier.statusDescriptionColumn.get();
        this.colIsDepositPublished = this.colSupplier.depositPublishedColumn.get();
        this.colIsDepositConfirmed = this.colSupplier.depositConfirmedColumn.get();
        this.colIsPayoutPublished = this.colSupplier.payoutPublishedColumn.get();
        this.colIsCompleted = this.colSupplier.fundsWithdrawnColumn.get();
        this.colHavenoTradeFee = this.colSupplier.havenoTradeDetailFeeColumn.get();
        this.colTradeCost = this.colSupplier.tradeCostColumn.get();
        this.colIsPaymentSentMessageSent = this.colSupplier.paymentSentMessageSentColumn.get();
        this.colIsPaymentReceivedMessageSent = this.colSupplier.paymentReceivedMessageSentColumn.get();
        this.colCryptoReceiveAddressColumn = this.colSupplier.cryptoReceiveAddressColumn.get();
    }

    protected void validate() {
        if (this.isTradeDetailTblBuilder.get().booleanValue()) {
            if (this.protos.size() != 1) {
                throw new IllegalArgumentException("trade detail tbl can have only one row");
            }
        } else if (this.protos.isEmpty()) {
            throw new IllegalArgumentException("trade tbl has no rows");
        }
    }
}

