/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.table;

import com.google.common.base.Strings;
import haveno.cli.table.column.Column;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;

public class Table {
    public final Column<?>[] columns;
    public final int rowCount;
    private final int columnDelimiterLength = 2;

    public Table(Column<?> ... columns) {
        this.columns = columns;
        this.rowCount = columns.length > 0 ? columns[0].rowCount() : 0;
        this.validateStructure();
    }

    public void print(PrintStream printStream) {
        this.printColumnNames(printStream);
        for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
            this.printRow(printStream, rowIndex);
        }
    }

    private void printColumnNames(PrintStream printStream) {
        IntStream.range(0, this.columns.length).forEachOrdered(colIndex -> {
            Column<?> c = this.columns[colIndex];
            String justifiedName = c.getJustification().equals((Object)Column.JUSTIFICATION.RIGHT) ? Strings.padStart((String)c.getName(), (int)c.getWidth(), (char)' ') : c.getName();
            int paddedWidth = colIndex == this.columns.length - 1 ? c.getName().length() : c.getWidth() + 2;
            printStream.printf("%-" + paddedWidth + "s", justifiedName);
        });
        printStream.println();
    }

    private void printRow(PrintStream printStream, int rowIndex) {
        IntStream.range(0, this.columns.length).forEachOrdered(colIndex -> {
            Column<?> c = this.columns[colIndex];
            int paddedWidth = colIndex == this.columns.length - 1 ? c.getWidth() : c.getWidth() + 2;
            printStream.printf("%-" + paddedWidth + "s", c.getRow(rowIndex));
            if (colIndex == this.columns.length - 1) {
                printStream.println();
            }
        });
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8);){
            this.print(ps);
        }
        return baos.toString();
    }

    private void validateStructure() {
        if (this.columns.length == 0) {
            throw new IllegalArgumentException("Table has no columns.");
        }
        if (this.columns[0].isEmpty()) {
            throw new IllegalArgumentException(String.format("Table's 1st column (%s) has no data.", this.columns[0].getName()));
        }
        IntStream.range(1, this.columns.length).forEachOrdered(colIndex -> {
            Column<?> c = this.columns[colIndex];
            if (c.isEmpty()) {
                throw new IllegalStateException(String.format("Table column # %d (%s) does not have any data.", colIndex + 1, c.getName()));
            }
            if (this.rowCount != c.rowCount()) {
                throw new IllegalStateException(String.format("Table column # %d (%s) does not have same number of rows as 1st column.", colIndex + 1, c.getName()));
            }
        });
    }
}

