/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.request;

import haveno.cli.GrpcStubs;
import haveno.proto.grpc.AddressBalanceInfo;
import haveno.proto.grpc.BalancesInfo;
import haveno.proto.grpc.BtcBalanceInfo;
import haveno.proto.grpc.GetAddressBalanceRequest;
import haveno.proto.grpc.GetBalancesRequest;
import haveno.proto.grpc.GetFundingAddressesRequest;
import haveno.proto.grpc.LockWalletRequest;
import haveno.proto.grpc.MarketPriceRequest;
import haveno.proto.grpc.RemoveWalletPasswordRequest;
import haveno.proto.grpc.SetWalletPasswordRequest;
import haveno.proto.grpc.UnlockWalletRequest;
import java.util.List;

public class WalletsServiceRequest {
    private final GrpcStubs grpcStubs;

    public WalletsServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public BalancesInfo getBalances() {
        return this.getBalances("");
    }

    public BtcBalanceInfo getBtcBalances() {
        return this.getBalances("BTC").getBtc();
    }

    public BalancesInfo getBalances(String currencyCode) {
        GetBalancesRequest request = GetBalancesRequest.newBuilder().setCurrencyCode(currencyCode).build();
        return this.grpcStubs.walletsService.getBalances(request).getBalances();
    }

    public AddressBalanceInfo getAddressBalance(String address) {
        GetAddressBalanceRequest request = GetAddressBalanceRequest.newBuilder().setAddress(address).build();
        return this.grpcStubs.walletsService.getAddressBalance(request).getAddressBalanceInfo();
    }

    public double getBtcPrice(String currencyCode) {
        MarketPriceRequest request = MarketPriceRequest.newBuilder().setCurrencyCode(currencyCode).build();
        return this.grpcStubs.priceService.getMarketPrice(request).getPrice();
    }

    public List<AddressBalanceInfo> getFundingAddresses() {
        GetFundingAddressesRequest request = GetFundingAddressesRequest.newBuilder().build();
        return this.grpcStubs.walletsService.getFundingAddresses(request).getAddressBalanceInfoList();
    }

    public String getUnusedBtcAddress() {
        GetFundingAddressesRequest request = GetFundingAddressesRequest.newBuilder().build();
        List addressBalances = this.grpcStubs.walletsService.getFundingAddresses(request).getAddressBalanceInfoList();
        return addressBalances.stream().filter(AddressBalanceInfo::getIsAddressUnused).findFirst().get().getAddress();
    }

    public void lockWallet() {
        LockWalletRequest request = LockWalletRequest.newBuilder().build();
        this.grpcStubs.walletsService.lockWallet(request);
    }

    public void unlockWallet(String walletPassword, long timeout) {
        UnlockWalletRequest request = UnlockWalletRequest.newBuilder().setPassword(walletPassword).setTimeout(timeout).build();
        this.grpcStubs.walletsService.unlockWallet(request);
    }

    public void removeWalletPassword(String walletPassword) {
        RemoveWalletPasswordRequest request = RemoveWalletPasswordRequest.newBuilder().setPassword(walletPassword).build();
        this.grpcStubs.walletsService.removeWalletPassword(request);
    }

    public void setWalletPassword(String walletPassword) {
        SetWalletPasswordRequest request = SetWalletPasswordRequest.newBuilder().setPassword(walletPassword).build();
        this.grpcStubs.walletsService.setWalletPassword(request);
    }

    public void setWalletPassword(String oldWalletPassword, String newWalletPassword) {
        SetWalletPasswordRequest request = SetWalletPasswordRequest.newBuilder().setPassword(oldWalletPassword).setNewPassword(newWalletPassword).build();
        this.grpcStubs.walletsService.setWalletPassword(request);
    }
}

