/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.request;

import haveno.cli.GrpcStubs;
import haveno.proto.grpc.ConfirmPaymentReceivedRequest;
import haveno.proto.grpc.ConfirmPaymentSentRequest;
import haveno.proto.grpc.GetTradeRequest;
import haveno.proto.grpc.GetTradesRequest;
import haveno.proto.grpc.TakeOfferReply;
import haveno.proto.grpc.TakeOfferRequest;
import haveno.proto.grpc.TradeInfo;
import haveno.proto.grpc.WithdrawFundsRequest;
import java.util.List;

public class TradesServiceRequest {
    private final GrpcStubs grpcStubs;

    public TradesServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public TakeOfferReply getTakeOfferReply(String offerId, String paymentAccountId) {
        TakeOfferRequest request = TakeOfferRequest.newBuilder().setOfferId(offerId).setPaymentAccountId(paymentAccountId).build();
        return this.grpcStubs.tradesService.takeOffer(request);
    }

    public TradeInfo takeOffer(String offerId, String paymentAccountId) {
        TakeOfferReply reply = this.getTakeOfferReply(offerId, paymentAccountId);
        if (reply.hasTrade()) {
            return reply.getTrade();
        }
        throw new IllegalStateException(reply.getFailureReason().getDescription());
    }

    public TradeInfo getTrade(String tradeId) {
        GetTradeRequest request = GetTradeRequest.newBuilder().setTradeId(tradeId).build();
        return this.grpcStubs.tradesService.getTrade(request).getTrade();
    }

    public List<TradeInfo> getOpenTrades() {
        GetTradesRequest request = GetTradesRequest.newBuilder().build();
        return this.grpcStubs.tradesService.getTrades(request).getTradesList();
    }

    public List<TradeInfo> getTradeHistory(GetTradesRequest.Category category) {
        if (!category.equals((Object)GetTradesRequest.Category.CLOSED) && !category.equals((Object)GetTradesRequest.Category.FAILED)) {
            throw new IllegalStateException("unrecognized gettrades category parameter " + category.name());
        }
        GetTradesRequest request = GetTradesRequest.newBuilder().setCategory(category).build();
        return this.grpcStubs.tradesService.getTrades(request).getTradesList();
    }

    public void confirmPaymentSent(String tradeId) {
        ConfirmPaymentSentRequest request = ConfirmPaymentSentRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.confirmPaymentSent(request);
    }

    public void confirmPaymentReceived(String tradeId) {
        ConfirmPaymentReceivedRequest request = ConfirmPaymentReceivedRequest.newBuilder().setTradeId(tradeId).build();
        this.grpcStubs.tradesService.confirmPaymentReceived(request);
    }

    public void withdrawFunds(String tradeId, String address, String memo) {
        WithdrawFundsRequest request = WithdrawFundsRequest.newBuilder().setTradeId(tradeId).setAddress(address).setMemo(memo).build();
        this.grpcStubs.tradesService.withdrawFunds(request);
    }
}

