/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.request;

import haveno.cli.GrpcStubs;
import haveno.proto.grpc.CreateCryptoCurrencyPaymentAccountRequest;
import haveno.proto.grpc.CreatePaymentAccountRequest;
import haveno.proto.grpc.GetCryptoCurrencyPaymentMethodsRequest;
import haveno.proto.grpc.GetPaymentAccountFormAsJsonRequest;
import haveno.proto.grpc.GetPaymentAccountsRequest;
import haveno.proto.grpc.GetPaymentMethodsRequest;
import java.util.List;
import protobuf.PaymentAccount;
import protobuf.PaymentMethod;

public class PaymentAccountsServiceRequest {
    private final GrpcStubs grpcStubs;

    public PaymentAccountsServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public List<PaymentMethod> getPaymentMethods() {
        GetPaymentMethodsRequest request = GetPaymentMethodsRequest.newBuilder().build();
        return this.grpcStubs.paymentAccountsService.getPaymentMethods(request).getPaymentMethodsList();
    }

    public String getPaymentAcctFormAsJson(String paymentMethodId) {
        GetPaymentAccountFormAsJsonRequest request = GetPaymentAccountFormAsJsonRequest.newBuilder().setPaymentMethodId(paymentMethodId).build();
        return this.grpcStubs.paymentAccountsService.getPaymentAccountFormAsJson(request).getPaymentAccountFormAsJson();
    }

    public PaymentAccount createPaymentAccount(String json) {
        CreatePaymentAccountRequest request = CreatePaymentAccountRequest.newBuilder().setPaymentAccountFormAsJson(json).build();
        return this.grpcStubs.paymentAccountsService.createPaymentAccount(request).getPaymentAccount();
    }

    public List<PaymentAccount> getPaymentAccounts() {
        GetPaymentAccountsRequest request = GetPaymentAccountsRequest.newBuilder().build();
        return this.grpcStubs.paymentAccountsService.getPaymentAccounts(request).getPaymentAccountsList();
    }

    public PaymentAccount getPaymentAccount(String accountName) {
        return this.getPaymentAccounts().stream().filter(a -> a.getAccountName().equals(accountName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("payment account with name '%s' not found", accountName)));
    }

    public PaymentAccount createCryptoCurrencyPaymentAccount(String accountName, String currencyCode, String address, boolean tradeInstant) {
        CreateCryptoCurrencyPaymentAccountRequest request = CreateCryptoCurrencyPaymentAccountRequest.newBuilder().setAccountName(accountName).setCurrencyCode(currencyCode).setAddress(address).setTradeInstant(tradeInstant).build();
        return this.grpcStubs.paymentAccountsService.createCryptoCurrencyPaymentAccount(request).getPaymentAccount();
    }

    public List<PaymentMethod> getCryptoPaymentMethods() {
        GetCryptoCurrencyPaymentMethodsRequest request = GetCryptoCurrencyPaymentMethodsRequest.newBuilder().build();
        return this.grpcStubs.paymentAccountsService.getCryptoCurrencyPaymentMethods(request).getPaymentMethodsList();
    }
}

