/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.request;

import haveno.cli.GrpcStubs;
import haveno.proto.grpc.CancelOfferRequest;
import haveno.proto.grpc.GetMyOfferRequest;
import haveno.proto.grpc.GetMyOffersRequest;
import haveno.proto.grpc.GetOfferRequest;
import haveno.proto.grpc.GetOffersRequest;
import haveno.proto.grpc.OfferInfo;
import haveno.proto.grpc.PostOfferRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import protobuf.OfferDirection;

public class OffersServiceRequest {
    private final GrpcStubs grpcStubs;

    public OffersServiceRequest(GrpcStubs grpcStubs) {
        this.grpcStubs = grpcStubs;
    }

    public OfferInfo createFixedPricedOffer(String direction, String currencyCode, long amount, long minAmount, String fixedPrice, double securityDepositPct, String paymentAcctId, String makerFeeCurrencyCode) {
        return this.createOffer(direction, currencyCode, amount, minAmount, false, fixedPrice, 0.0, securityDepositPct, paymentAcctId, "0");
    }

    public OfferInfo createOffer(String direction, String currencyCode, long amount, long minAmount, boolean useMarketBasedPrice, String fixedPrice, double marketPriceMarginPct, double securityDepositPct, String paymentAcctId, String triggerPrice) {
        PostOfferRequest request = PostOfferRequest.newBuilder().setDirection(direction).setCurrencyCode(currencyCode).setAmount(amount).setMinAmount(minAmount).setUseMarketBasedPrice(useMarketBasedPrice).setPrice(fixedPrice).setMarketPriceMarginPct(marketPriceMarginPct).setSecurityDepositPct(securityDepositPct).setPaymentAccountId(paymentAcctId).setTriggerPrice(triggerPrice).build();
        return this.grpcStubs.offersService.postOffer(request).getOffer();
    }

    public void cancelOffer(String offerId) {
        CancelOfferRequest request = CancelOfferRequest.newBuilder().setId(offerId).build();
        this.grpcStubs.offersService.cancelOffer(request);
    }

    public OfferInfo getOffer(String offerId) {
        GetOfferRequest request = GetOfferRequest.newBuilder().setId(offerId).build();
        return this.grpcStubs.offersService.getOffer(request).getOffer();
    }

    public OfferInfo getMyOffer(String offerId) {
        GetMyOfferRequest request = GetMyOfferRequest.newBuilder().setId(offerId).build();
        return this.grpcStubs.offersService.getMyOffer(request).getOffer();
    }

    public List<OfferInfo> getOffers(String direction, String currencyCode) {
        GetOffersRequest request = GetOffersRequest.newBuilder().setDirection(direction).setCurrencyCode(currencyCode).build();
        return this.grpcStubs.offersService.getOffers(request).getOffersList();
    }

    public List<OfferInfo> getOffersSortedByDate(String currencyCode) {
        ArrayList<OfferInfo> offers = new ArrayList<OfferInfo>();
        offers.addAll(this.getOffers(OfferDirection.BUY.name(), currencyCode));
        offers.addAll(this.getOffers(OfferDirection.SELL.name(), currencyCode));
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getOffersSortedByDate(String direction, String currencyCode) {
        List<OfferInfo> offers = this.getOffers(direction, currencyCode);
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getMyOffers(String direction, String currencyCode) {
        GetMyOffersRequest request = GetMyOffersRequest.newBuilder().setDirection(direction).setCurrencyCode(currencyCode).build();
        return this.grpcStubs.offersService.getMyOffers(request).getOffersList();
    }

    public List<OfferInfo> getMyOffersSortedByDate(String currencyCode) {
        ArrayList<OfferInfo> offers = new ArrayList<OfferInfo>();
        offers.addAll(this.getMyOffers(OfferDirection.BUY.name(), currencyCode));
        offers.addAll(this.getMyOffers(OfferDirection.SELL.name(), currencyCode));
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public List<OfferInfo> getMyOffersSortedByDate(String direction, String currencyCode) {
        List<OfferInfo> offers = this.getMyOffers(direction, currencyCode);
        return offers.isEmpty() ? offers : this.sortOffersByDate(offers);
    }

    public OfferInfo getMostRecentOffer(String direction, String currencyCode) {
        List<OfferInfo> offers = this.getOffersSortedByDate(direction, currencyCode);
        return offers.isEmpty() ? null : offers.get(offers.size() - 1);
    }

    public List<OfferInfo> sortOffersByDate(List<OfferInfo> offerInfoList) {
        return offerInfoList.stream().sorted(Comparator.comparing(OfferInfo::getDate)).collect(Collectors.toList());
    }
}

