/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli.opts;

import haveno.cli.CryptoCurrencyUtil;
import haveno.cli.opts.AbstractMethodOptionParser;
import haveno.cli.opts.MethodOpts;
import joptsimple.OptionSpec;

public class CreateCryptoCurrencyPaymentAcctOptionParser
extends AbstractMethodOptionParser
implements MethodOpts {
    final OptionSpec<String> accountNameOpt;
    final OptionSpec<String> currencyCodeOpt;
    final OptionSpec<String> addressOpt;
    final OptionSpec<Boolean> tradeInstantOpt;

    public CreateCryptoCurrencyPaymentAcctOptionParser(String[] args) {
        super(args);
        this.accountNameOpt = this.parser.accepts("account-name", "crypto currency account name").withRequiredArg();
        this.currencyCodeOpt = this.parser.accepts("currency-code", "crypto currency code (xmr)").withRequiredArg();
        this.addressOpt = this.parser.accepts("address", "crypto address").withRequiredArg();
        this.tradeInstantOpt = this.parser.accepts("trade-instant", "create trade instant account").withOptionalArg().ofType(Boolean.TYPE).defaultsTo((Object)Boolean.FALSE, (Object[])new Boolean[0]);
    }

    @Override
    public CreateCryptoCurrencyPaymentAcctOptionParser parse() {
        super.parse();
        if (this.options.has(this.helpOpt)) {
            return this;
        }
        if (!this.options.has(this.accountNameOpt) || ((String)this.options.valueOf(this.accountNameOpt)).isEmpty()) {
            throw new IllegalArgumentException("no payment account name specified");
        }
        if (!this.options.has(this.currencyCodeOpt) || ((String)this.options.valueOf(this.currencyCodeOpt)).isEmpty()) {
            throw new IllegalArgumentException("no currency code specified");
        }
        String cryptoCurrencyCode = (String)this.options.valueOf(this.currencyCodeOpt);
        if (!CryptoCurrencyUtil.apiDoesSupportCryptoCurrency(cryptoCurrencyCode)) {
            throw new IllegalArgumentException(String.format("api does not support %s payment accounts", cryptoCurrencyCode.toLowerCase()));
        }
        if (!this.options.has(this.addressOpt) || ((String)this.options.valueOf(this.addressOpt)).isEmpty()) {
            throw new IllegalArgumentException(String.format("no %s address specified", cryptoCurrencyCode.toLowerCase()));
        }
        return this;
    }

    public String getAccountName() {
        return (String)this.options.valueOf(this.accountNameOpt);
    }

    public String getCurrencyCode() {
        return (String)this.options.valueOf(this.currencyCodeOpt);
    }

    public String getAddress() {
        return (String)this.options.valueOf(this.addressOpt);
    }

    public boolean getIsTradeInstant() {
        return (Boolean)this.options.valueOf(this.tradeInstantOpt);
    }
}

