/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;

class PasswordCallCredentials
extends CallCredentials {
    public static final String PASSWORD_KEY = "password";
    private final String passwordValue;

    public PasswordCallCredentials(String passwordValue) {
        if (passwordValue == null) {
            throw new IllegalArgumentException(String.format("'%s' value must not be null", PASSWORD_KEY));
        }
        this.passwordValue = passwordValue;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier metadataApplier) {
        appExecutor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                Metadata.Key passwordKey = Metadata.Key.of((String)PASSWORD_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                headers.put(passwordKey, (Object)this.passwordValue);
                metadataApplier.apply(headers);
            }
            catch (Throwable ex) {
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(ex));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

