/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli;

import haveno.cli.GrpcStubs;
import haveno.cli.Method;
import haveno.cli.request.OffersServiceRequest;
import haveno.cli.request.PaymentAccountsServiceRequest;
import haveno.cli.request.TradesServiceRequest;
import haveno.cli.request.WalletsServiceRequest;
import haveno.proto.grpc.AddressBalanceInfo;
import haveno.proto.grpc.BalancesInfo;
import haveno.proto.grpc.BtcBalanceInfo;
import haveno.proto.grpc.GetMethodHelpRequest;
import haveno.proto.grpc.GetTradesRequest;
import haveno.proto.grpc.GetVersionRequest;
import haveno.proto.grpc.OfferInfo;
import haveno.proto.grpc.RegisterDisputeAgentRequest;
import haveno.proto.grpc.StopRequest;
import haveno.proto.grpc.TradeInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccount;
import protobuf.PaymentMethod;

public final class GrpcClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcClient.class);
    private final GrpcStubs grpcStubs;
    private final OffersServiceRequest offersServiceRequest;
    private final TradesServiceRequest tradesServiceRequest;
    private final WalletsServiceRequest walletsServiceRequest;
    private final PaymentAccountsServiceRequest paymentAccountsServiceRequest;

    public GrpcClient(String apiHost, int apiPort, String apiPassword) {
        this.grpcStubs = new GrpcStubs(apiHost, apiPort, apiPassword);
        this.offersServiceRequest = new OffersServiceRequest(this.grpcStubs);
        this.tradesServiceRequest = new TradesServiceRequest(this.grpcStubs);
        this.walletsServiceRequest = new WalletsServiceRequest(this.grpcStubs);
        this.paymentAccountsServiceRequest = new PaymentAccountsServiceRequest(this.grpcStubs);
    }

    public String getVersion() {
        GetVersionRequest request = GetVersionRequest.newBuilder().build();
        return this.grpcStubs.versionService.getVersion(request).getVersion();
    }

    public BalancesInfo getBalances() {
        return this.walletsServiceRequest.getBalances();
    }

    public BtcBalanceInfo getBtcBalances() {
        return this.walletsServiceRequest.getBtcBalances();
    }

    public BalancesInfo getBalances(String currencyCode) {
        return this.walletsServiceRequest.getBalances(currencyCode);
    }

    public AddressBalanceInfo getAddressBalance(String address) {
        return this.walletsServiceRequest.getAddressBalance(address);
    }

    public double getBtcPrice(String currencyCode) {
        return this.walletsServiceRequest.getBtcPrice(currencyCode);
    }

    public List<AddressBalanceInfo> getFundingAddresses() {
        return this.walletsServiceRequest.getFundingAddresses();
    }

    public String getUnusedBtcAddress() {
        return this.walletsServiceRequest.getUnusedBtcAddress();
    }

    public OfferInfo createFixedPricedOffer(String direction, String currencyCode, long amount, long minAmount, String fixedPrice, double securityDepositPct, String paymentAcctId) {
        return this.offersServiceRequest.createOffer(direction, currencyCode, amount, minAmount, false, fixedPrice, 0.0, securityDepositPct, paymentAcctId, "0");
    }

    public OfferInfo createMarketBasedPricedOffer(String direction, String currencyCode, long amount, long minAmount, double marketPriceMarginPct, double securityDepositPct, String paymentAcctId, String triggerPrice) {
        return this.offersServiceRequest.createOffer(direction, currencyCode, amount, minAmount, true, "0", marketPriceMarginPct, securityDepositPct, paymentAcctId, triggerPrice);
    }

    public OfferInfo createOffer(String direction, String currencyCode, long amount, long minAmount, boolean useMarketBasedPrice, String fixedPrice, double marketPriceMarginPct, double securityDepositPct, String paymentAcctId, String triggerPrice) {
        return this.offersServiceRequest.createOffer(direction, currencyCode, amount, minAmount, useMarketBasedPrice, fixedPrice, marketPriceMarginPct, securityDepositPct, paymentAcctId, triggerPrice);
    }

    public void cancelOffer(String offerId) {
        this.offersServiceRequest.cancelOffer(offerId);
    }

    public OfferInfo getOffer(String offerId) {
        return this.offersServiceRequest.getOffer(offerId);
    }

    @Deprecated
    public OfferInfo getMyOffer(String offerId) {
        return this.offersServiceRequest.getMyOffer(offerId);
    }

    public List<OfferInfo> getOffers(String direction, String currencyCode) {
        return this.offersServiceRequest.getOffers(direction, currencyCode);
    }

    public List<OfferInfo> getOffersSortedByDate(String currencyCode) {
        return this.offersServiceRequest.getOffersSortedByDate(currencyCode);
    }

    public List<OfferInfo> getOffersSortedByDate(String direction, String currencyCode) {
        return this.offersServiceRequest.getOffersSortedByDate(direction, currencyCode);
    }

    public List<OfferInfo> getMyOffers(String direction, String currencyCode) {
        return this.offersServiceRequest.getMyOffers(direction, currencyCode);
    }

    public List<OfferInfo> getMyOffersSortedByDate(String currencyCode) {
        return this.offersServiceRequest.getMyOffersSortedByDate(currencyCode);
    }

    public List<OfferInfo> getMyOffersSortedByDate(String direction, String currencyCode) {
        return this.offersServiceRequest.getMyOffersSortedByDate(direction, currencyCode);
    }

    public TradeInfo takeOffer(String offerId, String paymentAccountId) {
        return this.tradesServiceRequest.takeOffer(offerId, paymentAccountId);
    }

    public TradeInfo getTrade(String tradeId) {
        return this.tradesServiceRequest.getTrade(tradeId);
    }

    public List<TradeInfo> getOpenTrades() {
        return this.tradesServiceRequest.getOpenTrades();
    }

    public List<TradeInfo> getTradeHistory(GetTradesRequest.Category category) {
        return this.tradesServiceRequest.getTradeHistory(category);
    }

    public void confirmPaymentSent(String tradeId) {
        this.tradesServiceRequest.confirmPaymentSent(tradeId);
    }

    public void confirmPaymentReceived(String tradeId) {
        this.tradesServiceRequest.confirmPaymentReceived(tradeId);
    }

    public void withdrawFunds(String tradeId, String address, String memo) {
        this.tradesServiceRequest.withdrawFunds(tradeId, address, memo);
    }

    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentAccountsServiceRequest.getPaymentMethods();
    }

    public String getPaymentAcctFormAsJson(String paymentMethodId) {
        return this.paymentAccountsServiceRequest.getPaymentAcctFormAsJson(paymentMethodId);
    }

    public PaymentAccount createPaymentAccount(String json) {
        return this.paymentAccountsServiceRequest.createPaymentAccount(json);
    }

    public List<PaymentAccount> getPaymentAccounts() {
        return this.paymentAccountsServiceRequest.getPaymentAccounts();
    }

    public PaymentAccount getPaymentAccount(String accountName) {
        return this.paymentAccountsServiceRequest.getPaymentAccount(accountName);
    }

    public PaymentAccount createCryptoCurrencyPaymentAccount(String accountName, String currencyCode, String address, boolean tradeInstant) {
        return this.paymentAccountsServiceRequest.createCryptoCurrencyPaymentAccount(accountName, currencyCode, address, tradeInstant);
    }

    public List<PaymentMethod> getCryptoPaymentMethods() {
        return this.paymentAccountsServiceRequest.getCryptoPaymentMethods();
    }

    public void lockWallet() {
        this.walletsServiceRequest.lockWallet();
    }

    public void unlockWallet(String walletPassword, long timeout) {
        this.walletsServiceRequest.unlockWallet(walletPassword, timeout);
    }

    public void removeWalletPassword(String walletPassword) {
        this.walletsServiceRequest.removeWalletPassword(walletPassword);
    }

    public void setWalletPassword(String walletPassword) {
        this.walletsServiceRequest.setWalletPassword(walletPassword);
    }

    public void setWalletPassword(String oldWalletPassword, String newWalletPassword) {
        this.walletsServiceRequest.setWalletPassword(oldWalletPassword, newWalletPassword);
    }

    public void registerDisputeAgent(String disputeAgentType, String registrationKey) {
        RegisterDisputeAgentRequest request = RegisterDisputeAgentRequest.newBuilder().setDisputeAgentType(disputeAgentType).setRegistrationKey(registrationKey).build();
        this.grpcStubs.disputeAgentsService.registerDisputeAgent(request);
    }

    public void stopServer() {
        StopRequest request = StopRequest.newBuilder().build();
        this.grpcStubs.shutdownService.stop(request);
    }

    public String getMethodHelp(Method method) {
        GetMethodHelpRequest request = GetMethodHelpRequest.newBuilder().setMethodName(method.name()).build();
        return this.grpcStubs.helpService.getMethodHelp(request).getMethodHelp();
    }
}

