/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli;

import haveno.proto.grpc.OfferInfo;
import java.util.List;
import java.util.function.Function;
import protobuf.OfferDirection;

class DirectionFormat {
    static final Function<OfferInfo, String> directionFormat = offer -> {
        boolean isCryptoCurrencyOffer;
        String baseCurrencyCode = offer.getBaseCurrencyCode();
        boolean bl = isCryptoCurrencyOffer = !baseCurrencyCode.equals("XMR");
        if (!isCryptoCurrencyOffer) {
            return baseCurrencyCode;
        }
        String direction = offer.getDirection();
        String mirroredDirection = DirectionFormat.getMirroredDirection(direction);
        Function<String, String> mixedCase = word -> word.charAt(0) + word.substring(1).toLowerCase();
        return String.format("%s %s (%s %s)", mixedCase.apply(mirroredDirection), baseCurrencyCode, mixedCase.apply(direction), offer.getCounterCurrencyCode());
    };

    DirectionFormat() {
    }

    static int getLongestDirectionColWidth(List<OfferInfo> offers) {
        if (offers.isEmpty() || offers.get(0).getBaseCurrencyCode().equals("XMR")) {
            return "Buy/Sell".length();
        }
        return 18;
    }

    static String getMirroredDirection(String directionAsString) {
        return directionAsString.equalsIgnoreCase(OfferDirection.BUY.name()) ? OfferDirection.SELL.name() : OfferDirection.BUY.name();
    }
}

