/*
 * Decompiled with CFR 0.152.
 */
package haveno.cli;

import haveno.cli.CurrencyFormat;
import haveno.cli.GrpcClient;
import haveno.cli.Method;
import haveno.cli.opts.ArgumentList;
import haveno.cli.opts.CancelOfferOptionParser;
import haveno.cli.opts.CreateCryptoCurrencyPaymentAcctOptionParser;
import haveno.cli.opts.CreateOfferOptionParser;
import haveno.cli.opts.CreatePaymentAcctOptionParser;
import haveno.cli.opts.GetAddressBalanceOptionParser;
import haveno.cli.opts.GetBTCMarketPriceOptionParser;
import haveno.cli.opts.GetBalanceOptionParser;
import haveno.cli.opts.GetOffersOptionParser;
import haveno.cli.opts.GetPaymentAcctFormOptionParser;
import haveno.cli.opts.GetTradeOptionParser;
import haveno.cli.opts.GetTradesOptionParser;
import haveno.cli.opts.OfferIdOptionParser;
import haveno.cli.opts.RegisterDisputeAgentOptionParser;
import haveno.cli.opts.RemoveWalletPasswordOptionParser;
import haveno.cli.opts.SendBtcOptionParser;
import haveno.cli.opts.SetWalletPasswordOptionParser;
import haveno.cli.opts.SimpleMethodOptionParser;
import haveno.cli.opts.TakeOfferOptionParser;
import haveno.cli.opts.UnlockWalletOptionParser;
import haveno.cli.opts.WithdrawFundsOptionParser;
import haveno.cli.table.builder.TableBuilder;
import haveno.cli.table.builder.TableType;
import haveno.proto.grpc.AddressBalanceInfo;
import haveno.proto.grpc.BalancesInfo;
import haveno.proto.grpc.GetTradesRequest;
import haveno.proto.grpc.OfferInfo;
import haveno.proto.grpc.TradeInfo;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccount;
import protobuf.PaymentMethod;

public class CliMain {
    private static final Logger log = LoggerFactory.getLogger(CliMain.class);

    public static void main(String[] args) {
        try {
            CliMain.run(args);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            System.exit(1);
        }
    }

    public static void run(String[] args) {
        Method method;
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print this help text").forHelp();
        ArgumentAcceptingOptionSpec hostOpt = parser.accepts("host", "rpc server hostname or ip").withRequiredArg().defaultsTo((Object)"localhost", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec portOpt = parser.accepts("port", "rpc server port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)9998, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec passwordOpt = parser.accepts("password", "rpc server password").withRequiredArg();
        OptionSet options = parser.parse(new ArgumentList(args).getCLIArguments());
        List nonOptionArgs = options.nonOptionArguments();
        if (!options.has((OptionSpec)helpOpt) && nonOptionArgs.isEmpty()) {
            CliMain.printHelp(parser, System.err);
            throw new IllegalArgumentException("no method specified");
        }
        if (options.has((OptionSpec)helpOpt) && nonOptionArgs.isEmpty()) {
            CliMain.printHelp(parser, System.out);
            return;
        }
        String host = (String)options.valueOf((OptionSpec)hostOpt);
        Integer port = (Integer)options.valueOf((OptionSpec)portOpt);
        String password = (String)options.valueOf((OptionSpec)passwordOpt);
        if (password == null) {
            throw new IllegalArgumentException("missing required 'password' option");
        }
        String methodName = (String)nonOptionArgs.get(0);
        try {
            method = CliMain.getMethodFromCmd(methodName);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("'%s' is not a supported method", methodName));
        }
        GrpcClient client = new GrpcClient(host, port, password);
        try {
            switch (method) {
                case getversion: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String version = client.getVersion();
                    System.out.println(version);
                    return;
                }
                case getbalance: {
                    GetBalanceOptionParser opts = new GetBalanceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String currencyCode = opts.getCurrencyCode();
                    BalancesInfo balances = client.getBalances(currencyCode);
                    switch (currencyCode.toUpperCase()) {
                        case "BTC": {
                            new TableBuilder(TableType.BTC_BALANCE_TBL, balances.getBtc()).build().print(System.out);
                            break;
                        }
                        default: {
                            System.out.println("BTC");
                            new TableBuilder(TableType.BTC_BALANCE_TBL, balances.getBtc()).build().print(System.out);
                        }
                    }
                    return;
                }
                case getaddressbalance: {
                    GetAddressBalanceOptionParser opts = new GetAddressBalanceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = opts.getAddress();
                    AddressBalanceInfo addressBalance = client.getAddressBalance(address);
                    new TableBuilder(TableType.ADDRESS_BALANCE_TBL, addressBalance).build().print(System.out);
                    return;
                }
                case getbtcprice: {
                    GetBTCMarketPriceOptionParser opts = new GetBTCMarketPriceOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String currencyCode = opts.getCurrencyCode();
                    double price = client.getBtcPrice(currencyCode);
                    System.out.println(CurrencyFormat.formatInternalFiatPrice(price));
                    return;
                }
                case getfundingaddresses: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<AddressBalanceInfo> fundingAddresses = client.getFundingAddresses();
                    new TableBuilder(TableType.ADDRESS_BALANCE_TBL, fundingAddresses).build().print(System.out);
                    return;
                }
                case sendbtc: {
                    SendBtcOptionParser opts = new SendBtcOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String address = opts.getAddress();
                    String amount = opts.getAmount();
                    CliMain.verifyStringIsValidDecimal("amount", amount);
                    String txFeeRate = opts.getFeeRate();
                    if (!txFeeRate.isEmpty()) {
                        CliMain.verifyStringIsValidLong("tx-fee-rate", txFeeRate);
                    }
                    String memo = opts.getMemo();
                    throw new RuntimeException("Send BTC not implemented");
                }
                case createoffer: {
                    CreateOfferOptionParser opts = new CreateOfferOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String paymentAcctId = opts.getPaymentAccountId();
                    String direction = opts.getDirection();
                    String currencyCode = opts.getCurrencyCode();
                    long amount = CurrencyFormat.toSatoshis(opts.getAmount());
                    long minAmount = CurrencyFormat.toSatoshis(opts.getMinAmount());
                    boolean useMarketBasedPrice = opts.isUsingMktPriceMargin();
                    String fixedPrice = opts.getFixedPrice();
                    double marketPriceMarginPct = opts.getMktPriceMarginPct();
                    double securityDepositPct = opts.getSecurityDepositPct();
                    String triggerPrice = "0";
                    OfferInfo offer = client.createOffer(direction, currencyCode, amount, minAmount, useMarketBasedPrice, fixedPrice, marketPriceMarginPct, securityDepositPct, paymentAcctId, triggerPrice);
                    new TableBuilder(TableType.OFFER_TBL, offer).build().print(System.out);
                    return;
                }
                case canceloffer: {
                    CancelOfferOptionParser opts = new CancelOfferOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    client.cancelOffer(offerId);
                    System.out.println("offer canceled and removed from offer book");
                    return;
                }
                case getoffer: {
                    OfferIdOptionParser opts = new OfferIdOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    OfferInfo offer = client.getOffer(offerId);
                    new TableBuilder(TableType.OFFER_TBL, offer).build().print(System.out);
                    return;
                }
                case getmyoffer: {
                    OfferIdOptionParser opts = new OfferIdOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    OfferInfo offer = client.getMyOffer(offerId);
                    new TableBuilder(TableType.OFFER_TBL, offer).build().print(System.out);
                    return;
                }
                case getoffers: {
                    String currencyCode;
                    GetOffersOptionParser opts = new GetOffersOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String direction = opts.getDirection();
                    List<OfferInfo> offers = client.getOffers(direction, currencyCode = opts.getCurrencyCode());
                    if (offers.isEmpty()) {
                        System.out.printf("no %s %s offers found%n", direction, currencyCode);
                    } else {
                        new TableBuilder(TableType.OFFER_TBL, offers).build().print(System.out);
                    }
                    return;
                }
                case getmyoffers: {
                    String currencyCode;
                    GetOffersOptionParser opts = new GetOffersOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String direction = opts.getDirection();
                    List<OfferInfo> offers = client.getMyOffers(direction, currencyCode = opts.getCurrencyCode());
                    if (offers.isEmpty()) {
                        System.out.printf("no %s %s offers found%n", direction, currencyCode);
                    } else {
                        new TableBuilder(TableType.OFFER_TBL, offers).build().print(System.out);
                    }
                    return;
                }
                case takeoffer: {
                    TakeOfferOptionParser opts = new TakeOfferOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String offerId = opts.getOfferId();
                    String paymentAccountId = opts.getPaymentAccountId();
                    TradeInfo trade = client.takeOffer(offerId, paymentAccountId);
                    System.out.printf("trade %s successfully taken%n", trade.getTradeId());
                    return;
                }
                case gettrade: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    boolean showContract = opts.getShowContract();
                    TradeInfo trade = client.getTrade(tradeId);
                    if (showContract) {
                        System.out.println(trade.getContractAsJson());
                    } else {
                        new TableBuilder(TableType.TRADE_DETAIL_TBL, trade).build().print(System.out);
                    }
                    return;
                }
                case gettrades: {
                    List<TradeInfo> trades;
                    GetTradesOptionParser opts = new GetTradesOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    GetTradesRequest.Category category = opts.getCategory();
                    List<TradeInfo> list = trades = category.equals((Object)GetTradesRequest.Category.OPEN) ? client.getOpenTrades() : client.getTradeHistory(category);
                    if (trades.isEmpty()) {
                        System.out.printf("no %s trades found%n", category.name().toLowerCase());
                    } else {
                        TableType tableType = category.equals((Object)GetTradesRequest.Category.OPEN) ? TableType.OPEN_TRADES_TBL : (category.equals((Object)GetTradesRequest.Category.CLOSED) ? TableType.CLOSED_TRADES_TBL : TableType.FAILED_TRADES_TBL);
                        new TableBuilder(tableType, trades).build().print(System.out);
                    }
                    return;
                }
                case confirmpaymentsent: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.confirmPaymentSent(tradeId);
                    System.out.printf("trade %s payment started message sent%n", tradeId);
                    return;
                }
                case confirmpaymentreceived: {
                    GetTradeOptionParser opts = new GetTradeOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    client.confirmPaymentReceived(tradeId);
                    System.out.printf("trade %s payment received message sent%n", tradeId);
                    return;
                }
                case withdrawfunds: {
                    WithdrawFundsOptionParser opts = new WithdrawFundsOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String tradeId = opts.getTradeId();
                    String address = opts.getAddress();
                    String memo = opts.getMemo();
                    client.withdrawFunds(tradeId, address, memo);
                    System.out.printf("trade %s funds sent to btc address %s%n", tradeId, address);
                    return;
                }
                case getpaymentmethods: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<PaymentMethod> paymentMethods = client.getPaymentMethods();
                    paymentMethods.forEach(p -> System.out.println(p.getId()));
                    return;
                }
                case getpaymentacctform: {
                    GetPaymentAcctFormOptionParser opts = new GetPaymentAcctFormOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String paymentMethodId = opts.getPaymentMethodId();
                    String jsonString = client.getPaymentAcctFormAsJson(paymentMethodId);
                    File jsonFile = CliMain.saveFileToDisk(paymentMethodId.toLowerCase(), ".json", jsonString);
                    System.out.printf("payment account form %s%nsaved to %s%n", jsonString, jsonFile.getAbsolutePath());
                    System.out.println("Edit the file, and use as the argument to a 'createpaymentacct' command.");
                    return;
                }
                case createpaymentacct: {
                    String jsonString;
                    CreatePaymentAcctOptionParser opts = new CreatePaymentAcctOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    Path paymentAccountForm = opts.getPaymentAcctForm();
                    try {
                        jsonString = new String(Files.readAllBytes(paymentAccountForm));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("could not read %s", paymentAccountForm));
                    }
                    PaymentAccount paymentAccount = client.createPaymentAccount(jsonString);
                    System.out.println("payment account saved");
                    new TableBuilder(TableType.PAYMENT_ACCOUNT_TBL, paymentAccount).build().print(System.out);
                    return;
                }
                case createcryptopaymentacct: {
                    CreateCryptoCurrencyPaymentAcctOptionParser opts = new CreateCryptoCurrencyPaymentAcctOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String accountName = opts.getAccountName();
                    String currencyCode = opts.getCurrencyCode();
                    String address = opts.getAddress();
                    boolean isTradeInstant = opts.getIsTradeInstant();
                    PaymentAccount paymentAccount = client.createCryptoCurrencyPaymentAccount(accountName, currencyCode, address, isTradeInstant);
                    System.out.println("payment account saved");
                    new TableBuilder(TableType.PAYMENT_ACCOUNT_TBL, paymentAccount).build().print(System.out);
                    return;
                }
                case getpaymentaccts: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    List<PaymentAccount> paymentAccounts = client.getPaymentAccounts();
                    if (paymentAccounts.size() > 0) {
                        new TableBuilder(TableType.PAYMENT_ACCOUNT_TBL, paymentAccounts).build().print(System.out);
                    } else {
                        System.out.println("no payment accounts are saved");
                    }
                    return;
                }
                case lockwallet: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    client.lockWallet();
                    System.out.println("wallet locked");
                    return;
                }
                case unlockwallet: {
                    UnlockWalletOptionParser opts = new UnlockWalletOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String walletPassword = opts.getPassword();
                    long timeout = opts.getUnlockTimeout();
                    client.unlockWallet(walletPassword, timeout);
                    System.out.println("wallet unlocked");
                    return;
                }
                case removewalletpassword: {
                    RemoveWalletPasswordOptionParser opts = new RemoveWalletPasswordOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String walletPassword = opts.getPassword();
                    client.removeWalletPassword(walletPassword);
                    System.out.println("wallet decrypted");
                    return;
                }
                case setwalletpassword: {
                    SetWalletPasswordOptionParser opts = new SetWalletPasswordOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String walletPassword = opts.getPassword();
                    String newWalletPassword = opts.getNewPassword();
                    client.setWalletPassword(walletPassword, newWalletPassword);
                    System.out.println("wallet encrypted" + (!newWalletPassword.isEmpty() ? " with new password" : ""));
                    return;
                }
                case registerdisputeagent: {
                    RegisterDisputeAgentOptionParser opts = new RegisterDisputeAgentOptionParser(args).parse();
                    if (opts.isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    String disputeAgentType = opts.getDisputeAgentType();
                    String registrationKey = opts.getRegistrationKey();
                    client.registerDisputeAgent(disputeAgentType, registrationKey);
                    System.out.println(disputeAgentType + " registered");
                    return;
                }
                case stop: {
                    if (new SimpleMethodOptionParser(args).parse().isForHelp()) {
                        System.out.println(client.getMethodHelp(method));
                        return;
                    }
                    client.stopServer();
                    System.out.println("server shutdown signal received");
                    return;
                }
            }
            throw new RuntimeException(String.format("unhandled method '%s'", new Object[]{method}));
        }
        catch (StatusRuntimeException ex) {
            String message = ex.getMessage().replaceFirst("^[A-Z_]+: ", "");
            if (message.equals("io exception")) {
                throw new RuntimeException(message + ", server may not be running", ex);
            }
            throw new RuntimeException(message, ex);
        }
    }

    private static Method getMethodFromCmd(String methodName) {
        return Method.valueOf(methodName.toLowerCase());
    }

    private static void verifyStringIsValidDecimal(String optionLabel, String optionValue) {
        try {
            Double.parseDouble(optionValue);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("--%s=%s, '%s' is not a number", optionLabel, optionValue, optionValue));
        }
    }

    private static void verifyStringIsValidLong(String optionLabel, String optionValue) {
        try {
            Long.parseLong(optionValue);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("--%s=%s, '%s' is not a number", optionLabel, optionValue, optionValue));
        }
    }

    private static long toLong(String param) {
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("'%s' is not a number", param));
        }
    }

    private static File saveFileToDisk(String prefix, String suffix, String text) {
        String timestamp = Long.toUnsignedString(new Date().getTime());
        String relativeFileName = prefix + "_" + timestamp + suffix;
        try {
            Path path = Paths.get(relativeFileName, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                try (PrintWriter out = new PrintWriter(path.toString());){
                    out.println(text);
                }
                return path.toAbsolutePath().toFile();
            }
            throw new IllegalStateException(String.format("could not overwrite existing file '%s'", relativeFileName));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(String.format("could not create file '%s'", relativeFileName));
        }
    }

    private static void printHelp(OptionParser parser, PrintStream stream) {
        try {
            stream.println("Haveno RPC Client");
            stream.println();
            stream.println("Usage: haveno-cli [options] <method> [params]");
            stream.println();
            parser.printHelpOn((OutputStream)stream);
            stream.println();
            String rowFormat = "%-25s%-52s%s%n";
            stream.format(rowFormat, "Method", "Params", "Description");
            stream.format(rowFormat, "------", "------", "------------");
            stream.format(rowFormat, Method.getversion.name(), "", "Get server version");
            stream.println();
            stream.format(rowFormat, Method.getbalance.name(), "[--currency-code=<bsq|btc>]", "Get server wallet balances");
            stream.println();
            stream.format(rowFormat, Method.getaddressbalance.name(), "--address=<btc-address>", "Get server wallet address balance");
            stream.println();
            stream.format(rowFormat, Method.getbtcprice.name(), "--currency-code=<currency-code>", "Get current market btc price");
            stream.println();
            stream.format(rowFormat, Method.getfundingaddresses.name(), "", "Get BTC funding addresses");
            stream.println();
            stream.format(rowFormat, Method.getunusedbsqaddress.name(), "", "Get unused BSQ address");
            stream.println();
            stream.format(rowFormat, "", "[--tx-fee-rate=<sats/byte>]", "");
            stream.println();
            stream.format(rowFormat, Method.sendbtc.name(), "--address=<btc-address> --amount=<btc-amount> \\", "Send BTC");
            stream.format(rowFormat, "", "[--tx-fee-rate=<sats/byte>]", "");
            stream.format(rowFormat, "", "[--memo=<\"memo\">]", "");
            stream.println();
            stream.format(rowFormat, Method.gettxfeerate.name(), "", "Get current tx fee rate in sats/byte");
            stream.println();
            stream.format(rowFormat, Method.settxfeerate.name(), "--tx-fee-rate=<sats/byte>", "Set custom tx fee rate in sats/byte");
            stream.println();
            stream.format(rowFormat, Method.unsettxfeerate.name(), "", "Unset custom tx fee rate");
            stream.println();
            stream.format(rowFormat, Method.gettransaction.name(), "--transaction-id=<transaction-id>", "Get transaction with id");
            stream.println();
            stream.format(rowFormat, Method.createoffer.name(), "--payment-account=<payment-account-id> \\", "Create and place an offer");
            stream.format(rowFormat, "", "--direction=<buy|sell> \\", "");
            stream.format(rowFormat, "", "--currency-code=<currency-code> \\", "");
            stream.format(rowFormat, "", "--amount=<btc-amount> \\", "");
            stream.format(rowFormat, "", "[--min-amount=<min-btc-amount>] \\", "");
            stream.format(rowFormat, "", "--fixed-price=<price> | --market-price-margin=<percent> \\", "");
            stream.format(rowFormat, "", "--security-deposit=<percent> \\", "");
            stream.format(rowFormat, "", "[--fee-currency=<bsq|btc>]", "");
            stream.format(rowFormat, "", "[--trigger-price=<price>]", "");
            stream.format(rowFormat, "", "[--swap=<true|false>]", "");
            stream.println();
            stream.format(rowFormat, Method.editoffer.name(), "--offer-id=<offer-id> \\", "Edit offer with id");
            stream.format(rowFormat, "", "[--fixed-price=<price>] \\", "");
            stream.format(rowFormat, "", "[--market-price-margin=<percent>] \\", "");
            stream.format(rowFormat, "", "[--trigger-price=<price>] \\", "");
            stream.format(rowFormat, "", "[--enabled=<true|false>]", "");
            stream.println();
            stream.format(rowFormat, Method.canceloffer.name(), "--offer-id=<offer-id>", "Cancel offer with id");
            stream.println();
            stream.format(rowFormat, Method.getoffer.name(), "--offer-id=<offer-id>", "Get current offer with id");
            stream.println();
            stream.format(rowFormat, Method.getmyoffer.name(), "--offer-id=<offer-id>", "Get my current offer with id");
            stream.println();
            stream.format(rowFormat, Method.getoffers.name(), "--direction=<buy|sell> \\", "Get current offers");
            stream.format(rowFormat, "", "--currency-code=<currency-code>", "");
            stream.println();
            stream.format(rowFormat, Method.getmyoffers.name(), "--direction=<buy|sell> \\", "Get my current offers");
            stream.format(rowFormat, "", "--currency-code=<currency-code>", "");
            stream.println();
            stream.format(rowFormat, Method.takeoffer.name(), "--offer-id=<offer-id> \\", "Take offer with id");
            stream.format(rowFormat, "", "[--payment-account=<payment-account-id>]", "");
            stream.format(rowFormat, "", "[--fee-currency=<btc|bsq>]", "");
            stream.println();
            stream.format(rowFormat, Method.gettrade.name(), "--trade-id=<trade-id> \\", "Get trade summary or full contract");
            stream.format(rowFormat, "", "[--show-contract=<true|false>]", "");
            stream.println();
            stream.format(rowFormat, Method.gettrades.name(), "[--category=<open|closed|failed>]", "Get open (default), closed, or failed trades");
            stream.println();
            stream.format(rowFormat, Method.confirmpaymentsent.name(), "--trade-id=<trade-id>", "Confirm payment started");
            stream.println();
            stream.format(rowFormat, Method.confirmpaymentreceived.name(), "--trade-id=<trade-id>", "Confirm payment received");
            stream.println();
            stream.format(rowFormat, Method.closetrade.name(), "--trade-id=<trade-id>", "Close completed trade");
            stream.println();
            stream.format(rowFormat, Method.withdrawfunds.name(), "--trade-id=<trade-id> --address=<btc-address> \\", "Withdraw received trade funds to external wallet address");
            stream.format(rowFormat, "", "[--memo=<\"memo\">]", "");
            stream.println();
            stream.format(rowFormat, Method.failtrade.name(), "--trade-id=<trade-id>", "Change open trade to failed trade");
            stream.println();
            stream.format(rowFormat, Method.unfailtrade.name(), "--trade-id=<trade-id>", "Change failed trade to open trade");
            stream.println();
            stream.format(rowFormat, Method.getpaymentmethods.name(), "", "Get list of supported payment account method ids");
            stream.println();
            stream.format(rowFormat, Method.getpaymentacctform.name(), "--payment-method-id=<payment-method-id>", "Get a new payment account form");
            stream.println();
            stream.format(rowFormat, Method.createpaymentacct.name(), "--payment-account-form=<path>", "Create a new payment account");
            stream.println();
            stream.format(rowFormat, Method.createcryptopaymentacct.name(), "--account-name=<name> \\", "Create a new cryptocurrency payment account");
            stream.format(rowFormat, "", "--currency-code=<bsq> \\", "");
            stream.format(rowFormat, "", "--address=<bsq-address>", "");
            stream.format(rowFormat, "", "--trade-instant=<true|false>", "");
            stream.println();
            stream.format(rowFormat, Method.getpaymentaccts.name(), "", "Get user payment accounts");
            stream.println();
            stream.format(rowFormat, Method.lockwallet.name(), "", "Remove wallet password from memory, locking the wallet");
            stream.println();
            stream.format(rowFormat, Method.unlockwallet.name(), "--wallet-password=<password> --timeout=<seconds>", "Store wallet password in memory for timeout seconds");
            stream.println();
            stream.format(rowFormat, Method.setwalletpassword.name(), "--wallet-password=<password> \\", "Encrypt wallet with password, or set new password on encrypted wallet");
            stream.format(rowFormat, "", "[--new-wallet-password=<new-password>]", "");
            stream.println();
            stream.format(rowFormat, Method.stop.name(), "", "Shut down the server");
            stream.println();
            stream.println("Method Help Usage: haveno-cli [options] <method> --help");
            stream.println();
        }
        catch (IOException ex) {
            ex.printStackTrace(stream);
        }
    }
}

