/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import haveno.common.util.DesktopUtil;
import haveno.common.util.InvalidVersionException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.bitcoinj.core.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger log = LoggerFactory.getLogger(Utilities.class);

    public static ExecutorService getFixedThreadPoolExecutor(int nThreads, ThreadFactory threadFactory) {
        return Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public static ListeningExecutorService getListeningExecutorService(String name, int corePoolSize, int maximumPoolSize, long keepAliveTimeInSec) {
        return Utilities.getListeningExecutorService(name, corePoolSize, maximumPoolSize, maximumPoolSize, keepAliveTimeInSec);
    }

    public static ListeningExecutorService getListeningExecutorService(String name, int corePoolSize, int maximumPoolSize, int queueCapacity, long keepAliveTimeInSec) {
        return MoreExecutors.listeningDecorator((ExecutorService)Utilities.getThreadPoolExecutor(name, corePoolSize, maximumPoolSize, queueCapacity, keepAliveTimeInSec));
    }

    public static ListeningExecutorService getListeningExecutorService(String name, int corePoolSize, int maximumPoolSize, long keepAliveTimeInSec, BlockingQueue<Runnable> workQueue) {
        return MoreExecutors.listeningDecorator((ExecutorService)Utilities.getThreadPoolExecutor(name, corePoolSize, maximumPoolSize, keepAliveTimeInSec, workQueue));
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTimeInSec) {
        return Utilities.getThreadPoolExecutor(name, corePoolSize, maximumPoolSize, maximumPoolSize, keepAliveTimeInSec);
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, int queueCapacity, long keepAliveTimeInSec) {
        return Utilities.getThreadPoolExecutor(name, corePoolSize, maximumPoolSize, keepAliveTimeInSec, new ArrayBlockingQueue<Runnable>(queueCapacity));
    }

    private static ThreadPoolExecutor getThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTimeInSec, BlockingQueue<Runnable> workQueue) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(name + "-%d").setDaemon(true).build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTimeInSec, TimeUnit.SECONDS, workQueue, threadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, long timeout, TimeUnit unit) {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)timeout, (TimeUnit)unit);
    }

    public static <V> FutureCallback<V> failureCallback(final Consumer<Throwable> errorHandler) {
        return new FutureCallback<V>(){

            public void onSuccess(V result) {
            }

            public void onFailure(@NotNull Throwable t) {
                errorHandler.accept(t);
            }
        };
    }

    public static boolean isMacMenuBarDarkMode() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            process.waitFor(100L, TimeUnit.MILLISECONDS);
            return process.exitValue() == 0;
        }
        catch (IOException | IllegalThreadStateException | InterruptedException ex) {
            return false;
        }
    }

    public static boolean isUnix() {
        return Utilities.isOSX() || Utilities.isLinux() || Utilities.getOSName().contains("freebsd");
    }

    public static boolean isWindows() {
        return Utilities.getOSName().contains("win");
    }

    public static boolean isQubesOS() {
        return Utilities.getOSVersion().contains("qubes");
    }

    public static boolean isOSX() {
        return Utilities.getOSName().contains("mac") || Utilities.getOSName().contains("darwin");
    }

    public static boolean isLinux() {
        return Utilities.getOSName().contains("linux");
    }

    public static boolean isDebianLinux() {
        return Utilities.isLinux() && new File("/etc/debian_version").isFile();
    }

    public static boolean isRedHatLinux() {
        return Utilities.isLinux() && new File("/etc/redhat-release").isFile();
    }

    private static String getOSName() {
        return System.getProperty("os.name").toLowerCase(Locale.US);
    }

    public static String getOSVersion() {
        return System.getProperty("os.version").toLowerCase(Locale.US);
    }

    public static File getUserDataDir() {
        if (Utilities.isWindows()) {
            return new File(System.getenv("APPDATA"));
        }
        if (Utilities.isOSX()) {
            return Paths.get(System.getProperty("user.home"), "Library", "Application Support").toFile();
        }
        return Paths.get(System.getProperty("user.home"), ".local", "share").toFile();
    }

    public static int getMinorVersion() throws InvalidVersionException {
        String version = Utilities.getOSVersion();
        String[] tokens = version.split("\\.");
        try {
            Preconditions.checkArgument((tokens.length > 1 ? 1 : 0) != 0);
            return Integer.parseInt(tokens[1]);
        }
        catch (IllegalArgumentException e) {
            Utilities.printSysInfo();
            throw new InvalidVersionException("Version is not in expected format. Version=" + version);
        }
    }

    public static int getMajorVersion() throws InvalidVersionException {
        String version = Utilities.getOSVersion();
        String[] tokens = version.split("\\.");
        try {
            Preconditions.checkArgument((tokens.length > 0 ? 1 : 0) != 0);
            return Integer.parseInt(tokens[0]);
        }
        catch (IllegalArgumentException e) {
            Utilities.printSysInfo();
            throw new InvalidVersionException("Version is not in expected format. Version=" + version);
        }
    }

    public static String getOSArchitecture() {
        String osArch = System.getProperty("os.arch");
        if (Utilities.isWindows()) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            return arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        }
        if (osArch.contains("arm")) {
            return osArch.contains("64") || osArch.contains("v8") ? "64" : "32";
        }
        if (Utilities.isLinux()) {
            return osArch.startsWith("i") ? "32" : "64";
        }
        return osArch.contains("64") ? "64" : osArch;
    }

    public static void printSysInfo() {
        log.info("System info: os.name={}; os.version={}; os.arch={}; sun.arch.data.model={}; JRE={}; JVM={}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), Utilities.getJVMArchitecture(), System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")", System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")"});
    }

    public static String getJVMArchitecture() {
        return System.getProperty("sun.arch.data.model");
    }

    public static boolean isCorrectOSArchitecture() {
        boolean result = Utilities.getOSArchitecture().endsWith(Utilities.getJVMArchitecture());
        if (!result) {
            log.warn("System.getProperty(\"os.arch\") " + System.getProperty("os.arch"));
            log.warn("System.getenv(\"ProgramFiles(x86)\") " + System.getenv("ProgramFiles(x86)"));
            log.warn("System.getenv(\"PROCESSOR_ARCHITECTURE\")" + System.getenv("PROCESSOR_ARCHITECTURE"));
            log.warn("System.getenv(\"PROCESSOR_ARCHITEW6432\") " + System.getenv("PROCESSOR_ARCHITEW6432"));
            log.warn("System.getProperty(\"sun.arch.data.model\") " + System.getProperty("sun.arch.data.model"));
        }
        return result;
    }

    public static void openURI(URI uri) throws IOException {
        if (!DesktopUtil.browse(uri)) {
            throw new IOException("Failed to open URI: " + String.valueOf(uri));
        }
    }

    public static void openFile(File file) throws IOException {
        if (!DesktopUtil.open(file)) {
            throw new IOException("Failed to open file: " + String.valueOf(file));
        }
    }

    public static String getDownloadOfHomeDir() {
        File file = new File(Utilities.getSystemHomeDirectory() + "/Downloads");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return Utilities.getSystemHomeDirectory();
    }

    public static void copyToClipboard(String content) {
        try {
            if (content != null && content.length() > 0) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(content);
                clipboard.setContent((Map)clipboardContent);
            }
        }
        catch (Throwable e) {
            log.error("copyToClipboard failed: {}\n", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void setThreadName(String name) {
        Thread.currentThread().setName(name + "-" + new Random().nextInt(10000));
    }

    public static boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public static String getSystemHomeDirectory() {
        return Utilities.isWindows() ? System.getenv("USERPROFILE") : System.getProperty("user.home");
    }

    public static String encodeToHex(@Nullable byte[] bytes, boolean allowNullable) {
        if (allowNullable) {
            return bytes != null ? Utils.HEX.encode(bytes) : "null";
        }
        return Utils.HEX.encode((byte[])Preconditions.checkNotNull((Object)bytes, (Object)"bytes must not be null at encodeToHex"));
    }

    public static String bytesAsHexString(@Nullable byte[] bytes) {
        return Utilities.encodeToHex(bytes, true);
    }

    public static String encodeToHex(@Nullable byte[] bytes) {
        return Utilities.encodeToHex(bytes, false);
    }

    public static byte[] decodeFromHex(String encoded) {
        return Utils.HEX.decode((CharSequence)encoded);
    }

    public static boolean isAltOrCtrlPressed(KeyCode keyCode, KeyEvent keyEvent) {
        return Utilities.isAltPressed(keyCode, keyEvent) || Utilities.isCtrlPressed(keyCode, keyEvent);
    }

    public static boolean isCtrlPressed(KeyCode keyCode, KeyEvent keyEvent) {
        return new KeyCodeCombination(keyCode, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}).match(keyEvent) || new KeyCodeCombination(keyCode, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}).match(keyEvent);
    }

    public static boolean isAltPressed(KeyCode keyCode, KeyEvent keyEvent) {
        return new KeyCodeCombination(keyCode, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}).match(keyEvent);
    }

    public static boolean isCtrlShiftPressed(KeyCode keyCode, KeyEvent keyEvent) {
        return new KeyCodeCombination(keyCode, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}).match(keyEvent);
    }

    public static byte[] concatenateByteArrays(byte[] array1, byte[] array2) {
        return ArrayUtils.addAll((byte[])array1, (byte[])array2);
    }

    public static Date getUTCDate(int year, int month, int dayOfMonth) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, dayOfMonth);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return calendar.getTime();
    }

    public static Set<String> commaSeparatedListToSet(String stringList, boolean allowWhitespace) {
        if (stringList != null) {
            return Splitter.on((String)",").splitToList((CharSequence)(allowWhitespace ? stringList : StringUtils.deleteWhitespace((String)stringList))).stream().filter(e -> !e.isEmpty()).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    public static String getPathOfCodeSource() throws URISyntaxException {
        return new File(Utilities.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
    }

    public static String toTruncatedString(Object message) {
        return Utilities.toTruncatedString(message, 200, true);
    }

    public static String toTruncatedString(Object message, int maxLength) {
        return Utilities.toTruncatedString(message, maxLength, true);
    }

    public static String toTruncatedString(Object message, int maxLength, boolean removeLineBreaks) {
        if (message == null) {
            return "null";
        }
        String result = StringUtils.abbreviate((String)message.toString(), (int)maxLength);
        if (removeLineBreaks) {
            return result.replace("\n", "");
        }
        return result;
    }

    public static List<String> toListOfWrappedStrings(String s, int wrapLength) {
        StringBuilder sb = new StringBuilder(s);
        int i = 0;
        while (i + wrapLength < sb.length() && (i = sb.lastIndexOf(" ", i + wrapLength)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        String[] splitLine = sb.toString().split("\n");
        return Arrays.asList(splitLine);
    }

    public static String getRandomPrefix(int minLength, int maxLength) {
        int length = minLength + new Random().nextInt(maxLength - minLength + 1);
        String result = switch (new Random().nextInt(3)) {
            case 0 -> RandomStringUtils.randomAlphabetic((int)length);
            case 1 -> RandomStringUtils.randomNumeric((int)length);
            default -> RandomStringUtils.randomAlphanumeric((int)length);
        };
        switch (new Random().nextInt(3)) {
            case 0: {
                result = result.toUpperCase();
                break;
            }
            case 1: {
                result = result.toLowerCase();
                break;
            }
        }
        return result;
    }

    public static String getShortId(String id) {
        return Utilities.getShortId(id, "-");
    }

    public static String getShortId(String id, String sep) {
        String[] chunks = id.split(sep);
        if (chunks.length > 0) {
            return chunks[0];
        }
        return id.substring(0, Math.min(8, id.length()));
    }

    public static byte[] integerToByteArray(int intValue, int numBytes) {
        byte[] bytes = new byte[numBytes];
        for (int i = numBytes - 1; i >= 0; --i) {
            bytes[i] = (byte)(intValue & 0xFF);
            intValue >>>= 8;
        }
        return bytes;
    }

    public static int byteArrayToInteger(byte[] bytes) {
        int result = 0;
        for (byte aByte : bytes) {
            result = result << 8 | aByte & 0xFF;
        }
        return result;
    }

    public static byte[] copyRightAligned(byte[] src, int newLength) {
        byte[] dest = new byte[newLength];
        int srcPos = Math.max(src.length - newLength, 0);
        int destPos = Math.max(newLength - src.length, 0);
        System.arraycopy(src, srcPos, dest, destPos, newLength - destPos);
        return dest;
    }

    public static byte[] intsToBytesBE(int[] ints) {
        byte[] bytes = new byte[ints.length * 4];
        int i = 0;
        for (int v : ints) {
            bytes[i++] = (byte)(v >> 24);
            bytes[i++] = (byte)(v >> 16);
            bytes[i++] = (byte)(v >> 8);
            bytes[i++] = (byte)v;
        }
        return bytes;
    }

    public static int[] bytesToIntsBE(byte[] bytes) {
        int[] ints = new int[bytes.length / 4];
        int j = 0;
        for (int i = 0; i < bytes.length / 4; ++i) {
            ints[i] = Ints.fromBytes((byte)bytes[j++], (byte)bytes[j++], (byte)bytes[j++], (byte)bytes[j++]);
        }
        return ints;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.###").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String formatDurationAsWords(long durationMillis) {
        Object format = "";
        String second = "second";
        String minute = "minute";
        String hour = "hour";
        String day = "day";
        String days = "days";
        String hours = "hours";
        String minutes = "minutes";
        String seconds = "seconds";
        if (durationMillis >= TimeUnit.DAYS.toMillis(1L)) {
            format = "d' " + days + ", '";
        }
        format = (String)format + "H' " + hours + ", 'm' " + minutes + ", 's'.'S' " + seconds + "'";
        String duration = durationMillis > 0L ? DurationFormatUtils.formatDuration((long)durationMillis, (String)format) : "";
        duration = StringUtils.replacePattern((String)duration, (String)("^1 " + seconds + "|\\b1 " + seconds), (String)("1 " + second));
        duration = StringUtils.replacePattern((String)duration, (String)("^1 " + minutes + "|\\b1 " + minutes), (String)("1 " + minute));
        duration = StringUtils.replacePattern((String)duration, (String)("^1 " + hours + "|\\b1 " + hours), (String)("1 " + hour));
        duration = StringUtils.replacePattern((String)duration, (String)("^1 " + days + "|\\b1 " + days), (String)("1 " + day));
        duration = duration.replace(", 0 seconds", "");
        duration = duration.replace(", 0 minutes", "");
        duration = duration.replace(", 0 hours", "");
        duration = StringUtils.replacePattern((String)duration, (String)"^0 days, ", (String)"");
        duration = StringUtils.replacePattern((String)duration, (String)"^0 hours, ", (String)"");
        duration = StringUtils.replacePattern((String)duration, (String)"^0 minutes, ", (String)"");
        String result = (duration = StringUtils.replacePattern((String)duration, (String)"^0 seconds, ", (String)"")).trim();
        if (result.isEmpty()) {
            result = "0.000 seconds";
        }
        return result;
    }

    public static String cleanString(String string) {
        return string.replaceAll("[\\t\\n\\r]+", " ");
    }
}

