/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class SingleThreadExecutorUtils {
    private SingleThreadExecutorUtils() {
    }

    public static ExecutorService getSingleThreadExecutor(Class<?> aClass) {
        SingleThreadExecutorUtils.validateClass(aClass);
        return SingleThreadExecutorUtils.getSingleThreadExecutor(aClass.getSimpleName());
    }

    public static ExecutorService getNonDaemonSingleThreadExecutor(Class<?> aClass) {
        SingleThreadExecutorUtils.validateClass(aClass);
        return SingleThreadExecutorUtils.getSingleThreadExecutor(aClass.getSimpleName(), false);
    }

    public static ExecutorService getSingleThreadExecutor(String name) {
        SingleThreadExecutorUtils.validateName(name);
        return SingleThreadExecutorUtils.getSingleThreadExecutor(name, true);
    }

    public static ListeningExecutorService getSingleThreadListeningExecutor(String name) {
        SingleThreadExecutorUtils.validateName(name);
        return MoreExecutors.listeningDecorator((ExecutorService)SingleThreadExecutorUtils.getSingleThreadExecutor(name));
    }

    public static ExecutorService getSingleThreadExecutor(ThreadFactory threadFactory) {
        SingleThreadExecutorUtils.validateThreadFactory(threadFactory);
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    private static ExecutorService getSingleThreadExecutor(String name, boolean isDaemonThread) {
        ThreadFactory threadFactory = SingleThreadExecutorUtils.getThreadFactory(name, isDaemonThread);
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    private static ThreadFactory getThreadFactory(String name, boolean isDaemonThread) {
        return new ThreadFactoryBuilder().setNameFormat(name + "-%d").setDaemon(isDaemonThread).build();
    }

    private static void validateClass(Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
    }

    private static void validateName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be null or empty.");
        }
    }

    private static void validateThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new IllegalArgumentException("ThreadFactory must not be null.");
        }
    }
}

