/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartUtil {
    private static final Logger log = LoggerFactory.getLogger(RestartUtil.class);
    public static final String SUN_JAVA_COMMAND = "sun.java.command";

    public static void restartApplication(String logPath) throws IOException {
        try {
            String java = System.getProperty("java.home") + "/bin/java";
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            StringBuilder vmArgsOneLine = new StringBuilder();
            vmArguments.stream().filter(arg -> !arg.contains("-agentlib")).forEach(arg -> {
                vmArgsOneLine.append((String)arg);
                vmArgsOneLine.append(" ");
            });
            StringBuilder cmd = new StringBuilder(java + " " + String.valueOf(vmArgsOneLine));
            String[] mainCommand = System.getProperty(SUN_JAVA_COMMAND).split(" ");
            if (mainCommand[0].endsWith(".jar")) {
                cmd.append("-jar ").append(new File(mainCommand[0]).getPath());
            } else {
                cmd.append("-cp \"").append(System.getProperty("java.class.path")).append("\" ").append(mainCommand[0]);
            }
            for (int i = 1; i < mainCommand.length; ++i) {
                cmd.append(" ");
                cmd.append(mainCommand[i]);
            }
            try {
                String command = "nohup " + cmd.toString() + " >/dev/null 2>" + logPath + " &";
                log.warn("\n\n############################################################\nExecuting cmd for restart: {}\n############################################################\n\n", (Object)command);
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new IOException("Error while trying to restart the application", e);
        }
    }
}

