/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import haveno.common.UserThread;
import haveno.common.util.Utilities;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profiler {
    private static final Logger log = LoggerFactory.getLogger(Profiler.class);

    public static void printSystemLoadPeriodically(long delay, TimeUnit timeUnit) {
        UserThread.runPeriodically(Profiler::printSystemLoad, delay, timeUnit);
    }

    public static void printSystemLoad() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        log.info("Total memory: {}; Used memory: {}; Free memory: {}; Max memory: {}; No. of threads: {}", new Object[]{Utilities.readableFileSize(total), Utilities.readableFileSize(used), Utilities.readableFileSize(free), Utilities.readableFileSize(runtime.maxMemory()), Thread.activeCount()});
    }

    public static long getUsedMemoryInMB() {
        return Profiler.getUsedMemoryInBytes() / 1024L / 1024L;
    }

    public static long getUsedMemoryInBytes() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        return total - free;
    }

    public static long getFreeMemoryInMB() {
        return Runtime.getRuntime().freeMemory() / 1024L / 1024L;
    }

    public static long getTotalMemoryInMB() {
        return Runtime.getRuntime().totalMemory() / 1024L / 1024L;
    }
}

