/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import haveno.common.UserThread;
import haveno.common.util.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcUtil {
    private static final Logger log = LoggerFactory.getLogger(GcUtil.class);
    private static boolean DISABLE_GC_CALLS = false;
    private static final int TRIGGER_MEM = 1000;
    private static final int TRIGGER_MAX_MEM = 3000;
    private static int totalInvocations;
    private static long totalGCTime;

    public static void autoReleaseMemory() {
        if (DISABLE_GC_CALLS) {
            return;
        }
        GcUtil.autoReleaseMemory(1000L);
    }

    public static void maybeReleaseMemory() {
        if (DISABLE_GC_CALLS) {
            return;
        }
        GcUtil.maybeReleaseMemory(3000L);
    }

    private static void autoReleaseMemory(long trigger) {
        UserThread.runPeriodically(() -> GcUtil.maybeReleaseMemory(trigger), 120L);
    }

    private static void maybeReleaseMemory(long trigger) {
        long ts = System.currentTimeMillis();
        long preGcMemory = Runtime.getRuntime().totalMemory();
        if (preGcMemory > trigger * 1024L * 1024L) {
            System.gc();
            long postGcMemory = Runtime.getRuntime().totalMemory();
            long duration = System.currentTimeMillis() - ts;
            log.info("GC reduced memory by {}. Total memory before/after: {}/{}. Free memory: {}. Took {} ms. Total GC invocations: {} / Total GC time {} sec", new Object[]{Utilities.readableFileSize(preGcMemory - postGcMemory), Utilities.readableFileSize(preGcMemory), Utilities.readableFileSize(postGcMemory), Utilities.readableFileSize(Runtime.getRuntime().freeMemory()), duration, ++totalInvocations, (double)(totalGCTime += duration) / 1000.0});
        }
    }

    public static void setDISABLE_GC_CALLS(boolean DISABLE_GC_CALLS) {
        GcUtil.DISABLE_GC_CALLS = DISABLE_GC_CALLS;
    }
}

