/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import java.util.DoubleSummaryStatistics;

public class DoubleSummaryStatisticsWithStdDev
extends DoubleSummaryStatistics {
    private double sumOfSquares;
    private double sumOfSquaresCompensation;
    private double simpleSumOfSquares;

    @Override
    public void accept(double value) {
        super.accept(value);
        double valueSquared = value * value;
        this.simpleSumOfSquares += valueSquared;
        this.sumOfSquaresWithCompensation(valueSquared);
    }

    public void combine(DoubleSummaryStatisticsWithStdDev other) {
        super.combine(other);
        this.simpleSumOfSquares += other.simpleSumOfSquares;
        this.sumOfSquaresWithCompensation(other.sumOfSquares);
        this.sumOfSquaresWithCompensation(other.sumOfSquaresCompensation);
    }

    private void sumOfSquaresWithCompensation(double valueSquared) {
        double tmp = valueSquared - this.sumOfSquaresCompensation;
        double velvel = this.sumOfSquares + tmp;
        this.sumOfSquaresCompensation = velvel - this.sumOfSquares - tmp;
        this.sumOfSquares = velvel;
    }

    private double getSumOfSquares() {
        double tmp = this.sumOfSquares + this.sumOfSquaresCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSumOfSquares)) {
            return this.simpleSumOfSquares;
        }
        return tmp;
    }

    private double getVariance() {
        double sumOfSquares = this.getSumOfSquares();
        long count = this.getCount();
        double mean = this.getAverage();
        return sumOfSquares / (double)count - mean * mean;
    }

    public final double getStandardDeviation() {
        double variance = this.getVariance();
        return Math.sqrt(variance);
    }
}

