/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.taskrunner;

import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.taskrunner.Model;
import haveno.common.taskrunner.Task;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunner<T extends Model> {
    private static final Logger log = LoggerFactory.getLogger(TaskRunner.class);
    private final Queue<Class<? extends Task<T>>> tasks = new LinkedBlockingQueue<Class<? extends Task<T>>>();
    private final T sharedModel;
    private final Class<T> sharedModelClass;
    private final ResultHandler resultHandler;
    private final ErrorMessageHandler errorMessageHandler;
    private boolean failed = false;
    private boolean isCanceled;
    private Class<? extends Task<T>> currentTask;

    public TaskRunner(T sharedModel, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this(sharedModel, sharedModel.getClass(), resultHandler, errorMessageHandler);
    }

    public TaskRunner(T sharedModel, Class<T> sharedModelClass, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.sharedModel = sharedModel;
        this.resultHandler = resultHandler;
        this.errorMessageHandler = errorMessageHandler;
        this.sharedModelClass = sharedModelClass;
    }

    @SafeVarargs
    public final void addTasks(Class<? extends Task<T>> ... items) {
        this.tasks.addAll(Arrays.asList(items));
    }

    public void run() {
        this.next();
    }

    private void next() {
        if (!this.failed && !this.isCanceled) {
            if (this.tasks.size() > 0) {
                try {
                    this.currentTask = this.tasks.poll();
                    log.info("Run task: " + this.currentTask.getSimpleName());
                    this.currentTask.getDeclaredConstructor(TaskRunner.class, this.sharedModelClass).newInstance(this, this.sharedModel).run();
                }
                catch (Throwable throwable) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)throwable));
                    this.handleErrorMessage("Error at taskRunner, error=" + throwable.getMessage());
                }
            } else {
                this.resultHandler.handleResult();
            }
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    void handleComplete() {
        this.next();
    }

    void handleErrorMessage(String errorMessage) {
        if (this.isCanceled) {
            return;
        }
        log.error("Task failed: " + this.currentTask.getSimpleName() + " / errorMessage: " + errorMessage);
        this.failed = true;
        this.errorMessageHandler.handleErrorMessage(errorMessage);
    }
}

