/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.setup;

import ch.qos.logback.classic.Level;
import haveno.common.UserThread;
import haveno.common.app.AsciiLogo;
import haveno.common.app.DevEnv;
import haveno.common.app.Log;
import haveno.common.app.Version;
import haveno.common.config.Config;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.common.setup.UncaughtExceptionHandler;
import haveno.common.util.Profiler;
import haveno.common.util.Utilities;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bitcoinj.store.BlockStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class CommonSetup {
    private static final Logger log = LoggerFactory.getLogger(CommonSetup.class);

    public static void setup(Config config, GracefulShutDownHandler gracefulShutDownHandler) {
        CommonSetup.setupLog(config);
        AsciiLogo.showAsciiLogo();
        Version.setBaseCryptoNetworkId(config.baseCurrencyNetwork.ordinal());
        Version.printVersion();
        CommonSetup.maybePrintPathOfCodeSource();
        Profiler.printSystemLoad();
        CommonSetup.setSystemProperties();
        CommonSetup.setupSigIntHandlers(gracefulShutDownHandler);
        DevEnv.setup(config);
    }

    public static void printSystemLoadPeriodically(int delayMin) {
        UserThread.runPeriodically(Profiler::printSystemLoad, delayMin, TimeUnit.MINUTES);
    }

    public static void setupUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.UncaughtExceptionHandler handler = (thread, throwable) -> {
            if (throwable.getCause() != null && throwable.getCause().getCause() != null && throwable.getCause().getCause() instanceof BlockStoreException) {
                log.error(throwable.getMessage());
            } else if (throwable instanceof ClassCastException && "sun.awt.image.BufImgSurfaceData cannot be cast to sun.java2d.xr.XRSurfaceData".equals(throwable.getMessage())) {
                log.warn(throwable.getMessage());
            } else if (throwable instanceof UnsupportedOperationException && "The system tray is not supported on the current platform.".equals(throwable.getMessage())) {
                log.warn(throwable.getMessage());
            } else {
                log.error("Uncaught Exception from thread {}, error={}\n", new Object[]{Thread.currentThread().getName(), throwable.getMessage(), throwable});
                UserThread.execute(() -> uncaughtExceptionHandler.handleUncaughtException(throwable, false));
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(handler);
        Thread.currentThread().setUncaughtExceptionHandler(handler);
    }

    private static void setupLog(Config config) {
        String logPath = Paths.get(config.appDataDir.getPath(), "haveno").toString();
        Log.setup(logPath);
        Utilities.printSysInfo();
        Log.setLevel(Level.toLevel((String)config.logLevel));
    }

    protected static void setSystemProperties() {
        if (Utilities.isLinux()) {
            System.setProperty("prism.lcdtext", "false");
        }
    }

    protected static void setupSigIntHandlers(GracefulShutDownHandler gracefulShutDownHandler) {
        Signal.handle(new Signal("INT"), signal -> {
            log.info("Received {}", (Object)signal);
            UserThread.execute(() -> gracefulShutDownHandler.gracefulShutDown(() -> {}));
        });
        Signal.handle(new Signal("TERM"), signal -> {
            log.info("Received {}", (Object)signal);
            UserThread.execute(() -> gracefulShutDownHandler.gracefulShutDown(() -> {}));
        });
    }

    protected static void maybePrintPathOfCodeSource() {
        try {
            String pathOfCodeSource = Utilities.getPathOfCodeSource();
            if (!pathOfCodeSource.endsWith("classes")) {
                log.info("Path to Haveno jar file: " + pathOfCodeSource);
            }
        }
        catch (URISyntaxException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

