/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.reactfx;

import haveno.common.reactfx.Timer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.util.Duration;

public class FxTimer
implements Timer {
    private final Duration actionTime;
    private final Timeline timeline;
    private final Runnable action;
    private long seq = 0L;

    public static Timer create(java.time.Duration delay, Runnable action) {
        return new FxTimer(delay, delay, action, 1);
    }

    public static Timer runLater(java.time.Duration delay, Runnable action) {
        Timer timer = FxTimer.create(delay, action);
        timer.restart();
        return timer;
    }

    public static Timer createPeriodic(java.time.Duration interval, Runnable action) {
        return new FxTimer(interval, interval, action, -1);
    }

    public static Timer runPeriodically(java.time.Duration interval, Runnable action) {
        Timer timer = FxTimer.createPeriodic(interval, action);
        timer.restart();
        return timer;
    }

    public static Timer createPeriodic0(java.time.Duration interval, Runnable action) {
        return new FxTimer(java.time.Duration.ZERO, interval, action, -1);
    }

    public static Timer runPeriodically0(java.time.Duration interval, Runnable action) {
        Timer timer = FxTimer.createPeriodic0(interval, action);
        timer.restart();
        return timer;
    }

    private FxTimer(java.time.Duration actionTime, java.time.Duration period, Runnable action, int cycles) {
        this.actionTime = Duration.millis((double)actionTime.toMillis());
        this.timeline = new Timeline();
        this.action = action;
        this.timeline.getKeyFrames().add((Object)new KeyFrame(this.actionTime, new KeyValue[0]));
        if (period != actionTime) {
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)period.toMillis()), new KeyValue[0]));
        }
        this.timeline.setCycleCount(cycles);
    }

    @Override
    public void restart() {
        this.stop();
        long expected = this.seq;
        this.timeline.getKeyFrames().set(0, (Object)new KeyFrame(this.actionTime, ae -> {
            if (this.seq == expected) {
                this.action.run();
            }
        }, new KeyValue[0]));
        this.timeline.play();
    }

    @Override
    public void stop() {
        this.timeline.stop();
        ++this.seq;
    }
}

