/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.proto;

import com.google.common.base.Enums;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import haveno.common.Proto;
import haveno.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoUtil {
    private static final Logger log = LoggerFactory.getLogger(ProtoUtil.class);

    public static Set<byte[]> byteSetFromProtoByteStringList(List<ByteString> byteStringList) {
        return byteStringList.stream().map(ByteString::toByteArray).collect(Collectors.toSet());
    }

    @Nullable
    public static String stringOrNullFromProto(String proto) {
        return "".equals(proto) ? null : proto;
    }

    @Nullable
    public static byte[] byteArrayOrNullFromProto(ByteString proto) {
        return proto.isEmpty() ? null : proto.toByteArray();
    }

    @Nullable
    public static <E extends Enum<E>> E enumFromProto(Class<E> enumType, String name) {
        String enumName = name != null ? name : "UNDEFINED";
        Enum result = (Enum)Enums.getIfPresent(enumType, (String)enumName).orNull();
        if (result == null) {
            result = (Enum)Enums.getIfPresent(enumType, (String)"UNDEFINED").orNull();
            log.debug("We try to lookup for an enum entry with name 'UNDEFINED' and use that if available, otherwise the enum is null. enum={}", (Object)result);
            return (E)result;
        }
        return (E)result;
    }

    public static <T extends Message> Iterable<T> collectionToProto(Collection<? extends Proto> collection, Class<T> messageType) {
        return collection.stream().map(e -> {
            Message message = e.toProtoMessage();
            try {
                return (Message)messageType.cast(message);
            }
            catch (ClassCastException t) {
                log.error("Message could not be cast. message={}, messageType={}", (Object)message, (Object)messageType);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> Iterable<T> collectionToProto(Collection<? extends Proto> collection, Function<? super Message, T> extra) {
        return collection.stream().map(o -> extra.apply(o.toProtoMessage())).collect(Collectors.toList());
    }

    public static List<String> protocolStringListToList(ProtocolStringList protocolStringList) {
        return CollectionUtils.isEmpty(protocolStringList) ? new ArrayList<String>() : new ArrayList(protocolStringList);
    }

    public static Set<String> protocolStringListToSet(ProtocolStringList protocolStringList) {
        return CollectionUtils.isEmpty(protocolStringList) ? new HashSet<String>() : new HashSet(protocolStringList);
    }
}

