/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.crypto;

import com.google.protobuf.ByteString;
import haveno.common.crypto.Sig;
import haveno.common.proto.network.NetworkPayload;
import java.security.PublicKey;
import java.util.Arrays;

public final class SealedAndSigned
implements NetworkPayload {
    private final byte[] encryptedSecretKey;
    private final byte[] encryptedPayloadWithHmac;
    private final byte[] signature;
    private final byte[] sigPublicKeyBytes;
    private final transient PublicKey sigPublicKey;

    public SealedAndSigned(byte[] encryptedSecretKey, byte[] encryptedPayloadWithHmac, byte[] signature, PublicKey sigPublicKey) {
        this.encryptedSecretKey = encryptedSecretKey;
        this.encryptedPayloadWithHmac = encryptedPayloadWithHmac;
        this.signature = signature;
        this.sigPublicKey = sigPublicKey;
        this.sigPublicKeyBytes = Sig.getPublicKeyBytes(sigPublicKey);
    }

    private SealedAndSigned(byte[] encryptedSecretKey, byte[] encryptedPayloadWithHmac, byte[] signature, byte[] sigPublicKeyBytes) {
        this.encryptedSecretKey = encryptedSecretKey;
        this.encryptedPayloadWithHmac = encryptedPayloadWithHmac;
        this.signature = signature;
        this.sigPublicKeyBytes = sigPublicKeyBytes;
        this.sigPublicKey = Sig.getPublicKeyFromBytes(sigPublicKeyBytes);
    }

    public protobuf.SealedAndSigned toProtoMessage() {
        return protobuf.SealedAndSigned.newBuilder().setEncryptedSecretKey(ByteString.copyFrom((byte[])this.encryptedSecretKey)).setEncryptedPayloadWithHmac(ByteString.copyFrom((byte[])this.encryptedPayloadWithHmac)).setSignature(ByteString.copyFrom((byte[])this.signature)).setSigPublicKeyBytes(ByteString.copyFrom((byte[])this.sigPublicKeyBytes)).build();
    }

    public static SealedAndSigned fromProto(protobuf.SealedAndSigned proto) {
        return new SealedAndSigned(proto.getEncryptedSecretKey().toByteArray(), proto.getEncryptedPayloadWithHmac().toByteArray(), proto.getSignature().toByteArray(), proto.getSigPublicKeyBytes().toByteArray());
    }

    public byte[] getEncryptedSecretKey() {
        return this.encryptedSecretKey;
    }

    public byte[] getEncryptedPayloadWithHmac() {
        return this.encryptedPayloadWithHmac;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getSigPublicKeyBytes() {
        return this.sigPublicKeyBytes;
    }

    public PublicKey getSigPublicKey() {
        return this.sigPublicKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SealedAndSigned)) {
            return false;
        }
        SealedAndSigned other = (SealedAndSigned)o;
        if (!Arrays.equals(this.getEncryptedSecretKey(), other.getEncryptedSecretKey())) {
            return false;
        }
        if (!Arrays.equals(this.getEncryptedPayloadWithHmac(), other.getEncryptedPayloadWithHmac())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        return Arrays.equals(this.getSigPublicKeyBytes(), other.getSigPublicKeyBytes());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getEncryptedSecretKey());
        result = result * 59 + Arrays.hashCode(this.getEncryptedPayloadWithHmac());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        result = result * 59 + Arrays.hashCode(this.getSigPublicKeyBytes());
        return result;
    }

    public String toString() {
        return "SealedAndSigned(encryptedSecretKey=" + Arrays.toString(this.getEncryptedSecretKey()) + ", encryptedPayloadWithHmac=" + Arrays.toString(this.getEncryptedPayloadWithHmac()) + ", signature=" + Arrays.toString(this.getSignature()) + ", sigPublicKeyBytes=" + Arrays.toString(this.getSigPublicKeyBytes()) + ", sigPublicKey=" + String.valueOf(this.getSigPublicKey()) + ")";
    }
}

