/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.crypto;

import com.google.protobuf.ByteString;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.wallet.Protos;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScryptUtil {
    private static final Logger log = LoggerFactory.getLogger(ScryptUtil.class);

    public static KeyCrypterScrypt getKeyCrypterScrypt() {
        return ScryptUtil.getKeyCrypterScrypt(KeyCrypterScrypt.randomSalt());
    }

    public static KeyCrypterScrypt getKeyCrypterScrypt(byte[] salt) {
        Protos.ScryptParameters scryptParameters = Protos.ScryptParameters.newBuilder().setP(6).setR(8).setN(32768L).setSalt(ByteString.copyFrom((byte[])salt)).build();
        return new KeyCrypterScrypt(scryptParameters);
    }

    public static KeyParameter deriveKeyWithScrypt(KeyCrypterScrypt keyCrypterScrypt, String password) {
        try {
            log.debug("Doing key derivation");
            long start = System.currentTimeMillis();
            KeyParameter aesKey = keyCrypterScrypt.deriveKey((CharSequence)password);
            long duration = System.currentTimeMillis() - start;
            log.debug("Key derivation took {} msec", (Object)duration);
            return aesKey;
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error("Key derivation failed. " + t.getMessage());
            throw t;
        }
    }

    public static void deriveKeyWithScrypt(KeyCrypterScrypt keyCrypterScrypt, String password, DeriveKeyResultHandler resultHandler) {
        Utilities.getThreadPoolExecutor("ScryptUtil:deriveKeyWithScrypt-%d", 1, 2, 5L).submit(() -> {
            try {
                KeyParameter aesKey = ScryptUtil.deriveKeyWithScrypt(keyCrypterScrypt, password);
                UserThread.execute(() -> {
                    try {
                        resultHandler.handleResult(aesKey);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        log.error("Executing task failed. " + t.getMessage());
                        throw t;
                    }
                });
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error("Executing task failed. " + t.getMessage());
                throw t;
            }
        });
    }

    public static interface DeriveKeyResultHandler {
        public void handleResult(KeyParameter var1);
    }
}

