/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.crypto;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import haveno.common.consensus.UsedForTradeContractJson;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.Sig;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.util.Utilities;
import java.security.PublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PubKeyRing
implements NetworkPayload,
UsedForTradeContractJson {
    private static final Logger log = LoggerFactory.getLogger(PubKeyRing.class);
    private final byte[] signaturePubKeyBytes;
    private final byte[] encryptionPubKeyBytes;
    private transient PublicKey signaturePubKey;
    private transient PublicKey encryptionPubKey;

    public PubKeyRing(PublicKey signaturePubKey, PublicKey encryptionPubKey) {
        this.signaturePubKeyBytes = Sig.getPublicKeyBytes(signaturePubKey);
        this.encryptionPubKeyBytes = Encryption.getPublicKeyBytes(encryptionPubKey);
        this.signaturePubKey = signaturePubKey;
        this.encryptionPubKey = encryptionPubKey;
    }

    @VisibleForTesting
    public PubKeyRing(byte[] signaturePubKeyBytes, byte[] encryptionPubKeyBytes) {
        this.signaturePubKeyBytes = signaturePubKeyBytes;
        this.encryptionPubKeyBytes = encryptionPubKeyBytes;
        this.signaturePubKey = Sig.getPublicKeyFromBytes(signaturePubKeyBytes);
        this.encryptionPubKey = Encryption.getPublicKeyFromBytes(encryptionPubKeyBytes);
    }

    public protobuf.PubKeyRing toProtoMessage() {
        return protobuf.PubKeyRing.newBuilder().setSignaturePubKeyBytes(ByteString.copyFrom((byte[])this.signaturePubKeyBytes)).setEncryptionPubKeyBytes(ByteString.copyFrom((byte[])this.encryptionPubKeyBytes)).build();
    }

    public static PubKeyRing fromProto(protobuf.PubKeyRing proto) {
        return new PubKeyRing(proto.getSignaturePubKeyBytes().toByteArray(), proto.getEncryptionPubKeyBytes().toByteArray());
    }

    public String toString() {
        return "PubKeyRing{signaturePubKeyHex=" + Utilities.bytesAsHexString(this.signaturePubKeyBytes) + ", encryptionPubKeyHex=" + Utilities.bytesAsHexString(this.encryptionPubKeyBytes) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubKeyRing)) {
            return false;
        }
        PubKeyRing other = (PubKeyRing)o;
        if (!Arrays.equals(this.getSignaturePubKeyBytes(), other.getSignaturePubKeyBytes())) {
            return false;
        }
        return Arrays.equals(this.getEncryptionPubKeyBytes(), other.getEncryptionPubKeyBytes());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSignaturePubKeyBytes());
        result = result * 59 + Arrays.hashCode(this.getEncryptionPubKeyBytes());
        return result;
    }

    public byte[] getSignaturePubKeyBytes() {
        return this.signaturePubKeyBytes;
    }

    public byte[] getEncryptionPubKeyBytes() {
        return this.encryptionPubKeyBytes;
    }

    public PublicKey getSignaturePubKey() {
        return this.signaturePubKey;
    }

    public PublicKey getEncryptionPubKey() {
        return this.encryptionPubKey;
    }
}

