/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.crypto;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.crypto.KeyStorage;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.Sig;
import java.security.KeyPair;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class KeyRing {
    private static final Logger log = LoggerFactory.getLogger(KeyRing.class);
    private final KeyStorage keyStorage;
    private SecretKey symmetricKey;
    private KeyPair signatureKeyPair;
    private KeyPair encryptionKeyPair;
    private PubKeyRing pubKeyRing;

    @Inject
    public KeyRing(KeyStorage keyStorage) {
        this(keyStorage, null, false);
    }

    public KeyRing(KeyStorage keyStorage, String password, boolean generateKeys) {
        this.keyStorage = keyStorage;
        try {
            this.unlockKeys(password, generateKeys);
        }
        catch (IncorrectPasswordException incorrectPasswordException) {
            // empty catch block
        }
    }

    public boolean isUnlocked() {
        boolean isUnlocked = this.symmetricKey != null && this.signatureKeyPair != null && this.encryptionKeyPair != null && this.pubKeyRing != null;
        return isUnlocked;
    }

    public void lockKeys() {
        this.signatureKeyPair = null;
        this.encryptionKeyPair = null;
        this.symmetricKey = null;
        this.pubKeyRing = null;
    }

    public boolean unlockKeys(@Nullable String password, boolean generateKeys) throws IncorrectPasswordException {
        if (this.isUnlocked()) {
            return true;
        }
        if (this.keyStorage.allKeyFilesExist()) {
            this.symmetricKey = this.keyStorage.loadSecretKey(KeyStorage.KeyEntry.SYM_ENCRYPTION, password);
            this.signatureKeyPair = this.keyStorage.loadKeyPair(KeyStorage.KeyEntry.MSG_SIGNATURE, this.symmetricKey);
            this.encryptionKeyPair = this.keyStorage.loadKeyPair(KeyStorage.KeyEntry.MSG_ENCRYPTION, this.symmetricKey);
            if (this.signatureKeyPair != null && this.encryptionKeyPair != null) {
                this.pubKeyRing = new PubKeyRing(this.signatureKeyPair.getPublic(), this.encryptionKeyPair.getPublic());
            }
        } else if (generateKeys) {
            this.generateKeys(password);
        }
        return this.isUnlocked();
    }

    public void generateKeys(String password) {
        if (this.isUnlocked()) {
            throw new IllegalStateException("Current keyring must be closed to generate new keys");
        }
        this.symmetricKey = Encryption.generateSecretKey(256);
        this.signatureKeyPair = Sig.generateKeyPair();
        this.encryptionKeyPair = Encryption.generateKeyPair();
        this.pubKeyRing = new PubKeyRing(this.signatureKeyPair.getPublic(), this.encryptionKeyPair.getPublic());
        this.keyStorage.saveKeyRing(this, null, password);
    }

    public String toString() {
        return "KeyRing{symmetricKey.hashCode()=" + this.symmetricKey.hashCode() + ", signatureKeyPair.hashCode()=" + this.signatureKeyPair.hashCode() + ", encryptionKeyPair.hashCode()=" + this.encryptionKeyPair.hashCode() + ", pubKeyRing.hashCode()=" + this.pubKeyRing.hashCode() + "}";
    }

    public KeyStorage getKeyStorage() {
        return this.keyStorage;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public KeyPair getSignatureKeyPair() {
        return this.signatureKeyPair;
    }

    public KeyPair getEncryptionKeyPair() {
        return this.encryptionKeyPair;
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyRing)) {
            return false;
        }
        KeyRing other = (KeyRing)o;
        KeyStorage this$keyStorage = this.getKeyStorage();
        KeyStorage other$keyStorage = other.getKeyStorage();
        if (this$keyStorage == null ? other$keyStorage != null : !this$keyStorage.equals(other$keyStorage)) {
            return false;
        }
        SecretKey this$symmetricKey = this.getSymmetricKey();
        SecretKey other$symmetricKey = other.getSymmetricKey();
        if (this$symmetricKey == null ? other$symmetricKey != null : !this$symmetricKey.equals(other$symmetricKey)) {
            return false;
        }
        KeyPair this$signatureKeyPair = this.getSignatureKeyPair();
        KeyPair other$signatureKeyPair = other.getSignatureKeyPair();
        if (this$signatureKeyPair == null ? other$signatureKeyPair != null : !this$signatureKeyPair.equals(other$signatureKeyPair)) {
            return false;
        }
        KeyPair this$encryptionKeyPair = this.getEncryptionKeyPair();
        KeyPair other$encryptionKeyPair = other.getEncryptionKeyPair();
        if (this$encryptionKeyPair == null ? other$encryptionKeyPair != null : !this$encryptionKeyPair.equals(other$encryptionKeyPair)) {
            return false;
        }
        PubKeyRing this$pubKeyRing = this.getPubKeyRing();
        PubKeyRing other$pubKeyRing = other.getPubKeyRing();
        return !(this$pubKeyRing == null ? other$pubKeyRing != null : !((Object)this$pubKeyRing).equals(other$pubKeyRing));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KeyStorage $keyStorage = this.getKeyStorage();
        result = result * 59 + ($keyStorage == null ? 43 : $keyStorage.hashCode());
        SecretKey $symmetricKey = this.getSymmetricKey();
        result = result * 59 + ($symmetricKey == null ? 43 : $symmetricKey.hashCode());
        KeyPair $signatureKeyPair = this.getSignatureKeyPair();
        result = result * 59 + ($signatureKeyPair == null ? 43 : $signatureKeyPair.hashCode());
        KeyPair $encryptionKeyPair = this.getEncryptionKeyPair();
        result = result * 59 + ($encryptionKeyPair == null ? 43 : $encryptionKeyPair.hashCode());
        PubKeyRing $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : ((Object)$pubKeyRing).hashCode());
        return result;
    }
}

